/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands;

import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.commands.Messages;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.Tag;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class HgTagClient {
    private static final Pattern GET_TAGS_PATTERN = Pattern.compile("^(.+[^ ]) +([0-9]+):([a-f0-9]+)( local)?$");

    public static Tag[] getTags(IProject project) throws HgException {
        HgCommand command = new HgCommand("tags", (IContainer)project, false);
        command.addOptions("-v");
        String[] lines = command.executeToString().split("\n");
        int length = lines.length;
        Tag[] tags = new Tag[length];
        int i = 0;
        while (i < length) {
            Tag tag;
            Matcher m = GET_TAGS_PATTERN.matcher(lines[i]);
            if (!m.matches()) {
                throw new HgException(String.valueOf(Messages.getString("HgTagClient.parseException")) + lines[i] + "'");
            }
            tags[i] = tag = new Tag(m.group(1), Integer.parseInt(m.group(2)), m.group(3), m.group(4) != null);
            ++i;
        }
        return tags;
    }

    public static void addTag(IResource resource, String name, String rev, String user, boolean local, boolean force) throws HgException {
        HgCommand command = new HgCommand("tag", (IContainer)resource.getProject(), false);
        if (local) {
            command.addOptions("-l");
        }
        if (force) {
            command.addOptions("-f");
        }
        if (rev != null) {
            command.addOptions("-r", rev);
        }
        command.addUserName(user);
        command.addOptions(name);
        command.executeToBytes();
    }
}

