/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands.extensions.mq;

import com.vectrace.MercurialEclipse.commands.AbstractClient;
import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.Patch;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HgQSeriesClient
extends AbstractClient {
    public static List<Patch> getPatchesInSeries(IResource resource) throws HgException {
        HgCommand command = new HgCommand("qseries", HgQSeriesClient.getWorkingDirectory(resource), true);
        command.addOptions("--config", "extensions.hgext.mq=");
        command.addOptions("-v");
        command.addOptions("--summary");
        return HgQSeriesClient.parse(command.executeToString());
    }

    public static List<Patch> parse(String executeToString) {
        ArrayList<Patch> list = new ArrayList<Patch>();
        if (executeToString != null && executeToString.indexOf("\n") >= 0) {
            String[] patches;
            String[] stringArray = patches = executeToString.split("\n");
            int n = patches.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                String[] components = string.split(":");
                String[] patchData = components[0].trim().split(" ");
                Patch p = new Patch();
                p.setIndex(patchData[0]);
                p.setApplied(patchData[1].equals("A"));
                p.setName(patchData[2].trim());
                if (components.length > 1) {
                    String summary = components[1].trim();
                    p.setSummary(summary);
                }
                list.add(p);
                ++n2;
            }
        }
        return list;
    }

    public static List<Patch> getPatchesNotInSeries(IResource resource) throws HgException {
        HgCommand command = new HgCommand("qseries", HgQSeriesClient.getWorkingDirectory(resource), true);
        command.addOptions("--config", "extensions.hgext.mq=");
        command.addOptions("--summary", "--missing");
        return HgQSeriesClient.parse(command.executeToString());
    }
}

