/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.dialogs;

import com.vectrace.MercurialEclipse.dialogs.CommitDialog;
import java.io.File;
import org.eclipse.core.resources.IResource;

public class CommitResource {
    private final String statusMessage;
    private final char status;
    private final File path;
    private final IResource resource;

    private String convertStatus(char statusChar, String originalString) {
        switch (statusChar) {
            case 'M': {
                return CommitDialog.FILE_MODIFIED;
            }
            case 'A': {
                return CommitDialog.FILE_ADDED;
            }
            case 'R': {
                return CommitDialog.FILE_REMOVED;
            }
            case '?': {
                return CommitDialog.FILE_UNTRACKED;
            }
            case '!': {
                return CommitDialog.FILE_DELETED;
            }
            case 'C': {
                return CommitDialog.FILE_CLEAN;
            }
        }
        return "status error: " + originalString;
    }

    private char getStatusChar(String statusToken) {
        if (statusToken.length() == 0) {
            return '\u0000';
        }
        return statusToken.charAt(0);
    }

    public CommitResource(String statusString, IResource resource, File path) {
        this.status = this.getStatusChar(statusString);
        this.statusMessage = this.convertStatus(this.status, statusString);
        this.resource = resource;
        this.path = path;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public char getStatus() {
        return this.status;
    }

    public IResource getResource() {
        return this.resource;
    }

    public File getPath() {
        return this.path;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CommitResource [status=");
        builder.append(this.statusMessage);
        builder.append(", path=");
        builder.append(this.path);
        builder.append(", resource=");
        builder.append(this.resource);
        builder.append("]");
        return builder.toString();
    }
}

