/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.dialogs;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.SafeUiJob;
import com.vectrace.MercurialEclipse.dialogs.Messages;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.Bookmark;
import com.vectrace.MercurialEclipse.model.Branch;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.model.Tag;
import com.vectrace.MercurialEclipse.storage.DataLoader;
import com.vectrace.MercurialEclipse.storage.FileDataLoader;
import com.vectrace.MercurialEclipse.storage.ProjectDataLoader;
import com.vectrace.MercurialEclipse.team.MercurialUtilities;
import com.vectrace.MercurialEclipse.team.ResourceProperties;
import com.vectrace.MercurialEclipse.team.cache.LocalChangesetCache;
import com.vectrace.MercurialEclipse.ui.BookmarkTable;
import com.vectrace.MercurialEclipse.ui.BranchTable;
import com.vectrace.MercurialEclipse.ui.ChangesetTable;
import com.vectrace.MercurialEclipse.ui.TagTable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class RevisionChooserDialog
extends Dialog {
    private final DataLoader dataLoader;
    private final String title;
    private Text text;
    private String revision;
    private Tag tag;
    private Branch branch;
    private Bookmark bookmark;
    private boolean defaultShowingHeads;
    private boolean disallowSelectingParents;
    private final int[] parents;
    private ChangeSet changeSet;

    public RevisionChooserDialog(Shell parentShell, String title, IFile file) {
        this(parentShell, title, new FileDataLoader(file));
    }

    public RevisionChooserDialog(Shell parentShell, String title, IProject project) {
        this(parentShell, title, new ProjectDataLoader(project));
    }

    public RevisionChooserDialog(Shell parentShell, String title, DataLoader loader) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.title = title;
        this.dataLoader = loader;
        int[] p = new int[]{};
        try {
            p = loader.getParents();
        }
        catch (HgException e) {
            MercurialEclipsePlugin.logError((Throwable)((Object)e));
        }
        this.parents = p;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout(1, true);
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("RevisionChooserDialog.rev.label"));
        this.text = new Text(composite, 2052);
        this.text.setLayoutData((Object)new GridData(768));
        TabFolder tabFolder = new TabFolder(composite, 0);
        GridData data = new GridData(1808);
        data.heightHint = 200;
        tabFolder.setLayoutData((Object)data);
        this.createRevisionTabItem(tabFolder);
        try {
            if (MercurialUtilities.isCommandAvailable("bookmarks", ResourceProperties.EXT_BOOKMARKS_AVAILABLE, "hgext.bookmarks=")) {
                this.createBookmarkTabItem(tabFolder);
            }
        }
        catch (HgException e) {
            MercurialEclipsePlugin.logError((Throwable)((Object)e));
        }
        this.createTagTabItem(tabFolder);
        this.createBranchTabItem(tabFolder);
        this.createHeadTabItem(tabFolder);
        return composite;
    }

    protected void okPressed() {
        String[] split = this.text.getText().split(":");
        this.revision = split[0].trim();
        if (this.changeSet == null) {
            IProject project = this.dataLoader.getProject();
            LocalChangesetCache localCache = LocalChangesetCache.getInstance();
            if (this.tag != null) {
                this.changeSet = localCache.getChangeset(project, String.valueOf(this.tag.getRevision()) + ":" + this.tag.getGlobalId());
            } else if (this.branch != null) {
                this.changeSet = localCache.getChangeset(project, String.valueOf(this.branch.getRevision()) + ":" + this.branch.getGlobalId());
            } else if (this.bookmark != null) {
                this.changeSet = localCache.getChangeset(project, String.valueOf(this.bookmark.getRevision()) + ":" + this.bookmark.getShortNodeId());
            }
        }
        if (this.changeSet != null) {
            this.revision = String.valueOf(this.changeSet.getChangesetIndex());
        }
        if (this.revision.length() == 0) {
            this.revision = null;
        }
        if (this.disallowSelectingParents) {
            int[] nArray = this.parents;
            int n = this.parents.length;
            int n2 = 0;
            while (n2 < n) {
                int p = nArray[n2];
                if (String.valueOf(p).equals(this.revision)) {
                    MessageBox mb = new MessageBox(this.getShell(), 8);
                    mb.setText("Merge");
                    mb.setMessage(Messages.getString("RevisionChooserDialog.cannotMergeWithParent"));
                    mb.open();
                    return;
                }
                ++n2;
            }
        }
        super.okPressed();
    }

    public String getRevision() {
        return this.revision;
    }

    protected TabItem createRevisionTabItem(TabFolder folder) {
        TabItem item = new TabItem(folder, 0);
        item.setText(Messages.getString("RevisionChooserDialog.revTab.name"));
        final ChangesetTable table = new ChangesetTable((Composite)folder, (IResource)this.dataLoader.getProject());
        table.setLayoutData(new GridData(1808));
        table.highlightParents(this.parents);
        table.setEnabled(true);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RevisionChooserDialog.this.tag = null;
                RevisionChooserDialog.this.branch = null;
                RevisionChooserDialog.this.bookmark = null;
                RevisionChooserDialog.this.text.setText(String.valueOf(table.getSelection().getChangesetIndex()) + ":" + table.getSelection().getChangeset());
                RevisionChooserDialog.this.changeSet = table.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                RevisionChooserDialog.this.okPressed();
            }
        });
        item.setControl((Control)table);
        return item;
    }

    protected TabItem createTagTabItem(TabFolder folder) {
        TabItem item = new TabItem(folder, 0);
        item.setText(Messages.getString("RevisionChooserDialog.tagTab.name"));
        final TagTable table = new TagTable((Composite)folder, this.dataLoader.getProject());
        table.highlightParents(this.parents);
        table.setLayoutData(new GridData(1808));
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RevisionChooserDialog.this.text.setText(table.getSelection().getName());
                RevisionChooserDialog.this.tag = table.getSelection();
                RevisionChooserDialog.this.branch = null;
                RevisionChooserDialog.this.bookmark = null;
                RevisionChooserDialog.this.changeSet = null;
            }
        });
        table.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                table.removeListener(22, this);
                new SafeUiJob(Messages.getString("RevisionChooserDialog.tagJob.description")){

                    protected IStatus runSafe(IProgressMonitor monitor) {
                        try {
                            Tag[] tags = RevisionChooserDialog.this.dataLoader.getTags();
                            table.setTags(tags);
                            return Status.OK_STATUS;
                        }
                        catch (HgException e) {
                            MercurialEclipsePlugin.logError((Throwable)((Object)e));
                            return Status.CANCEL_STATUS;
                        }
                    }
                }.schedule();
            }
        });
        item.setControl((Control)table);
        return item;
    }

    protected TabItem createBranchTabItem(TabFolder folder) {
        TabItem item = new TabItem(folder, 0);
        item.setText(Messages.getString("RevisionChooserDialog.branchTab.name"));
        final BranchTable table = new BranchTable((Composite)folder);
        table.highlightParents(this.parents);
        table.setLayoutData(new GridData(1808));
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RevisionChooserDialog.this.text.setText(table.getSelection().getName());
                RevisionChooserDialog.this.branch = table.getSelection();
                RevisionChooserDialog.this.tag = null;
                RevisionChooserDialog.this.bookmark = null;
                RevisionChooserDialog.this.changeSet = null;
            }
        });
        table.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                table.removeListener(22, this);
                new SafeUiJob(Messages.getString("RevisionChooserDialog.branchJob.description")){

                    protected IStatus runSafe(IProgressMonitor monitor) {
                        try {
                            Branch[] branches = RevisionChooserDialog.this.dataLoader.getBranches();
                            table.setBranches(branches);
                            return Status.OK_STATUS;
                        }
                        catch (HgException e) {
                            MercurialEclipsePlugin.logError((Throwable)((Object)e));
                            return Status.CANCEL_STATUS;
                        }
                    }
                }.schedule();
            }
        });
        item.setControl((Control)table);
        return item;
    }

    protected TabItem createBookmarkTabItem(TabFolder folder) {
        TabItem item = new TabItem(folder, 0);
        item.setText(Messages.getString("RevisionChooserDialog.bookmarkTab.name"));
        final BookmarkTable table = new BookmarkTable((Composite)folder, (IResource)this.dataLoader.getProject());
        table.setLayoutData(new GridData(1808));
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RevisionChooserDialog.this.text.setText(table.getSelection().getName());
                RevisionChooserDialog.this.bookmark = table.getSelection();
                RevisionChooserDialog.this.tag = null;
                RevisionChooserDialog.this.branch = null;
                RevisionChooserDialog.this.changeSet = null;
            }
        });
        item.setControl((Control)table);
        return item;
    }

    protected TabItem createHeadTabItem(TabFolder folder) {
        TabItem item = new TabItem(folder, 0);
        item.setText(Messages.getString("RevisionChooserDialog.headTab.name"));
        final ChangesetTable table = new ChangesetTable((Composite)folder, (IResource)this.dataLoader.getProject(), false);
        table.setLayoutData(new GridData(1808));
        table.highlightParents(this.parents);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RevisionChooserDialog.this.tag = null;
                RevisionChooserDialog.this.branch = null;
                RevisionChooserDialog.this.bookmark = null;
                RevisionChooserDialog.this.text.setText(String.valueOf(table.getSelection().getChangesetIndex()) + ":" + table.getSelection().getChangeset());
                RevisionChooserDialog.this.changeSet = table.getSelection();
            }
        });
        table.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                table.removeListener(22, this);
                new SafeUiJob(Messages.getString("RevisionChooserDialog.fetchJob.description")){

                    protected IStatus runSafe(IProgressMonitor monitor) {
                        try {
                            table.setAutoFetch(false);
                            ChangeSet[] revisions = RevisionChooserDialog.this.dataLoader.getHeads();
                            table.setChangesets(revisions);
                            return Status.OK_STATUS;
                        }
                        catch (HgException e) {
                            MercurialEclipsePlugin.logError((Throwable)((Object)e));
                            return Status.CANCEL_STATUS;
                        }
                    }
                }.schedule();
            }
        });
        item.setControl((Control)table);
        if (this.defaultShowingHeads) {
            folder.setSelection(item);
        }
        return item;
    }

    public ChangeSet getChangeSet() {
        return this.changeSet;
    }

    public void setDefaultShowingHeads(boolean defaultShowingHeads) {
        this.defaultShowingHeads = defaultShowingHeads;
    }

    public void setDisallowSelectingParents(boolean b) {
        this.disallowSelectingParents = b;
    }
}

