/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.dialogs;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.HgTagClient;
import com.vectrace.MercurialEclipse.dialogs.Messages;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.model.Tag;
import com.vectrace.MercurialEclipse.ui.ChangesetTable;
import com.vectrace.MercurialEclipse.ui.TagTable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class TagDialog
extends Dialog {
    private final IProject project;
    Text nameText;
    Button forceButton;
    Button localButton;
    String name;
    String targetRevision;
    boolean forced;
    boolean local;

    public TagDialog(Shell parentShell, IProject project) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.project = project;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("TagDialog.shell.text"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout(2, false);
        composite.setLayout((Layout)gridLayout);
        TabFolder tabFolder = new TabFolder(composite, 0);
        tabFolder.setLayoutData((Object)new GridData(1808));
        this.createMainTabItem(tabFolder);
        this.createTargetTabItem(tabFolder);
        return composite;
    }

    private GridData createGridData(int colspan) {
        GridData data = new GridData(768);
        data.horizontalSpan = colspan;
        data.minimumWidth = -1;
        return data;
    }

    private GridData createGridData(int colspan, int width) {
        GridData data = new GridData(768);
        data.horizontalSpan = colspan;
        data.minimumWidth = width;
        return data;
    }

    protected TabItem createMainTabItem(TabFolder folder) {
        TabItem item = new TabItem(folder, 0);
        item.setText(Messages.getString("TagDialog.mainTab.name"));
        Composite composite = new Composite((Composite)folder, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("TagDialog.enterTagName"));
        label.setLayoutData((Object)this.createGridData(1));
        this.nameText = new Text(composite, 2048);
        this.nameText.setLayoutData((Object)this.createGridData(1));
        this.forceButton = new Button(composite, 32);
        this.forceButton.setText(Messages.getString("TagDialog.moveTag"));
        this.forceButton.setLayoutData((Object)this.createGridData(1));
        this.localButton = new Button(composite, 32);
        this.localButton.setText(Messages.getString("TagDialog.createLocal"));
        this.localButton.setLayoutData((Object)this.createGridData(1));
        label = new Label(composite, 0);
        label.setText(Messages.getString("TagDialog.existingTags"));
        label.setLayoutData((Object)this.createGridData(1));
        final TagTable table = new TagTable(composite, this.project);
        table.hideTip();
        GridData data = new GridData(1808);
        data.heightHint = 150;
        table.setLayoutData(data);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Tag tag = table.getSelection();
                TagDialog.this.nameText.setText(tag.getName());
                TagDialog.this.localButton.setSelection(tag.isLocal());
            }
        });
        try {
            table.setTags(HgTagClient.getTags(this.project));
        }
        catch (HgException e) {
            MercurialEclipsePlugin.logError((Throwable)((Object)e));
        }
        item.setControl((Control)composite);
        return item;
    }

    protected TabItem createOptionsTabItem(TabFolder folder) {
        TabItem item = new TabItem(folder, 0);
        item.setText(Messages.getString("TagDialog.options"));
        Composite composite = new Composite((Composite)folder, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        final Button customUserButton = new Button(composite, 32);
        customUserButton.setText(Messages.getString("TagDialog.customUserName"));
        final Text userText = new Text(composite, 2048);
        userText.setLayoutData((Object)this.createGridData(1, 250));
        userText.setEnabled(false);
        customUserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                userText.setEnabled(customUserButton.getSelection());
            }
        });
        item.setControl((Control)composite);
        return item;
    }

    protected TabItem createTargetTabItem(TabFolder folder) {
        TabItem item = new TabItem(folder, 0);
        item.setText(Messages.getString("TagDialog.targetTab.name"));
        Composite composite = new Composite((Composite)folder, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        Button parentButton = new Button(composite, 16);
        parentButton.setText(Messages.getString("TagDialog.tagParentChangeset"));
        parentButton.setSelection(true);
        Button otherButton = new Button(composite, 16);
        otherButton.setText(Messages.getString("TagDialog.tagAnotherChangeset"));
        final ChangesetTable table = new ChangesetTable(composite, (IResource)this.project);
        table.setLayoutData(new GridData(4, 4, true, true));
        table.setEnabled(false);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TagDialog.this.targetRevision = Integer.toString(table.getSelection().getChangesetIndex());
            }
        });
        parentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                table.setEnabled(false);
                TagDialog.this.targetRevision = null;
            }
        });
        otherButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                table.setEnabled(true);
                ChangeSet changeset = table.getSelection();
                if (changeset != null) {
                    TagDialog.this.targetRevision = Integer.toString(changeset.getChangesetIndex());
                }
            }
        });
        item.setControl((Control)composite);
        return item;
    }

    protected void okPressed() {
        this.name = this.nameText.getText();
        this.forced = this.forceButton.getSelection();
        this.local = this.localButton.getSelection();
        super.okPressed();
    }

    public String getName() {
        return this.name;
    }

    public String getTargetRevision() {
        return this.targetRevision;
    }

    public boolean isForced() {
        return this.forced;
    }

    public boolean isLocal() {
        return this.local;
    }
}

