/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.history;

import com.vectrace.MercurialEclipse.commands.HgLogClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.history.ChangedPathsPage;
import com.vectrace.MercurialEclipse.history.MercurialHistory;
import com.vectrace.MercurialEclipse.history.MercurialRevision;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.model.FileStatus;
import com.vectrace.MercurialEclipse.team.MercurialRevisionStorage;
import com.vectrace.MercurialEclipse.team.NullRevision;
import com.vectrace.MercurialEclipse.utils.CompareUtils;
import com.vectrace.MercurialEclipse.wizards.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ChangePathsTableProvider
extends TableViewer {
    private static final int COL_ACTION = 0;
    private static final int COL_PATH = 1;
    private static final FileStatus[] EMPTY_CHANGE_PATHS = new FileStatus[0];

    public ChangePathsTableProvider(Composite parent, IContentProvider contentProvider) {
        super(parent, 66306);
        TableLayout layout = new TableLayout();
        GridData data = new GridData(1808);
        Table table = (Table)this.getControl();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)data);
        table.setLayout((Layout)layout);
        this.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                FileStatus clickedFileStatus = (FileStatus)sel.getFirstElement();
                MercurialRevision rev = (MercurialRevision)((Object)ChangePathsTableProvider.this.getInput());
                if (rev == null || clickedFileStatus == null) {
                    return;
                }
                ChangeSet cs = rev.getChangeSet();
                String[] parents = cs.getParents();
                Path hgRoot = new Path(cs.getHgRoot().getPath());
                Path fileRelPath = new Path(clickedFileStatus.getPath());
                IPath fileAbsPath = hgRoot.append((IPath)fileRelPath);
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(fileAbsPath);
                MercurialRevisionStorage thisRev = new MercurialRevisionStorage((IResource)file, cs.getChangeset());
                MercurialRevisionStorage parentRev = cs.getRevision().getRevision() == 0 || parents.length == 0 ? new NullRevision((IResource)file, cs) : new MercurialRevisionStorage((IResource)file, parents[0]);
                CompareUtils.openEditor(thisRev, parentRev, false, false);
            }
        });
        this.createColumns(table, layout);
        this.setLabelProvider((IBaseLabelProvider)new ChangePathLabelProvider());
        this.setContentProvider(contentProvider);
    }

    public ChangePathsTableProvider(Composite parent, ChangedPathsPage page) {
        this(parent, (IContentProvider)new ChangePathsTableContentProvider(page));
    }

    private void createColumns(Table table, TableLayout layout) {
        TableColumn col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(Messages.getString("ChangePathsTableProvider.action"));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, true));
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(Messages.getString("ChangePathsTableProvider.path"));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(45, true));
        table.setSortColumn(col);
    }

    private static class ChangePathLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ChangePathLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            FileStatus changePath = (FileStatus)element;
            if (changePath == null) {
                return "";
            }
            switch (columnIndex) {
                case 0: {
                    return "" + (Object)((Object)changePath.getAction());
                }
                case 1: {
                    return changePath.getPath();
                }
            }
            return "";
        }
    }

    private static class ChangePathsTableContentProvider
    implements IStructuredContentProvider {
        private final ChangedPathsPage page;

        public ChangePathsTableContentProvider(ChangedPathsPage page) {
            this.page = page;
        }

        public Object[] getElements(Object inputElement) {
            ChangeSet cs;
            if (!this.page.isShowChangePaths()) {
                return EMPTY_CHANGE_PATHS;
            }
            MercurialRevision rev = (MercurialRevision)((Object)inputElement);
            MercurialHistory history = this.page.getMercurialHistory();
            try {
                cs = HgLogClient.getLogWithBranchInfo(rev, 1, history);
            }
            catch (HgException hgException) {
                return EMPTY_CHANGE_PATHS;
            }
            if (cs != null) {
                return cs.getChangedFiles();
            }
            return EMPTY_CHANGE_PATHS;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

