/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.history;

import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.model.GChangeSet;
import com.vectrace.MercurialEclipse.model.Signature;
import com.vectrace.MercurialEclipse.team.MercurialRevisionStorage;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileRevision;

public class MercurialRevision
extends FileRevision {
    private final IResource resource;
    private final ChangeSet changeSet;
    private MercurialRevisionStorage mercurialRevisionStorage;
    private final GChangeSet gChangeSet;
    private final int revision;
    private String hash;
    private final Signature signature;
    private File parent;

    public MercurialRevision(ChangeSet changeSet, GChangeSet gChangeSet, IResource resource, Signature sig) {
        this.changeSet = changeSet;
        this.gChangeSet = gChangeSet;
        this.revision = changeSet.getChangesetIndex();
        this.hash = changeSet.getChangeset();
        this.resource = resource;
        this.signature = sig;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.changeSet == null ? 0 : this.changeSet.hashCode());
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MercurialRevision)) {
            return false;
        }
        MercurialRevision other = (MercurialRevision)((Object)obj);
        if (this.changeSet == null ? other.changeSet != null : !this.changeSet.equals(other.changeSet)) {
            return false;
        }
        return !(this.resource == null ? other.resource != null : !this.resource.equals((Object)other.resource));
    }

    public ChangeSet getChangeSet() {
        return this.changeSet;
    }

    public GChangeSet getGChangeSet() {
        return this.gChangeSet;
    }

    public String getName() {
        return this.resource.getName();
    }

    public String getContentIdentifier() {
        return this.changeSet.getChangeset();
    }

    public IStorage getStorage(IProgressMonitor monitor) throws CoreException {
        if (this.mercurialRevisionStorage == null) {
            if (!(this.resource != null && this.resource.exists() || this.parent == null)) {
                IFile parentRes = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(this.parent.getAbsolutePath()));
                this.mercurialRevisionStorage = new MercurialRevisionStorage((IResource)parentRes, this.revision, this.hash, this.changeSet);
            } else {
                this.mercurialRevisionStorage = new MercurialRevisionStorage(this.resource, this.revision, this.hash, this.changeSet);
                this.mercurialRevisionStorage.setParent(this.parent);
            }
        }
        return this.mercurialRevisionStorage;
    }

    public boolean isPropertyMissing() {
        return false;
    }

    public IFileRevision withAllProperties(IProgressMonitor monitor) throws CoreException {
        return null;
    }

    public int getRevision() {
        return this.revision;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public IResource getResource() {
        return this.resource;
    }

    public File getParent() {
        return this.parent;
    }

    public void setParent(File parent) {
        this.parent = parent;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("hg rev [");
        if (this.revision > 0) {
            builder.append("revision=");
            builder.append(this.revision);
            builder.append(", ");
        }
        if (this.changeSet != null) {
            builder.append("changeSet=");
            builder.append(this.changeSet);
            builder.append(", ");
        }
        if (this.resource != null) {
            builder.append("resource=");
            builder.append(this.resource);
            builder.append(", ");
        }
        if (this.signature != null) {
            builder.append("signature=");
            builder.append(this.signature);
            builder.append(", ");
        }
        if (this.gChangeSet != null) {
            builder.append("gChangeSet=");
            builder.append(this.gChangeSet);
        }
        if (this.parent != null) {
            builder.append("parent=");
            builder.append(this.parent);
        }
        builder.append("]");
        return builder.toString();
    }
}

