/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.menu;

import com.vectrace.MercurialEclipse.commands.HgCommitClient;
import com.vectrace.MercurialEclipse.dialogs.CommitDialog;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.menu.Messages;
import com.vectrace.MercurialEclipse.menu.SingleResourceHandler;
import com.vectrace.MercurialEclipse.team.ResourceProperties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Shell;

public class CommitMergeHandler
extends SingleResourceHandler {
    protected void run(IResource resource) throws HgException {
        Assert.isNotNull((Object)resource);
        this.commitMergeWithCommitDialog(resource.getProject(), this.getShell());
    }

    public String commitMergeWithCommitDialog(IProject resource, Shell shell) throws HgException {
        Assert.isNotNull((Object)resource);
        String result = "";
        try {
            CommitDialog commitDialog = new CommitDialog(shell, resource, String.valueOf(Messages.getString("CommitMergeHandler.mergeWith")) + resource.getProject().getPersistentProperty(ResourceProperties.MERGING));
            commitDialog.open();
        }
        catch (CoreException e) {
            throw new HgException(Messages.getString("CommitMergeHandler.failedToSetMergeStatus"), e);
        }
        return result;
    }

    public static String commitMerge(IProject project) throws HgException, CoreException {
        Assert.isNotNull((Object)project);
        return CommitMergeHandler.commitMerge(project, String.valueOf(Messages.getString("CommitMergeHandler.mergeWith")) + project.getPersistentProperty(ResourceProperties.MERGING));
    }

    public static String commitMerge(IProject project, String message) throws HgException, CoreException {
        Assert.isNotNull((Object)project);
        Assert.isNotNull((Object)message);
        String result = HgCommitClient.commitProject(project, null, message);
        project.setPersistentProperty(ResourceProperties.MERGING, null);
        project.setSessionProperty(ResourceProperties.MERGE_COMMIT_OFFERED, null);
        project.touch(null);
        return result;
    }
}

