/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GChangeSet {
    private final EdgeList middle;
    private final EdgeList after;
    private final int index;
    private final RowCount rowCount;
    private final int rev;

    public GChangeSet(RowCount rowCount, int index, String middleS, String afterS) {
        this.rowCount = rowCount;
        this.index = index;
        this.middle = new EdgeList(true);
        this.after = new EdgeList(false);
        this.middle.parse(middleS);
        this.after.parse(afterS);
        this.rev = middleS != null && middleS.length() > 0 ? Integer.parseInt(middleS.substring(middleS.indexOf(42) + 1)) : 0;
    }

    public int getRev() {
        return this.rev;
    }

    public GChangeSet clean(GChangeSet last) {
        this.middle.clean(last);
        return this;
    }

    public int getIndex() {
        return this.index;
    }

    public EdgeList getBefore() {
        return this.getMiddle();
    }

    public EdgeList getMiddle() {
        return this.middle;
    }

    public EdgeList getAfter() {
        return this.after;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GChangeSet [rev=");
        builder.append(this.rev);
        builder.append(", index=");
        builder.append(this.index);
        builder.append(", ");
        if (this.rowCount != null) {
            builder.append("rowCount=");
            builder.append(this.rowCount);
        }
        builder.append("]");
        return builder.toString();
    }

    public static class Edge {
        private int top;
        private int bottom;
        private int col;
        private int lane;
        private boolean finish;
        private EdgeType type;

        public Edge(char c, int i) {
            this.top = this.bottom = i;
            this.col = this.bottom--;
            this.type = EdgeType.line;
            switch (c) {
                case '/': {
                    this.type = EdgeType.slash;
                    break;
                }
                case '\\': {
                    this.type = EdgeType.backslash;
                    --this.top;
                    break;
                }
                case 'o': {
                    this.type = EdgeType.dot;
                    break;
                }
                case '@': {
                    this.type = EdgeType.working;
                    break;
                }
                case '+': {
                    this.type = EdgeType.plus;
                    break;
                }
                case '-': {
                    this.type = EdgeType.dash;
                }
            }
        }

        public void setFinish(boolean finish) {
            this.finish = finish;
        }

        public boolean isFinish() {
            return this.finish;
        }

        public void straighten() {
            this.top = this.bottom = Math.max(this.top, this.bottom);
        }

        public void dec() {
            this.bottom = --this.col;
            this.top = this.col;
        }

        public int getTop() {
            return this.top;
        }

        public int getBottom() {
            return this.bottom;
        }

        public int getLane() {
            return this.lane;
        }

        public boolean isDot() {
            return this.type == EdgeType.dot || this.type == EdgeType.working || this.type == EdgeType.plus;
        }

        public boolean isPlus() {
            return this.type == EdgeType.plus;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum EdgeType {
            line,
            dot,
            working,
            plus,
            dash,
            slash,
            backslash;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EdgeList {
        private final List<Edge> edges = new ArrayList<Edge>();
        private final Set<Integer> above = new HashSet<Integer>();
        private final boolean straight;
        private int[] jumps;

        public EdgeList(boolean straight) {
            this.straight = straight;
        }

        public void parse(String string) {
            int length = string.length();
            int count = 0;
            int i = 0;
            while (i < length) {
                if (string.charAt(i) == '*') break;
                count += this.addEdge(string, i, count);
                ++i;
            }
            GChangeSet.this.rowCount.endRow();
            if (string.contains("+")) {
                ((GChangeSet)GChangeSet.this).rowCount.jump = string.indexOf(111);
                this.jumps = new int[]{string.indexOf(43) / 2, ((GChangeSet)GChangeSet.this).rowCount.jump / 2};
            }
        }

        private int addEdge(String string, int i, int count) {
            char c = string.charAt(i);
            if (c == ' ') {
                return GChangeSet.this.rowCount.space(i, count);
            }
            Edge edge = new Edge(c, count);
            return GChangeSet.this.rowCount.update(this, edge);
        }

        public int[] getJump() {
            return this.jumps;
        }

        public void add(Edge edge) {
            if (this.straight) {
                edge.straighten();
            }
            this.above.add(edge.bottom);
            this.edges.add(edge);
        }

        public List<Edge> getEdges() {
            return this.edges;
        }

        public void clean(GChangeSet last) {
            for (Edge e : this.edges) {
                e.setFinish(e.isDot() && (last == null || !((GChangeSet)last).after.above.contains(e.top)));
            }
        }
    }

    public static class RowCount {
        public int jump;
        public List<Integer> cols = new ArrayList<Integer>();
        private int unique = 0;
        private Edge lastEdge;
        private int dec = -1;

        public RowCount() {
            this.cols.add(0);
        }

        public int space(int i, int count) {
            this.lastEdge = null;
            if (this.jump == i) {
                this.dec = count;
                return 1;
            }
            return 0;
        }

        public int update(EdgeList edges, Edge edge) {
            Integer col;
            boolean lastLine = this.lastEdge != null && this.lastEdge.type == Edge.EdgeType.line;
            int count = 1;
            if (edge.type == Edge.EdgeType.backslash && lastLine) {
                ++this.unique;
                col = this.unique;
                this.cols.add(edge.col, col);
            } else if (edge.type == Edge.EdgeType.slash && lastLine) {
                this.dec = edge.col;
                col = this.cols.get(edge.col);
            } else if (edge.type == Edge.EdgeType.line && this.lastEdge != null && this.lastEdge.type == Edge.EdgeType.backslash) {
                count = 0;
                edge.dec();
                this.cols.remove(edge.col);
                col = this.cols.get(edge.col);
            } else if (edge.type == Edge.EdgeType.line && this.lastEdge != null && this.lastEdge.type == Edge.EdgeType.slash) {
                count = 0;
                edge.dec();
                col = this.cols.get(edge.col);
                this.dec = -1;
            } else {
                if (edge.type == Edge.EdgeType.dash && (this.lastEdge == null || this.lastEdge.type != Edge.EdgeType.dash)) {
                    this.lastEdge = edge;
                    return 0;
                }
                if (edge.col >= this.cols.size()) {
                    ++this.unique;
                    col = this.unique;
                    this.cols.add(col);
                } else {
                    col = this.cols.get(edge.col);
                }
            }
            edge.lane = col;
            this.lastEdge = edge.type == Edge.EdgeType.dash ? null : edge;
            edges.add(edge);
            return count;
        }

        public void endRow() {
            this.lastEdge = null;
            if (this.dec > -1) {
                this.cols.remove(this.dec);
                this.dec = -1;
            }
            this.jump = -1;
        }
    }
}

