/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.model;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.model.HgFile;
import com.vectrace.MercurialEclipse.model.HgFilesystemObject;
import com.vectrace.MercurialEclipse.model.HgFolder;
import com.vectrace.MercurialEclipse.utils.ResourceUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class HgResourceMapping
extends ResourceMapping {
    private HgFilesystemObject file;

    public HgResourceMapping(File file) throws IOException, CoreException {
        this.file = file.isDirectory() ? new HgFolder(file) : new HgFile(file);
    }

    public Object getModelObject() {
        return this.file;
    }

    public String getModelProviderId() {
        return "com.vectrace.MercurialEclipse.team.MercurialTeamProvider";
    }

    public IProject[] getProjects() {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        if (this.file instanceof HgFolder) {
            HgFolder folder = (HgFolder)this.file;
            try {
                List<File> projectFiles = folder.getProjectFiles();
                IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                for (File f : projectFiles) {
                    try {
                        IProject project = (IProject)workspaceRoot.findContainersForLocation((IPath)new Path(f.getParentFile().getCanonicalPath()))[0];
                        projects.add(project);
                    }
                    catch (IOException e) {
                        MercurialEclipsePlugin.logError(e);
                    }
                }
            }
            catch (Exception e) {
                MercurialEclipsePlugin.logError(e);
            }
        }
        return projects.toArray(new IProject[projects.size()]);
    }

    public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        IResource resource = ResourceUtils.convert(this.file);
        int depth = 0;
        ResourceTraversal resourceTraversal = new ResourceTraversal(new IResource[]{resource}, depth, 4);
        return new ResourceTraversal[]{resourceTraversal};
    }
}

