/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.model;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.utils.IniFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;

public class HgRoot
extends File {
    private static final String HGENCODING;
    private static final long serialVersionUID = 2L;
    private Charset encoding;
    private Charset fallbackencoding;
    private File config;

    static {
        String enc = System.getProperty("HGENCODING");
        HGENCODING = enc == null || enc.length() == 0 ? Charset.defaultCharset().name() : enc;
    }

    public HgRoot(String pathname) throws IOException {
        this(new File(pathname));
    }

    public HgRoot(File file) throws IOException {
        super(file.getCanonicalPath());
    }

    public void setEncoding(Charset charset) {
        this.encoding = charset;
    }

    public Charset getEncoding() {
        if (this.encoding == null) {
            this.setEncoding(Charset.forName(HGENCODING));
        }
        return this.encoding;
    }

    public File getConfig() {
        File hgrc;
        if (this.config == null && (hgrc = new File(this, ".hg/hgrc")).exists()) {
            this.config = hgrc;
            return hgrc;
        }
        return null;
    }

    public String getConfigItem(String section, String key) {
        this.getConfig();
        if (this.config != null) {
            try {
                IniFile iniFile = new IniFile(this.config.getAbsolutePath());
                return iniFile.getKeyValue(section, key);
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        return null;
    }

    public Charset getFallbackencoding() {
        if (this.fallbackencoding == null) {
            String fallback = this.getConfigItem("ui", "fallbackencoding");
            if (fallback == null || fallback.length() == 0) {
                fallback = "windows-1251";
            }
            this.fallbackencoding = Charset.forName(fallback);
        }
        return this.fallbackencoding;
    }

    public String toRelative(File child) {
        String fullPath;
        try {
            fullPath = child.getCanonicalPath();
            if (!fullPath.startsWith(this.getPath())) {
                return child.getPath();
            }
        }
        catch (IOException e) {
            MercurialEclipsePlugin.logError(e);
            return child.getPath();
        }
        return fullPath.substring(this.getPath().length() + 1);
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

