/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.operations;

import com.vectrace.MercurialEclipse.actions.HgOperation;
import com.vectrace.MercurialEclipse.commands.HgInitClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.HgRoot;
import com.vectrace.MercurialEclipse.operations.Messages;
import com.vectrace.MercurialEclipse.team.MercurialTeamProvider;
import com.vectrace.MercurialEclipse.team.cache.RefreshStatusJob;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.team.core.RepositoryProvider;

public class InitOperation
extends HgOperation {
    private IProject project;
    private String hgPath;
    private HgRoot foundHgPath;

    public InitOperation(IRunnableContext ctx, IProject project, HgRoot foundHgRoot, String hgPath) {
        super(ctx);
        this.hgPath = hgPath;
        this.project = project;
        this.foundHgPath = foundHgRoot;
    }

    protected String getActionDescription() {
        return Messages.getString("InitOperation.creatingRepo");
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask(Messages.getString("InitOperation.share"), 3);
            if (this.foundHgPath == null || !this.foundHgPath.getAbsolutePath().equals(this.hgPath)) {
                monitor.subTask(Messages.getString("InitOperation.call"));
                HgInitClient.init(this.project, this.hgPath);
                monitor.worked(1);
            }
            monitor.subTask(String.valueOf(Messages.getString("InitOperation.mapping.1")) + this.project.getName() + Messages.getString("InitOperation.mapping.2"));
            RepositoryProvider.map((IProject)this.project, (String)MercurialTeamProvider.class.getName());
            monitor.worked(1);
            this.project.touch(monitor);
            monitor.subTask(Messages.getString("InitOperation.schedulingRefresh"));
            new RefreshStatusJob(String.valueOf(Messages.getString("InitOperation.refresh.1")) + this.project + Messages.getString("InitOperation.refresh.2"), this.project).schedule();
            monitor.worked(1);
        }
        catch (HgException e) {
            throw new InvocationTargetException((Throwable)((Object)e));
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
        monitor.done();
    }
}

