/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.repository;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.repository.IRepositoryListener;
import com.vectrace.MercurialEclipse.repository.Messages;
import com.vectrace.MercurialEclipse.repository.RepositorySorter;
import com.vectrace.MercurialEclipse.repository.actions.RemoveRootAction;
import com.vectrace.MercurialEclipse.repository.model.AllRootsElement;
import com.vectrace.MercurialEclipse.repository.model.RemoteContentProvider;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.wizards.NewLocationWizard;
import java.io.IOException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;

public class RepositoriesView
extends ViewPart
implements ISelectionListener {
    public static final String VIEW_ID = "com.vectrace.MercurialEclipse.repository.RepositoriesView";
    private AllRootsElement root;
    private Action newAction;
    private RemoveRootAction removeRootAction;
    protected TreeViewer treeViewer;
    private DrillDownAdapter drillPart;
    private Action refreshAction;
    private Action refreshPopupAction;
    private Action collapseAllAction;
    private Action propertiesAction;
    private RemoteContentProvider contentProvider;
    private IRepositoryListener repositoryListener = new IRepositoryListener(){

        public void repositoryAdded(final HgRepositoryLocation loc) {
            RepositoriesView.this.getViewer().getControl().getDisplay().syncExec(new Runnable(){

                public void run() {
                    RepositoriesView.this.refreshViewer(null, false);
                    RepositoriesView.this.getViewer().setSelection((ISelection)new StructuredSelection((Object)loc));
                }
            });
        }

        public void repositoryRemoved(HgRepositoryLocation loc) {
            this.refresh(null, false);
        }

        public void repositoriesChanged(HgRepositoryLocation[] roots) {
            this.refresh(null, false);
        }

        private void refresh(Object object, boolean refreshRepositoriesFolders) {
            final Object finalObject = object;
            final boolean finalRefreshReposFolders = refreshRepositoriesFolders;
            Display display = RepositoriesView.this.getViewer().getControl().getDisplay();
            display.syncExec(new Runnable(){

                public void run() {
                    RepositoriesView.this.refreshViewer(finalObject, finalRefreshReposFolders);
                }
            });
        }

        public void repositoryModified(HgRepositoryLocation loc) {
            this.refresh(null, false);
        }
    };

    protected void contributeActions() {
        final Shell shell = this.getShell();
        this.newAction = new Action(Messages.getString("RepositoriesView.createRepo"), MercurialEclipsePlugin.getImageDescriptor("wizards/newlocation_wiz.gif")){

            public void run() {
                NewLocationWizard wizard = new NewLocationWizard();
                WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                dialog.open();
            }
        };
        this.propertiesAction = new PropertyDialogAction((IShellProvider)new SameShellProvider((Control)shell), (ISelectionProvider)this.getViewer());
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.propertiesAction);
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        if (selection.size() == 1 && selection.getFirstElement() instanceof HgRepositoryLocation) {
            this.propertiesAction.setEnabled(true);
        } else {
            this.propertiesAction.setEnabled(false);
        }
        this.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                boolean enabled = ss.size() == 1 && ss.getFirstElement() instanceof HgRepositoryLocation;
                RepositoriesView.this.propertiesAction.setEnabled(enabled);
            }
        });
        this.removeRootAction = new RemoveRootAction(this.treeViewer.getControl().getShell());
        this.removeRootAction.selectionChanged(null);
        IActionBars bars = this.getViewSite().getActionBars();
        bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.removeRootAction);
        this.refreshAction = new Action(Messages.getString("RepositoriesView.refreshRepos"), MercurialEclipsePlugin.getImageDescriptor("elcl16/refresh.gif")){

            public void run() {
                RepositoriesView.this.refreshViewer(null, true);
            }
        };
        this.refreshAction.setToolTipText(Messages.getString("RepositoriesView.refresh"));
        this.refreshAction.setDisabledImageDescriptor(MercurialEclipsePlugin.getImageDescriptor("dlcl16/refresh.gif"));
        this.refreshAction.setHoverImageDescriptor(MercurialEclipsePlugin.getImageDescriptor("clcl16/refresh.gif"));
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.refreshAction);
        this.refreshPopupAction = new Action(Messages.getString("RepositoriesView.refresh"), MercurialEclipsePlugin.getImageDescriptor("clcl16/refresh.gif")){

            public void run() {
                RepositoriesView.this.refreshViewerNode();
            }
        };
        this.collapseAllAction = new Action("RepositoriesView.collapseAll", MercurialEclipsePlugin.getImageDescriptor("elcl16/collapseall.gif")){

            public void run() {
                RepositoriesView.this.collapseAll();
            }
        };
        this.collapseAllAction.setToolTipText(Messages.getString("RepositoriesView.collapseAll"));
        this.collapseAllAction.setHoverImageDescriptor(MercurialEclipsePlugin.getImageDescriptor("clcl16/collapseall.gif"));
        MenuManager menuMgr = new MenuManager();
        Tree tree = this.treeViewer.getTree();
        Menu menu = menuMgr.createContextMenu((Control)tree);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                RepositoriesView.this.addWorkbenchActions(manager);
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        tree.setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.treeViewer);
        IToolBarManager tbm = bars.getToolBarManager();
        this.drillPart.addNavigationActions(tbm);
        tbm.add((IAction)this.refreshAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.collapseAllAction);
        tbm.update(false);
        bars.updateActionBars();
    }

    protected void addWorkbenchActions(IMenuManager manager) {
        MenuManager sub = new MenuManager(Messages.getString("RepositoriesView.new"), "group.add");
        sub.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)sub);
        manager.add((IContributionItem)new Separator("group.file"));
        manager.add((IContributionItem)new Separator("historyGroup"));
        manager.add((IContributionItem)new Separator("checkoutGroup"));
        manager.add((IContributionItem)new Separator("exportImportGroup"));
        manager.add((IContributionItem)new Separator("miscGroup"));
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IAction)this.refreshPopupAction);
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        this.removeRootAction.selectionChanged(selection);
        if (this.removeRootAction.isEnabled()) {
            manager.add((IAction)this.removeRootAction);
        }
        if (selection.size() == 1 && selection.getFirstElement() instanceof HgRepositoryLocation) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.propertiesAction);
        }
        sub.add((IAction)this.newAction);
    }

    public void createPartControl(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 770);
        this.contentProvider = new RemoteContentProvider();
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        this.root = new AllRootsElement();
        this.treeViewer.setInput((Object)this.root);
        this.treeViewer.setSorter((ViewerSorter)new RepositorySorter());
        this.drillPart = new DrillDownAdapter(this.treeViewer);
        this.contributeActions();
        this.initializeListeners();
        MercurialEclipsePlugin.getRepoManager().addRepositoryListener(this.repositoryListener);
    }

    protected void initializeListeners() {
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener((ISelectionListener)this);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this.removeRootAction);
        this.treeViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 0x100000E) {
                    RepositoriesView.this.refreshAction.run();
                }
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                RepositoriesView.this.handleDoubleClick(e);
            }
        });
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        String msg = this.getStatusLineMessage(selection);
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(msg);
    }

    private String getStatusLineMessage(ISelection selection) {
        if (selection == null || selection.isEmpty()) {
            return "";
        }
        if (!(selection instanceof IStructuredSelection)) {
            return "";
        }
        IStructuredSelection s = (IStructuredSelection)selection;
        if (s.size() > 1) {
            return String.valueOf(String.valueOf(s.size())) + Messages.getString("RepositoriesView.multiSelected");
        }
        return Messages.getString("RepositoriesView.oneSelected");
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    protected Shell getShell() {
        return this.treeViewer.getTree().getShell();
    }

    protected TreeViewer getViewer() {
        return this.treeViewer;
    }

    protected void refreshViewer(Object object, boolean refreshRepositoriesFolders) {
        if (this.treeViewer == null) {
            return;
        }
        if (refreshRepositoriesFolders) {
            try {
                MercurialEclipsePlugin.getRepoManager().refreshRepositories(null);
            }
            catch (HgException e) {
                MercurialEclipsePlugin.logError((Throwable)((Object)e));
            }
            catch (IOException e) {
                MercurialEclipsePlugin.logError(e);
            }
        }
        if (object == null) {
            this.treeViewer.refresh();
        } else {
            this.treeViewer.refresh(object);
        }
    }

    protected void refreshViewerNode() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        for (Object object : selection) {
            if (object instanceof HgRepositoryLocation) {
                this.refreshAction.run();
                break;
            }
            this.treeViewer.refresh(object);
        }
    }

    public void collapseAll() {
        if (this.treeViewer == null) {
            return;
        }
        this.treeViewer.getControl().setRedraw(false);
        this.treeViewer.collapseToLevel(this.treeViewer.getInput(), -1);
        this.treeViewer.getControl().setRedraw(true);
    }

    private void handleDoubleClick(DoubleClickEvent e) {
        IStructuredSelection structured;
        ISelection selection = e.getSelection();
        if (selection instanceof IStructuredSelection && (structured = (IStructuredSelection)selection).size() == 1) {
            Object first;
            this.treeViewer.setExpandedState(first, !this.treeViewer.getExpandedState(first = structured.getFirstElement()));
        }
    }

    public void dispose() {
        MercurialEclipsePlugin.getRepoManager().removeRepositoryListener(this.repositoryListener);
        super.dispose();
        this.treeViewer = null;
    }
}

