/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.storage;

import com.vectrace.MercurialEclipse.repository.model.AllRootsElement;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HgRepositoryLocation
extends AllRootsElement
implements Comparable<HgRepositoryLocation> {
    private String logicalName;
    private String location;
    private String user;
    private String password;
    private URI uri;
    private static final String SPLIT_TOKEN = "@@@";
    private static final String ALIAS_TOKEN = "@alias@";
    private static final String PASSWORD_TOKEN = ":";

    HgRepositoryLocation(String logicalName, String uri) throws URISyntaxException {
        this(logicalName, uri, null, null);
    }

    HgRepositoryLocation(String logicalName, String uri, String user, String password) throws URISyntaxException {
        String[] alias;
        this.logicalName = logicalName;
        this.location = uri;
        String[] repoInfo = uri.split(SPLIT_TOKEN);
        this.user = user;
        this.password = password;
        if ((this.user == null || this.user.length() == 0) && repoInfo.length > 1) {
            String userInfo = repoInfo[1];
            if (userInfo.contains(ALIAS_TOKEN)) {
                userInfo = userInfo.substring(0, userInfo.indexOf(ALIAS_TOKEN));
            }
            String[] splitUserInfo = userInfo.split(PASSWORD_TOKEN);
            this.user = splitUserInfo[0];
            this.password = splitUserInfo.length > 1 ? splitUserInfo[1] : null;
            this.location = repoInfo[0];
        }
        if ((alias = uri.split(ALIAS_TOKEN)).length == 2 && (logicalName == null || logicalName.length() == 0)) {
            this.logicalName = alias[1];
            if (this.location.contains(ALIAS_TOKEN)) {
                this.location = this.location.substring(0, this.location.indexOf(ALIAS_TOKEN));
            }
        }
        URI myUri = null;
        try {
            myUri = new URI(this.location);
        }
        catch (URISyntaxException uRISyntaxException) {}
        if (myUri != null) {
            if (myUri.getScheme() != null && !myUri.getScheme().equalsIgnoreCase("file")) {
                String userInfo = null;
                if (myUri.getUserInfo() == null) {
                    userInfo = myUri.getScheme().equalsIgnoreCase("ssh") ? this.user : this.createUserinfo(this.user, this.password);
                } else {
                    String[] authorization = myUri.getUserInfo().split(PASSWORD_TOKEN);
                    this.user = authorization[0];
                    if (authorization.length > 1) {
                        this.password = authorization[1];
                    }
                    userInfo = myUri.getScheme().equalsIgnoreCase("ssh") ? this.user : this.createUserinfo(this.user, this.password);
                }
                this.uri = new URI(myUri.getScheme(), userInfo, myUri.getHost(), myUri.getPort(), myUri.getPath(), myUri.getQuery(), myUri.getFragment());
            }
            this.location = new URI(myUri.getScheme(), null, myUri.getHost(), myUri.getPort(), myUri.getPath(), null, myUri.getFragment()).toASCIIString();
        }
    }

    private String createUserinfo(String user, String password) {
        String userInfo = null;
        if (user != null && user.length() > 0) {
            userInfo = user;
            if (password != null && password.length() != 0) {
                userInfo = userInfo.concat(PASSWORD_TOKEN).concat(password);
            }
        }
        return userInfo;
    }

    public static boolean validateLocation(String validate) {
        return validate.trim().length() > 0;
    }

    @Override
    public int compareTo(HgRepositoryLocation loc) {
        return this.location.compareTo(loc.location);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HgRepositoryLocation)) {
            return false;
        }
        HgRepositoryLocation other = (HgRepositoryLocation)obj;
        return !(this.location == null ? other.location != null : !this.location.equals(other.location));
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String toString() {
        if (this.logicalName != null && this.logicalName.length() > 0) {
            return String.valueOf(this.logicalName) + " (" + this.location + ")";
        }
        return this.location;
    }

    public String getSaveString() {
        String r = this.location;
        if (this.uri != null && this.uri.getUserInfo() != null) {
            r = String.valueOf(r) + SPLIT_TOKEN + this.uri.getUserInfo();
        }
        if (this.logicalName != null && this.logicalName.length() > 0) {
            r = String.valueOf(r) + ALIAS_TOKEN + this.logicalName;
        }
        return r;
    }

    @Override
    public Object[] internalGetChildren(Object o, IProgressMonitor monitor) {
        return new HgRepositoryLocation[0];
    }

    @Override
    public ImageDescriptor getImageDescriptor(Object object) {
        return super.getImageDescriptor(object);
    }

    public URI getUri() {
        return this.uri;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDisplayLocation() {
        if (this.uri == null) {
            return this.location;
        }
        try {
            return new URI(this.uri.getScheme(), this.user, this.uri.getHost(), this.uri.getPort(), this.uri.getPath(), this.uri.getQuery(), this.uri.getFragment()).toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public String getLogicalName() {
        return this.logicalName;
    }
}

