/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.storage;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.repository.IRepositoryListener;
import com.vectrace.MercurialEclipse.repository.RepositoryResourcesManager;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.storage.Messages;
import com.vectrace.MercurialEclipse.team.MercurialTeamProvider;
import com.vectrace.MercurialEclipse.team.cache.RefreshStatusJob;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.RepositoryProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HgRepositoryLocationManager {
    private static final RepositoryResourcesManager REPOSITORY_RESOURCES_MANAGER = RepositoryResourcesManager.getInstance();
    private static final String REPO_LOCACTION_FILE = "repositories.txt";
    private final SortedSet<HgRepositoryLocation> repos = new TreeSet<HgRepositoryLocation>();
    private final Map<IProject, SortedSet<HgRepositoryLocation>> projectRepos = new HashMap<IProject, SortedSet<HgRepositoryLocation>>();
    private boolean initDone;

    private File getLocationFile() {
        return MercurialEclipsePlugin.getDefault().getStateLocation().append(REPO_LOCACTION_FILE).toFile();
    }

    public boolean cleanup(IProject project) {
        return this.getProjectLocationFile(project).delete();
    }

    public void start() throws IOException, HgException {
        block8: {
            File file = this.getLocationFile();
            if (file.exists()) {
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                try {
                    try {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            this.addRepoLocation(new HgRepositoryLocation(null, line, null, null));
                        }
                    }
                    catch (URISyntaxException e) {
                        MercurialEclipsePlugin.logError(e);
                        reader.close();
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    reader.close();
                    throw throwable;
                }
                reader.close();
            }
        }
        Set<IProject> managedProjects = this.loadProjectRepos();
        for (IProject project : managedProjects) {
            new RefreshStatusJob("Init hg cache for " + project.getName(), project).schedule(50L);
        }
    }

    public void stop() throws IOException {
        File file = this.getLocationFile();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        try {
            for (HgRepositoryLocation repo : this.repos) {
                writer.write(repo.getSaveString());
                writer.write(10);
            }
        }
        finally {
            writer.close();
        }
        this.saveProjectRepos();
    }

    public Set<HgRepositoryLocation> getAllRepoLocations() {
        return Collections.unmodifiableSet(this.repos);
    }

    public Set<HgRepositoryLocation> getAllProjectRepoLocations(IProject project) {
        SortedSet<HgRepositoryLocation> loc = this.projectRepos.get(project);
        if (loc != null) {
            return Collections.unmodifiableSet(loc);
        }
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<IProject> getAllRepoLocationProjects(HgRepositoryLocation repo) {
        Map<IProject, SortedSet<HgRepositoryLocation>> map = this.projectRepos;
        synchronized (map) {
            try {
                this.getProjectRepos();
            }
            catch (Exception e) {
                MercurialEclipsePlugin.logError(e);
            }
        }
        Set<IProject> loc = this.projectRepos.keySet();
        HashSet<IProject> projects = new HashSet<IProject>();
        for (IProject project : loc) {
            SortedSet<HgRepositoryLocation> set = this.projectRepos.get(project);
            if (set == null || !set.contains(repo)) continue;
            projects.add(project);
        }
        return Collections.unmodifiableSet(projects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addRepoLocation(HgRepositoryLocation loc) {
        SortedSet<HgRepositoryLocation> sortedSet = this.repos;
        synchronized (sortedSet) {
            this.repos.remove(loc);
            this.repos.add(loc);
            REPOSITORY_RESOURCES_MANAGER.repositoryAdded(loc);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean internalAddRepoLocation(IProject project, HgRepositoryLocation loc) {
        if (loc == null) {
            return false;
        }
        this.addRepoLocation(loc);
        Map<IProject, SortedSet<HgRepositoryLocation>> map = this.projectRepos;
        synchronized (map) {
            SortedSet<HgRepositoryLocation> repoSet = this.projectRepos.get(project);
            if (repoSet == null) {
                repoSet = new TreeSet<HgRepositoryLocation>();
            }
            repoSet.add(loc);
            this.projectRepos.put(project, repoSet);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addRepoLocation(IProject project, HgRepositoryLocation loc) throws HgException {
        if (loc == null) {
            return false;
        }
        this.addRepoLocation(loc);
        Map<IProject, SortedSet<HgRepositoryLocation>> map = this.projectRepos;
        synchronized (map) {
            try {
                this.getProjectRepos();
            }
            catch (IOException e) {
                MercurialEclipsePlugin.logError(e);
            }
            SortedSet<HgRepositoryLocation> repoSet = this.projectRepos.get(project);
            if (repoSet == null) {
                repoSet = new TreeSet<HgRepositoryLocation>();
            }
            repoSet.add(loc);
            this.projectRepos.put(project, repoSet);
        }
        return true;
    }

    private Map<IProject, SortedSet<HgRepositoryLocation>> getProjectRepos() throws IOException, HgException {
        if (!this.initDone) {
            this.initDone = true;
            this.loadProjectRepos();
        }
        return this.projectRepos;
    }

    /*
     * Exception decompiling
     */
    private Set<IProject> loadProjectRepos() throws IOException, HgException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[UNCONDITIONALDOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setDefaultProjectRepository(IProject project, HgRepositoryLocation loc) throws CoreException {
        if (loc != null) {
            project.setPersistentProperty(MercurialTeamProvider.QUALIFIED_NAME_PROJECT_SOURCE_REPOSITORY, loc.getLocation());
        } else {
            project.setPersistentProperty(MercurialTeamProvider.QUALIFIED_NAME_PROJECT_SOURCE_REPOSITORY, null);
        }
    }

    public HgRepositoryLocation getDefaultProjectRepoLocation(IProject project) {
        try {
            return this.matchRepoLocation(this.getDefaultProjectRepository(project));
        }
        catch (CoreException e) {
            MercurialEclipsePlugin.logError(e);
            return null;
        }
    }

    private String getDefaultProjectRepository(IProject project) throws CoreException {
        String url = project.getPersistentProperty(MercurialTeamProvider.QUALIFIED_NAME_PROJECT_SOURCE_REPOSITORY);
        return url;
    }

    private File getProjectLocationFile(IProject project) {
        File file = MercurialEclipsePlugin.getDefault().getStateLocation().append("repositories.txt_" + project.getName()).toFile();
        return file;
    }

    private void saveProjectRepos() throws IOException {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            File file = this.getProjectLocationFile(project);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            try {
                SortedSet<HgRepositoryLocation> repoSet = this.projectRepos.get(project);
                if (repoSet != null) {
                    for (HgRepositoryLocation repo : repoSet) {
                        writer.write(repo.getSaveString());
                        writer.write(10);
                    }
                }
            }
            finally {
                writer.close();
            }
            ++n2;
        }
    }

    public HgRepositoryLocation getRepoLocation(String url) throws URISyntaxException {
        return this.getRepoLocation(url, null, null);
    }

    public HgRepositoryLocation getRepoLocation(String url, String user, String pass) throws URISyntaxException {
        HgRepositoryLocation location = this.matchRepoLocation(url);
        if (location != null && (user == null || user.length() == 0 || user.equals(location.getUser()))) {
            return location;
        }
        return new HgRepositoryLocation(null, url, user, pass);
    }

    private HgRepositoryLocation matchRepoLocation(String url) {
        for (HgRepositoryLocation loc : this.repos) {
            if (!loc.getLocation().equals(url)) continue;
            return loc;
        }
        return null;
    }

    public HgRepositoryLocation updateRepoLocation(String url, String logicalName, String user, String pass) throws URISyntaxException {
        HgRepositoryLocation loc = this.matchRepoLocation(url);
        if (loc == null) {
            loc = new HgRepositoryLocation(logicalName, url, user, pass);
            this.addRepoLocation(loc);
            return loc;
        }
        boolean update = false;
        String myLogicalName = logicalName;
        String myUser = user;
        String myPass = pass;
        if (logicalName != null && logicalName.length() > 0 && !logicalName.equals(loc.getLogicalName())) {
            update = true;
        } else {
            myLogicalName = loc.getLogicalName();
        }
        if (user != null && user.length() > 0 && !user.equals(loc.getUser())) {
            update = true;
        } else {
            myUser = loc.getUser();
        }
        if (pass != null && pass.length() > 0 && !pass.equals(loc.getPassword())) {
            update = true;
        } else {
            myPass = loc.getPassword();
        }
        if (update) {
            HgRepositoryLocation updated = new HgRepositoryLocation(myLogicalName, loc.getLocation(), myUser, myPass);
            this.repos.remove(updated);
            this.repos.add(updated);
            for (SortedSet<HgRepositoryLocation> locs : this.projectRepos.values()) {
                if (!locs.remove(updated)) continue;
                locs.add(updated);
            }
            REPOSITORY_RESOURCES_MANAGER.repositoryModified(updated);
            return updated;
        }
        return loc;
    }

    public HgRepositoryLocation fromProperties(Properties configuration) throws HgException, URISyntaxException {
        String url;
        String rootUrl;
        String user = configuration.getProperty("user");
        if (user == null || user.length() == 0) {
            user = null;
        }
        String password = configuration.getProperty("password");
        if (user == null) {
            password = null;
        }
        if ((rootUrl = configuration.getProperty("rootUrl")) == null || rootUrl.length() == 0) {
            rootUrl = null;
        }
        if ((url = configuration.getProperty("url")) == null) {
            throw new HgException(Messages.getString("HgRepositoryLocation.urlMustNotBeNull"));
        }
        return this.updateRepoLocation(url, null, user, password);
    }

    public void addRepositoryListener(IRepositoryListener repListener) {
        REPOSITORY_RESOURCES_MANAGER.addRepositoryListener(repListener);
    }

    public void refreshRepositories(IProgressMonitor monitor) throws HgException, IOException {
        this.stop();
        this.start();
    }

    public HgRepositoryLocation createRepository(Properties configuration) throws HgException {
        HgRepositoryLocation location;
        try {
            location = this.fromProperties(configuration);
        }
        catch (URISyntaxException e) {
            throw new HgException(Messages.getString("HgRepositoryLocationManager.couldntCreate"), e);
        }
        this.addRepoLocation(location);
        return location;
    }

    public void removeRepositoryListener(IRepositoryListener repositoryListener) {
        REPOSITORY_RESOURCES_MANAGER.removeRepositoryListener(repositoryListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeRepository(HgRepositoryLocation hgRepositoryLocation) throws CoreException {
        Assert.isNotNull((Object)hgRepositoryLocation);
        Object object = this.projectRepos;
        synchronized (object) {
            block6: for (IProject project : this.projectRepos.keySet()) {
                SortedSet<HgRepositoryLocation> pRepos;
                if (RepositoryProvider.getProvider((IProject)project, (String)"com.vectrace.MercurialEclipse.team.MercurialTeamProvider") == null || !project.isAccessible()) continue;
                String url = this.getDefaultProjectRepository(project);
                if (url != null && url.equals(hgRepositoryLocation.getLocation())) {
                    this.setDefaultProjectRepository(project, null);
                }
                if ((pRepos = this.projectRepos.get(project)) == null) continue;
                for (HgRepositoryLocation repo : pRepos) {
                    if (!repo.equals(hgRepositoryLocation)) continue;
                    pRepos.remove(repo);
                    continue block6;
                }
            }
        }
        object = this.repos;
        synchronized (object) {
            for (HgRepositoryLocation loc : this.repos) {
                if (!loc.equals(hgRepositoryLocation)) continue;
                this.repos.remove(loc);
                break;
            }
            REPOSITORY_RESOURCES_MANAGER.repositoryRemoved(hgRepositoryLocation);
        }
    }
}

