/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.team;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.AbstractClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.HgRoot;
import com.vectrace.MercurialEclipse.team.MercurialUtilities;
import com.vectrace.MercurialEclipse.team.Messages;
import com.vectrace.MercurialEclipse.team.cache.MercurialStatusCache;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class ActionRemove
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;
    private IStructuredSelection selection;

    public void dispose() {
    }

    public void init(IWorkbenchWindow w) {
        this.window = w;
    }

    public void run(IAction action) {
        Shell shell;
        if (this.window != null && this.window.getShell() != null) {
            shell = this.window.getShell();
        } else {
            IWorkbench workbench = PlatformUI.getWorkbench();
            shell = workbench.getActiveWorkbenchWindow().getShell();
        }
        String[] launchCmd = new String[]{MercurialUtilities.getHGExecutable(), "remove", "-Af", "--", ""};
        Iterator itr = this.selection.iterator();
        HashSet<IProject> projects = new HashSet<IProject>();
        while (itr.hasNext()) {
            IResource resource;
            Object obj = itr.next();
            if (!(obj instanceof IResource) || obj instanceof IProject || !MercurialUtilities.hgIsTeamProviderFor(resource = (IResource)obj, true)) continue;
            try {
                HgRoot root = AbstractClient.getHgRoot(resource);
                launchCmd[4] = root.toRelative(resource.getLocation().toFile());
                if (!this.confirmRemove(shell, launchCmd[4])) continue;
                projects.add(resource.getProject());
                String output = MercurialUtilities.executeCommand(launchCmd, root, false);
                if (output == null || output.length() == 0) continue;
                MessageDialog.openInformation((Shell)shell, (String)Messages.getString("ActionRemove.removeOutput"), (String)output);
            }
            catch (HgException e) {
                MercurialEclipsePlugin.logError((Throwable)((Object)e));
            }
        }
        for (IProject proj : projects) {
            try {
                MercurialStatusCache.getInstance().refreshStatus((IResource)proj, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (TeamException e) {
                MercurialEclipsePlugin.logError(Messages.getString("ActionRemove.unableToRefresh"), e);
            }
        }
    }

    private boolean confirmRemove(Shell shell, String fileName) {
        return MessageDialog.openConfirm((Shell)shell, (String)Messages.getString("ActionRemove.removeFileQuestion"), (String)(String.valueOf(Messages.getString("ActionRemove.removeFileConfirmation")) + fileName + Messages.getString("ActionRemove.removeFileConfirmation.2")));
    }

    public void selectionChanged(IAction action, ISelection in_selection) {
        if (in_selection != null && in_selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)in_selection;
        }
    }
}

