/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.team;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.HgRemoveClient;
import com.vectrace.MercurialEclipse.commands.HgRenameClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.team.Messages;
import com.vectrace.MercurialEclipse.team.cache.MercurialStatusCache;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.resources.team.IResourceTree;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class HgMoveDeleteHook
implements IMoveDeleteHook {
    private static final MercurialStatusCache CACHE = MercurialStatusCache.getInstance();

    private boolean isInMercurialRepo(IResource file, IProgressMonitor monitor) {
        return CACHE.isSupervised(file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean folderHasMercurialFiles(IFolder folder, IProgressMonitor monitor) {
        if (!this.isInMercurialRepo((IResource)folder, monitor)) {
            return false;
        }
        try {
            IResource[] children;
            IResource[] iResourceArray = children = folder.members();
            int n = children.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IResource resource = iResourceArray[n2];
                if (resource.getType() == 1 ? resource.exists() && this.isInMercurialRepo(resource, monitor) : this.folderHasMercurialFiles((IFolder)resource, monitor)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public boolean deleteFile(IResourceTree tree, IFile file, int updateFlags, IProgressMonitor monitor) {
        if (!this.isInMercurialRepo((IResource)file, monitor) || file.isDerived()) {
            return false;
        }
        return this.deleteHgFiles(tree, (IResource)file, monitor);
    }

    public boolean deleteFolder(IResourceTree tree, IFolder folder, int updateFlags, IProgressMonitor monitor) {
        if (!this.folderHasMercurialFiles(folder, monitor)) {
            return false;
        }
        return this.deleteHgFiles(tree, (IResource)folder, monitor);
    }

    private boolean deleteHgFiles(IResourceTree tree, IResource resource, IProgressMonitor monitor) {
        try {
            HgRemoveClient.removeResource(resource, monitor);
        }
        catch (HgException e) {
            MercurialEclipsePlugin.logError((Throwable)((Object)e));
            return false;
        }
        if (resource.getType() == 2) {
            tree.deletedFolder((IFolder)resource);
        } else {
            tree.deletedFile((IFile)resource);
        }
        return true;
    }

    public boolean deleteProject(IResourceTree tree, IProject project, int updateFlags, IProgressMonitor monitor) {
        if ((updateFlags & 4) != 0) {
            IFolder folder = project.getFolder(".hg");
            try {
                folder.delete(updateFlags, monitor);
            }
            catch (CoreException e) {
                MercurialEclipsePlugin.logError(e);
                return true;
            }
        }
        return false;
    }

    public boolean moveFile(IResourceTree tree, IFile source, IFile destination, int updateFlags, IProgressMonitor monitor) {
        if (!this.isInMercurialRepo((IResource)source, monitor)) {
            return false;
        }
        if (!this.moveHgFiles((IResource)source, (IResource)destination, monitor)) {
            return true;
        }
        tree.movedFile(source, destination);
        return true;
    }

    public boolean moveFolder(IResourceTree tree, IFolder source, IFolder destination, int updateFlags, IProgressMonitor monitor) {
        if (!this.folderHasMercurialFiles(source, monitor)) {
            return false;
        }
        if (!this.moveHgFiles((IResource)source, (IResource)destination, monitor)) {
            return true;
        }
        tree.movedFolderSubtree(source, destination);
        return true;
    }

    private boolean moveHgFiles(IResource source, IResource destination, IProgressMonitor monitor) {
        try {
            HgRenameClient.renameResource(source, destination, monitor);
        }
        catch (HgException e) {
            MercurialEclipsePlugin.logError(Messages.getString("HgMoveDeleteHook.moveFailed"), (Throwable)((Object)e));
            return false;
        }
        return true;
    }

    public boolean moveProject(IResourceTree tree, IProject source, IProjectDescription description, int updateFlags, IProgressMonitor monitor) {
        return false;
    }
}

