/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.team;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.HgRoot;
import com.vectrace.MercurialEclipse.operations.InitOperation;
import com.vectrace.MercurialEclipse.team.MercurialTeamProvider;
import com.vectrace.MercurialEclipse.team.MercurialUtilities;
import com.vectrace.MercurialEclipse.team.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.ui.IConfigurationWizard;
import org.eclipse.ui.IWorkbench;

public class MercurialConfigurationWizard
extends Wizard
implements IConfigurationWizard {
    private IProject project;
    private String hgPath;
    private HgRoot foundhgPath;
    private Text directoryText;
    private NewWizardPage page;
    private String hgPathOriginal;

    public MercurialConfigurationWizard() {
        this.setWindowTitle(Messages.getString("MercurialConfigurationWizard.wizardTitle"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        try {
            this.foundhgPath = MercurialTeamProvider.getHgRoot((IResource)this.project);
        }
        catch (HgException hgException) {}
        if (this.foundhgPath == null) {
            this.hgPathOriginal = this.hgPath = this.project.getLocation().toString();
            this.page = new NewWizardPage(true);
            this.addPage((IWizardPage)this.page);
        } else {
            this.hgPathOriginal = this.hgPath = this.foundhgPath.getAbsolutePath();
            this.page = new NewWizardPage(false);
            this.addPage((IWizardPage)this.page);
        }
    }

    public boolean performFinish() {
        if (this.directoryText != null) {
            this.hgPath = this.directoryText.getText();
        }
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)new InitOperation((IRunnableContext)this.getContainer(), this.project, this.foundhgPath, this.hgPath));
        }
        catch (Exception e) {
            MercurialEclipsePlugin.logError(e);
            this.page.setErrorMessage(e.getCause().getLocalizedMessage());
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IProject proj) {
        this.project = proj;
        if (!MercurialUtilities.isHgExecutableCallable()) {
            MercurialUtilities.configureHgExecutable();
        }
    }

    private class NewWizardPage
    extends WizardPage
    implements SelectionListener {
        Button changeDirButton;
        Button restoreDefaultDirButton;
        Button restoreExistingDirButton;
        boolean newMercurialProject;

        NewWizardPage(boolean newMercurialProject) {
            super(WizardPage.class.getName());
            this.newMercurialProject = newMercurialProject;
            if (newMercurialProject) {
                this.setTitle(Messages.getString("MercurialConfigurationWizard.titleNew"));
                this.setDescription(Messages.getString("MercurialConfigurationWizard.descriptionNew"));
            } else {
                this.setTitle(Messages.getString("MercurialConfigurationWizard.titleExisting"));
                this.setDescription(Messages.getString("MercurialConfigurationWizard.descriptionExisting"));
            }
            this.setPageComplete(true);
        }

        public void createControl(Composite parent) {
            Composite mainControl = new Composite(parent, 0);
            mainControl.setLayout((Layout)new GridLayout(3, false));
            Label label = new Label(mainControl, 0x1000000);
            label.setText(Messages.getString("MercurialConfigurationWizard.selectDirectory"));
            MercurialConfigurationWizard.this.directoryText = new Text(mainControl, 2048);
            MercurialConfigurationWizard.this.directoryText.setLayoutData((Object)new GridData(768));
            MercurialConfigurationWizard.this.directoryText.setText(MercurialConfigurationWizard.this.hgPath);
            MercurialConfigurationWizard.this.directoryText.addSelectionListener((SelectionListener)this);
            this.changeDirButton = new Button(mainControl, 0x1000008);
            this.changeDirButton.setText(Messages.getString("MercurialConfigurationWizard.changeDirectory"));
            this.changeDirButton.addSelectionListener((SelectionListener)this);
            this.restoreDefaultDirButton = new Button(mainControl, 0x1000008);
            this.restoreDefaultDirButton.setText(Messages.getString("MercurialConfigurationWizard.useProjectRoot"));
            this.restoreDefaultDirButton.addSelectionListener((SelectionListener)this);
            if (!this.newMercurialProject) {
                this.restoreExistingDirButton = new Button(mainControl, 0x1000008);
                this.restoreExistingDirButton.setText(Messages.getString("MercurialConfigurationWizard.useExistingHgDir"));
                this.restoreExistingDirButton.addSelectionListener((SelectionListener)this);
            }
            this.setControl((Control)mainControl);
            this.setPageComplete(true);
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == this.changeDirButton) {
                DirectoryDialog directoryDialog = new DirectoryDialog(new Shell());
                directoryDialog.setText(Messages.getString("MercurialConfigurationWizard.selectMercurialRoot"));
                directoryDialog.setMessage(Messages.getString("MercurialConfigurationWizard.selectMercurialRootMsg"));
                MercurialConfigurationWizard.this.hgPath = directoryDialog.open();
                if (MercurialConfigurationWizard.this.hgPath != null) {
                    MercurialConfigurationWizard.this.directoryText.setText(MercurialConfigurationWizard.this.hgPath);
                }
            } else if (e.widget == this.restoreDefaultDirButton) {
                MercurialConfigurationWizard.this.hgPath = MercurialConfigurationWizard.this.hgPathOriginal;
                MercurialConfigurationWizard.this.directoryText.setText(MercurialConfigurationWizard.this.hgPath);
            } else if (e.widget == MercurialConfigurationWizard.this.directoryText) {
                MercurialConfigurationWizard.this.hgPath = MercurialConfigurationWizard.this.directoryText.getText();
                MercurialConfigurationWizard.this.directoryText.setText(MercurialConfigurationWizard.this.hgPath);
            } else if (!this.newMercurialProject && e.widget == this.restoreExistingDirButton) {
                MercurialConfigurationWizard.this.hgPath = MercurialConfigurationWizard.this.hgPathOriginal;
                MercurialConfigurationWizard.this.directoryText.setText(MercurialConfigurationWizard.this.hgPath);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            if (e.widget == MercurialConfigurationWizard.this.directoryText) {
                MercurialConfigurationWizard.this.hgPath = MercurialConfigurationWizard.this.directoryText.getText();
                MercurialConfigurationWizard.this.directoryText.setText(MercurialConfigurationWizard.this.hgPath);
            }
        }
    }
}

