/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.team;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.SafeUiJob;
import com.vectrace.MercurialEclipse.commands.AbstractClient;
import com.vectrace.MercurialEclipse.commands.HgClients;
import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.commands.HgConfigClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.team.Messages;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.Team;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class MercurialUtilities {
    private MercurialUtilities() {
    }

    public static boolean isHgExecutableCallable() {
        try {
            Runtime.getRuntime().exec(MercurialUtilities.getHGExecutable());
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static String getHGExecutable() {
        return HgClients.getPreference("hg", "hg");
    }

    public static String getPreference(String preferenceConstant, String defaultIfNotSet) {
        IPreferenceStore preferenceStore = MercurialEclipsePlugin.getDefault().getPreferenceStore();
        String pref = preferenceStore.getString(preferenceConstant);
        if (pref.length() > 0) {
            return pref;
        }
        return defaultIfNotSet;
    }

    public static String getHGExecutable(boolean configureIfMissing) {
        if (MercurialUtilities.isHgExecutableCallable()) {
            return MercurialUtilities.getHGExecutable();
        }
        if (configureIfMissing) {
            MercurialUtilities.configureHgExecutable();
            return MercurialUtilities.getHGExecutable();
        }
        return "hg";
    }

    public static String getGpgExecutable(boolean configureIfMissing) {
        if (MercurialUtilities.isGpgExecutableCallable()) {
            return MercurialUtilities.getGpgExecutable();
        }
        if (configureIfMissing) {
            MercurialUtilities.configureGpgExecutable();
            return MercurialUtilities.getGpgExecutable();
        }
        return "gpg";
    }

    public static void configureGpgExecutable() {
        MercurialUtilities.configureHgExecutable();
    }

    private static boolean isGpgExecutableCallable() {
        try {
            Runtime.getRuntime().exec(MercurialUtilities.getGpgExecutable());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String getGpgExecutable() {
        String executable = HgClients.getPreference("hg.gpg.executable", "gpg");
        if (executable == null || executable.length() == 0) {
            return "false";
        }
        return executable;
    }

    public static void configureHgExecutable() {
        new SafeUiJob(Messages.getString("MercurialUtilities.openingPreferencesForConfiguringMercurialEclipse")){

            protected IStatus runSafe(IProgressMonitor monitor) {
                String pageId = "com.vectrace.MercurialEclipse.prefspage";
                String[] dsplIds = null;
                Object data = null;
                PreferenceDialog dlg = PreferencesUtil.createPreferenceDialogOn((Shell)this.getDisplay().getActiveShell(), (String)pageId, (String[])dsplIds, data);
                dlg.setErrorMessage(String.valueOf(Messages.getString("MercurialUtilities.errorNotConfiguredCorrectly")) + Messages.getString("MercurialUtilities.runDebugInstall"));
                dlg.open();
                return super.runSafe(monitor);
            }
        }.schedule();
    }

    public static boolean isPossiblySupervised(IResource resource) {
        boolean isInHg = MercurialUtilities.hgIsTeamProviderFor(resource, false);
        if (!isInHg) {
            return false;
        }
        return !Team.isIgnoredHint((IResource)resource) && !resource.isTeamPrivateMember() && !resource.isDerived();
    }

    public static boolean hgIsTeamProviderFor(IResource resource, boolean dialog) {
        if (resource == null) {
            return false;
        }
        IProject project = resource.getProject();
        if (project == null || RepositoryProvider.getProvider((IProject)project, (String)"com.vectrace.MercurialEclipse.team.MercurialTeamProvider") == null) {
            return false;
        }
        if (resource instanceof IProject) {
            return true;
        }
        boolean isLinked = resource.isLinked(512);
        if (dialog && isLinked) {
            Shell shell = null;
            IWorkbench workbench = null;
            workbench = PlatformUI.getWorkbench();
            if (workbench != null && workbench.getActiveWorkbenchWindow() != null) {
                shell = workbench.getActiveWorkbenchWindow().getShell();
            }
            if (shell != null) {
                MessageDialog.openInformation((Shell)shell, (String)Messages.getString("MercurialUtilities.linkWarningShort"), (String)Messages.getString("MercurialUtilities.linkWarningLong"));
            }
        }
        return !isLinked;
    }

    public static String getHGUsername() {
        IPreferenceStore preferenceStore = MercurialEclipsePlugin.getDefault().getPreferenceStore();
        String executable = preferenceStore.getString("user.name");
        return executable;
    }

    public static String getHGUsername(boolean configureIfMissing) {
        String uname = MercurialUtilities.getHGUsername();
        if (uname != null && uname.length() != 0) {
            return uname;
        }
        if (configureIfMissing) {
            MercurialUtilities.configureUsername();
            return MercurialUtilities.getHGUsername();
        }
        try {
            return HgConfigClient.getHgConfigLine(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile(), "ui.username");
        }
        catch (HgException hgException) {
            return System.getProperty("user.name");
        }
    }

    public static void configureUsername() {
        Shell shell = Display.getCurrent().getActiveShell();
        String pageId = "com.vectrace.MercurialEclipse.prefspage";
        String[] dsplIds = null;
        Object data = null;
        PreferenceDialog dlg = PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)pageId, (String[])dsplIds, data);
        dlg.open();
    }

    public static String executeCommand(String[] cmd, File workingDir, boolean consoleOutput) throws HgException {
        return MercurialUtilities.execute(cmd, workingDir).executeToString();
    }

    private static LegacyAdaptor execute(String[] cmd, File workingDir) {
        String[] copy = new String[cmd.length - 2];
        System.arraycopy(cmd, 2, copy, 0, cmd.length - 2);
        LegacyAdaptor legacyAdaptor = new LegacyAdaptor(cmd[1], workingDir, true);
        legacyAdaptor.args(copy);
        return legacyAdaptor;
    }

    public static boolean isCommandAvailable(String command, QualifiedName sessionPropertyName, String extensionEnabler) throws HgException {
        try {
            boolean returnValue;
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            Object prop = workspaceRoot.getSessionProperty(sessionPropertyName);
            if (prop != null) {
                returnValue = (Boolean)prop;
            } else {
                returnValue = AbstractClient.isCommandAvailable(command, extensionEnabler);
                workspaceRoot.setSessionProperty(sessionPropertyName, (Object)returnValue);
            }
            return returnValue;
        }
        catch (CoreException e) {
            throw new HgException(e);
        }
    }

    private static class LegacyAdaptor
    extends HgCommand {
        protected LegacyAdaptor(String command, File workingDir, boolean escapeFiles) {
            super(command, workingDir, escapeFiles);
        }

        LegacyAdaptor args(String ... arguments) {
            this.addOptions(arguments);
            return this;
        }

        public String executeToString() throws HgException {
            return super.executeToString();
        }

        public byte[] executeToBytes() throws HgException {
            return super.executeToBytes();
        }
    }
}

