/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.team.cache;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.AbstractClient;
import com.vectrace.MercurialEclipse.commands.HgClients;
import com.vectrace.MercurialEclipse.commands.HgIdentClient;
import com.vectrace.MercurialEclipse.commands.HgLogClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.model.HgRoot;
import com.vectrace.MercurialEclipse.team.cache.AbstractCache;
import com.vectrace.MercurialEclipse.team.cache.MercurialStatusCache;
import com.vectrace.MercurialEclipse.team.cache.Messages;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Observer;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.team.core.RepositoryProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalChangesetCache
extends AbstractCache {
    private static final MercurialStatusCache STATUS_CACHE = MercurialStatusCache.getInstance();
    private static LocalChangesetCache instance;
    private final Map<IPath, SortedSet<ChangeSet>> localChangeSets = new HashMap<IPath, SortedSet<ChangeSet>>();
    private int logBatchSize;
    private boolean isGetFileInformationForChangesets;

    private LocalChangesetCache() {
    }

    private boolean isGetFileInformationForChangesets() {
        return this.isGetFileInformationForChangesets;
    }

    public static synchronized LocalChangesetCache getInstance() {
        if (instance == null) {
            instance = new LocalChangesetCache();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(IResource resource, boolean notify) {
        Set<IResource> members = this.getMembers(resource);
        members.add(resource);
        Map<IPath, SortedSet<ChangeSet>> map = this.localChangeSets;
        synchronized (map) {
            for (IResource member : members) {
                this.localChangeSets.remove(member.getLocation());
            }
        }
        if (resource instanceof IProject) {
            this.clearChangesets(resource.getProject());
        }
    }

    @Override
    protected void clearProjectCache(IProject project) {
        super.clearProjectCache(project);
        this.clear((IResource)project, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<ChangeSet> getLocalChangeSets(IResource resource) throws HgException {
        SortedSet<ChangeSet> revisions;
        IPath location = resource.getLocation();
        Map<IPath, SortedSet<ChangeSet>> map = this.localChangeSets;
        synchronized (map) {
            revisions = this.localChangeSets.get(location);
            if (revisions == null && (resource.getType() == 1 || resource.getType() == 4 && STATUS_CACHE.isSupervised(resource) && !STATUS_CACHE.isAdded(location))) {
                this.refreshAllLocalRevisions(resource, true);
                revisions = this.localChangeSets.get(location);
            }
        }
        if (revisions != null) {
            return Collections.unmodifiableSortedSet(revisions);
        }
        return null;
    }

    public ChangeSet getNewestLocalChangeSet(IResource resource) throws HgException {
        SortedSet<ChangeSet> revisions = this.getLocalChangeSets(resource);
        if (revisions != null && revisions.size() > 0) {
            return revisions.last();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocallyKnown(IResource resource) throws HgException {
        Map<IPath, SortedSet<ChangeSet>> map = this.localChangeSets;
        synchronized (map) {
            return this.localChangeSets.containsKey(resource.getLocation());
        }
    }

    public void refreshAllLocalRevisions(IResource res, boolean limit) throws HgException {
        this.refreshAllLocalRevisions(res, limit, this.isGetFileInformationForChangesets());
    }

    public void refreshAllLocalRevisions(IResource res, boolean limit, boolean withFiles) throws HgException {
        Assert.isNotNull((Object)res);
        IProject project = res.getProject();
        if (project.isOpen() && RepositoryProvider.getProvider((IProject)project, (String)"com.vectrace.MercurialEclipse.team.MercurialTeamProvider") != null) {
            this.clear(res, false);
            this.fetchLocalRevisions(res, limit, this.getLogBatchSize(), -1, withFiles);
        }
    }

    @Override
    protected void configureFromPreferences(IPreferenceStore store) {
        this.logBatchSize = store.getInt("hg.batchsize.log");
        if (this.logBatchSize < 0) {
            this.logBatchSize = 2000;
            MercurialEclipsePlugin.logWarning(Messages.localChangesetCache_LogLimitNotCorrectlyConfigured, null);
        }
        this.isGetFileInformationForChangesets = store.getBoolean("hg.performance.fileShowsChangeset");
    }

    public int getLogBatchSize() {
        return this.logBatchSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeSet getLocalChangeSet(IResource res, String nodeId) throws HgException {
        Assert.isNotNull((Object)res);
        Assert.isNotNull((Object)nodeId);
        ChangeSet changeSet = this.getChangeset(res.getProject(), nodeId);
        if (changeSet != null) {
            return changeSet;
        }
        Map<IPath, SortedSet<ChangeSet>> map = this.localChangeSets;
        synchronized (map) {
            changeSet = HgLogClient.getChangeset(res, nodeId, this.isGetFileInformationForChangesets());
            if (changeSet == null) {
                return changeSet;
            }
            if (!res.exists() || STATUS_CACHE.isSupervised(res)) {
                HashSet<ChangeSet> set = new HashSet<ChangeSet>();
                set.add(changeSet);
                this.addChangesets(res.getProject(), set);
            }
        }
        return changeSet;
    }

    public ChangeSet getCurrentWorkDirChangeset(IResource res) throws HgException {
        HgRoot root = HgClients.getHgRoot(res);
        String nodeId = HgIdentClient.getCurrentChangesetId(root);
        if (!"0000000000000000000000000000000000000000".equals(nodeId)) {
            return this.getLocalChangeSet(res, nodeId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchLocalRevisions(IResource res, boolean limit, int limitNumber, int startRev, boolean withFiles) throws HgException {
        Assert.isNotNull((Object)res);
        IProject project = res.getProject();
        if (!project.isOpen() || !STATUS_CACHE.isSupervised(res)) {
            return;
        }
        HgRoot root = AbstractClient.getHgRoot(res);
        Map<IPath, SortedSet<ChangeSet>> map = this.localChangeSets;
        synchronized (map) {
            Map<IPath, SortedSet<ChangeSet>> revisions = limit ? HgLogClient.getProjectLog(res, limitNumber, startRev, withFiles) : HgLogClient.getCompleteProjectLog(res, withFiles);
            if (revisions == null || revisions.size() <= 0) {
                return;
            }
            if (res.getType() != 4) {
                Path rootPath = new Path(root.getAbsolutePath());
                this.localChangeSets.put(res.getLocation(), revisions.get(rootPath));
            }
            for (Map.Entry<IPath, SortedSet<ChangeSet>> mapEntry : revisions.entrySet()) {
                IResource myResource;
                IPath path = mapEntry.getKey();
                SortedSet<ChangeSet> changes = mapEntry.getValue();
                if (changes == null && limit && withFiles && STATUS_CACHE.isSupervised((IResource)project, path) && !STATUS_CACHE.isAdded(path) && (myResource = this.convertRepoRelPath(root, project, root.toRelative(path.toFile()))) != null) {
                    changes = HgLogClient.getRecentProjectLog(myResource, 1, withFiles).get(path);
                }
                this.addChangesToLocalCache(project, path, changes);
            }
        }
    }

    @Override
    public synchronized void addObserver(Observer o) {
        MercurialEclipsePlugin.logError(new UnsupportedOperationException("Observer not supported: " + o));
    }

    @Override
    public synchronized void deleteObserver(Observer o) {
    }

    @Override
    protected void notifyChanged(IResource resource, boolean expandMembers) {
        MercurialEclipsePlugin.logError(new UnsupportedOperationException("notifyChanged not supported"));
    }

    @Override
    protected void notifyChanged(Set<IResource> resources, boolean expandMembers) {
        MercurialEclipsePlugin.logError(new UnsupportedOperationException("notifyChanged not supported"));
    }

    private void addChangesToLocalCache(IProject project, IPath path, SortedSet<ChangeSet> changes) {
        if (changes != null && changes.size() > 0) {
            SortedSet<ChangeSet> existing = this.localChangeSets.get(path);
            if (existing == null) {
                existing = new TreeSet<ChangeSet>();
                this.localChangeSets.put(path, existing);
            }
            existing.addAll(changes);
            this.addChangesets(project, changes);
        }
    }

    public SortedSet<ChangeSet> getLocalChangeSetsByBranch(IProject project, String branchName) throws HgException {
        SortedSet<ChangeSet> changes = this.getLocalChangeSets((IResource)project);
        TreeSet<ChangeSet> branchChangeSets = new TreeSet<ChangeSet>();
        for (ChangeSet changeSet : changes) {
            String branch = changeSet.getBranch();
            if (!branch.equals(branchName) && (!branchName.equals("default") || !branch.equals(""))) continue;
            branchChangeSets.add(changeSet);
        }
        return branchChangeSets;
    }
}

