/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.team.cache;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.team.cache.AbstractCache;
import com.vectrace.MercurialEclipse.team.cache.MercurialStatusCache;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.team.core.RepositoryProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutgoingChangesetCache
extends AbstractCache {
    private static OutgoingChangesetCache instance;
    private final Map<HgRepositoryLocation, Map<IPath, SortedSet<ChangeSet>>> outgoingChangeSets = new HashMap<HgRepositoryLocation, Map<IPath, SortedSet<ChangeSet>>>();

    private OutgoingChangesetCache() {
    }

    public static synchronized OutgoingChangesetCache getInstance() {
        if (instance == null) {
            instance = new OutgoingChangesetCache();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(HgRepositoryLocation repo) {
        Map<HgRepositoryLocation, Map<IPath, SortedSet<ChangeSet>>> map = this.outgoingChangeSets;
        synchronized (map) {
            this.outgoingChangeSets.remove(repo);
        }
        Set<IProject> projects = MercurialEclipsePlugin.getRepoManager().getAllRepoLocationProjects(repo);
        for (IProject project : projects) {
            this.clearChangesets(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(HgRepositoryLocation repo, IProject project, boolean notify) {
        Map<HgRepositoryLocation, Map<IPath, SortedSet<ChangeSet>>> map = this.outgoingChangeSets;
        synchronized (map) {
            Map<IPath, SortedSet<ChangeSet>> map2 = this.outgoingChangeSets.get(repo);
            if (map2 != null) {
                map2.remove(project.getLocation());
                this.clearChangesets(project);
            }
        }
        if (notify) {
            this.notifyChanged((IResource)project, false);
        }
    }

    @Override
    protected void clearProjectCache(IProject project) {
        super.clearProjectCache(project);
        Set<HgRepositoryLocation> repos = MercurialEclipsePlugin.getRepoManager().getAllProjectRepoLocations(project);
        for (HgRepositoryLocation repo : repos) {
            this.clear(repo, project, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeSet getNewestOutgoingChangeSet(IResource resource, HgRepositoryLocation repositoryLocation) throws HgException {
        if (MercurialStatusCache.getInstance().isSupervised(resource) || !resource.exists()) {
            Map<HgRepositoryLocation, Map<IPath, SortedSet<ChangeSet>>> map = this.outgoingChangeSets;
            synchronized (map) {
                SortedSet<ChangeSet> revisions;
                Map<IPath, SortedSet<ChangeSet>> repoMap = this.getOutgoingMap(resource, repositoryLocation);
                if (repoMap != null && (revisions = repoMap.get(resource.getLocation())) != null && revisions.size() > 0) {
                    return revisions.last();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<ChangeSet> getOutgoingChangeSets(IResource resource, HgRepositoryLocation repository) throws HgException {
        Map<HgRepositoryLocation, Map<IPath, SortedSet<ChangeSet>>> map = this.outgoingChangeSets;
        synchronized (map) {
            SortedSet<ChangeSet> revisions;
            Map<IPath, SortedSet<ChangeSet>> repoOutgoing = this.outgoingChangeSets.get(repository);
            if (repoOutgoing == null || resource instanceof IProject && repoOutgoing.get(resource.getLocation()) == null) {
                this.refreshOutgoingChangeSets(resource.getProject(), repository);
                repoOutgoing = this.outgoingChangeSets.get(repository);
            }
            if (repoOutgoing != null && (revisions = repoOutgoing.get(resource.getLocation())) != null) {
                return Collections.unmodifiableSortedSet(revisions);
            }
        }
        return new TreeSet<ChangeSet>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<IResource> getOutgoingMembers(IResource resource, HgRepositoryLocation repositoryLocation) throws HgException {
        Map<HgRepositoryLocation, Map<IPath, SortedSet<ChangeSet>>> map = this.outgoingChangeSets;
        synchronized (map) {
            Map<IPath, SortedSet<ChangeSet>> changeSets = this.getOutgoingMap(resource, repositoryLocation);
            return this.getMembers(resource, changeSets);
        }
    }

    private Map<IPath, SortedSet<ChangeSet>> getOutgoingMap(IResource resource, HgRepositoryLocation repositoryLocation) throws HgException {
        this.getOutgoingChangeSets(resource, repositoryLocation);
        Map<IPath, SortedSet<ChangeSet>> changeSets = this.outgoingChangeSets.get(repositoryLocation);
        return changeSets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshOutgoingChangeSets(IProject project, HgRepositoryLocation repositoryLocation) throws HgException {
        Assert.isNotNull((Object)project);
        if (RepositoryProvider.getProvider((IProject)project, (String)"com.vectrace.MercurialEclipse.team.MercurialTeamProvider") != null && project.isOpen()) {
            Map<HgRepositoryLocation, Map<IPath, SortedSet<ChangeSet>>> map = this.outgoingChangeSets;
            synchronized (map) {
                this.addResourcesToCache(project, repositoryLocation, this.outgoingChangeSets, ChangeSet.Direction.OUTGOING);
            }
            this.notifyChanged((IResource)project, true);
        }
    }
}

