/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.team.cache;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.SafeWorkspaceJob;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.team.cache.LocalChangesetCache;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public class RefreshLocalChangesetsJob
extends SafeWorkspaceJob {
    private final IProject project;

    public RefreshLocalChangesetsJob(String name, IProject project) {
        super(name);
        this.project = project;
    }

    public RefreshLocalChangesetsJob(IResource resource) {
        super("Refreshing local changesets.");
        this.project = resource.getProject();
    }

    protected IStatus runSafe(IProgressMonitor monitor) {
        try {
            LocalChangesetCache.getInstance().refreshAllLocalRevisions((IResource)this.project, true);
            return super.runSafe(monitor);
        }
        catch (HgException e) {
            MercurialEclipsePlugin.logError((Throwable)((Object)e));
            return e.getStatus();
        }
    }
}

