/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.utils;

import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.HgRoot;
import com.vectrace.MercurialEclipse.team.MercurialTeamProvider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.ResourceUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtils {
    public static IResource getActiveResourceFromEditor() {
        IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editorPart != null) {
            IFileEditorInput input = (IFileEditorInput)editorPart.getEditorInput();
            IFile file = ResourceUtil.getFile((IEditorInput)input);
            return file;
        }
        return null;
    }

    public static File getFileHandle(IResource resource) {
        IPath path = ResourceUtils.getPath(resource);
        return path.toFile();
    }

    public static IPath getPath(IResource resource) {
        IPath path = resource.getLocation();
        if (path == null) {
            path = resource.getProject().getLocation().append(resource.getFullPath().removeFirstSegments(1));
        }
        return path;
    }

    public static IResource convert(File file) throws HgException {
        String canonicalPath;
        try {
            canonicalPath = file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new HgException(e.getLocalizedMessage(), e);
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Object resource = file.isDirectory() ? root.getContainerForLocation((IPath)new Path(canonicalPath)) : root.getFileForLocation((IPath)new Path(canonicalPath));
        return resource;
    }

    public static File getFirstExistingDirectory(File path) {
        while (path != null && !path.isDirectory()) {
            path = path.getParentFile();
        }
        return path;
    }

    /*
     * Unable to fully structure code
     */
    public static IContainer getFirstExistingDirectory(IResource res) {
        if (res == null) {
            return null;
        }
        v0 = parent = res instanceof IContainer != false ? (IContainer)res : res.getParent();
        if (!(parent instanceof IWorkspaceRoot)) ** GOTO lbl8
        return null;
lbl-1000:
        // 1 sources

        {
            if (!((parent = parent.getParent()) instanceof IWorkspaceRoot)) continue;
            return null;
lbl8:
            // 2 sources

            ** while (parent != null && !parent.exists())
        }
lbl9:
        // 1 sources

        return parent;
    }

    public static Map<IProject, List<IResource>> groupByProject(List<IResource> resources) {
        HashMap<IProject, List<IResource>> result = new HashMap<IProject, List<IResource>>();
        for (IResource resource : resources) {
            IProject root = resource.getProject();
            ArrayList<IResource> list = (ArrayList<IResource>)result.get(root);
            if (list == null) {
                list = new ArrayList<IResource>();
                result.put(root, list);
            }
            list.add(resource);
        }
        return result;
    }

    public static Map<HgRoot, List<IResource>> groupByRoot(List<IResource> resources) throws HgException {
        HashMap<HgRoot, List<IResource>> result = new HashMap<HgRoot, List<IResource>>();
        for (IResource resource : resources) {
            HgRoot root = MercurialTeamProvider.getHgRoot(resource);
            ArrayList<IResource> list = (ArrayList<IResource>)result.get(root);
            if (list == null) {
                list = new ArrayList<IResource>();
                result.put(root, list);
            }
            list.add(resource);
        }
        return result;
    }
}

