/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.views;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.HgParentClient;
import com.vectrace.MercurialEclipse.commands.HgResolveClient;
import com.vectrace.MercurialEclipse.commands.extensions.HgIMergeClient;
import com.vectrace.MercurialEclipse.compare.HgCompareEditorInput;
import com.vectrace.MercurialEclipse.compare.RevisionNode;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.menu.CommitMergeHandler;
import com.vectrace.MercurialEclipse.menu.UpdateHandler;
import com.vectrace.MercurialEclipse.model.FlaggedAdaptable;
import com.vectrace.MercurialEclipse.team.MercurialRevisionStorage;
import com.vectrace.MercurialEclipse.team.ResourceProperties;
import com.vectrace.MercurialEclipse.team.cache.MercurialStatusCache;
import com.vectrace.MercurialEclipse.utils.CompareUtils;
import com.vectrace.MercurialEclipse.views.Messages;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class MergeView
extends ViewPart
implements ISelectionListener,
Observer {
    public static final String ID = MergeView.class.getName();
    private Label statusLabel;
    private Table table;
    private Action abortAction;
    private IProject currentProject;
    private Action markResolvedAction;
    private Action markUnresolvedAction;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.statusLabel = new Label(parent, 0);
        this.statusLabel.setLayoutData((Object)new GridData(768));
        this.table = new Table(parent, 68356);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        this.table.setLayoutData((Object)data);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                try {
                    TableItem item = (TableItem)event.item;
                    FlaggedAdaptable flagged = (FlaggedAdaptable)item.getData();
                    IFile file = (IFile)flagged.getAdapter(IFile.class);
                    String mergeNodeId = MergeView.this.currentProject.getPersistentProperty(ResourceProperties.MERGING);
                    String[] parents = HgParentClient.getParentNodeIds((IResource)MergeView.this.currentProject);
                    int ancestor = HgParentClient.findCommonAncestor(MergeView.this.currentProject.getLocation().toFile(), parents[0], parents[1]);
                    RevisionNode mergeNode = new RevisionNode(new MercurialRevisionStorage((IResource)file, mergeNodeId));
                    RevisionNode ancestorNode = new RevisionNode(new MercurialRevisionStorage((IResource)file, ancestor));
                    HgCompareEditorInput compareInput = new HgCompareEditorInput(new CompareConfiguration(), (IResource)file, ancestorNode, mergeNode, true);
                    int returnValue = CompareUtils.openCompareDialog(compareInput);
                    if (returnValue == 0 && MergeView.this.markResolvedAction.isEnabled()) {
                        MergeView.this.markResolvedAction.run();
                    }
                }
                catch (Exception e) {
                    MercurialEclipsePlugin.logError(e);
                    MercurialEclipsePlugin.showError(e);
                }
            }
        });
        String[] titles = new String[]{Messages.getString("MergeView.column.status"), Messages.getString("MergeView.column.file")};
        int[] widths = new int[]{100, 400};
        int i = 0;
        while (i < titles.length) {
            TableColumn column = new TableColumn(this.table, 0);
            column.setText(titles[i]);
            column.setWidth(widths[i]);
            ++i;
        }
        this.createToolBar();
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        MercurialStatusCache.getInstance().addObserver(this);
    }

    private void createToolBar() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        this.abortAction = new Action(Messages.getString("MergeView.abort")){

            public void run() {
                try {
                    UpdateHandler update = new UpdateHandler();
                    update.setCleanEnabled(true);
                    update.setRevision(".");
                    update.setShell(MergeView.this.table.getShell());
                    update.run((IResource)MergeView.this.currentProject);
                }
                catch (Exception e) {
                    MercurialEclipsePlugin.logError(e);
                    MergeView.this.statusLabel.setText(e.getLocalizedMessage());
                }
            }
        };
        this.abortAction.setEnabled(false);
        mgr.add((IAction)this.abortAction);
        this.markResolvedAction = new Action(Messages.getString("MergeView.markResolved")){

            public void run() {
                try {
                    IFile file = MergeView.this.getSelection();
                    if (file != null) {
                        if (HgResolveClient.checkAvailable()) {
                            HgResolveClient.markResolved(file);
                        } else {
                            HgIMergeClient.markResolved((IResource)file);
                        }
                        MergeView.this.populateView(true);
                    }
                }
                catch (Exception e) {
                    MercurialEclipsePlugin.logError(e);
                    MergeView.this.statusLabel.setText(e.getLocalizedMessage());
                }
            }
        };
        this.markResolvedAction.setEnabled(false);
        mgr.add((IAction)this.markResolvedAction);
        this.markUnresolvedAction = new Action(Messages.getString("MergeView.markUnresolved")){

            public void run() {
                try {
                    IFile file = MergeView.this.getSelection();
                    if (file != null) {
                        if (HgResolveClient.checkAvailable()) {
                            HgResolveClient.markUnresolved(file);
                        } else {
                            HgIMergeClient.markUnresolved((IResource)file);
                        }
                        MergeView.this.populateView(true);
                    }
                }
                catch (Exception e) {
                    MercurialEclipsePlugin.logError(e);
                    MergeView.this.statusLabel.setText(e.getLocalizedMessage());
                }
            }
        };
        this.markUnresolvedAction.setEnabled(false);
        mgr.add((IAction)this.markUnresolvedAction);
    }

    private void populateView(boolean attemptToCommit) throws HgException {
        this.statusLabel.setText(this.currentProject.getName());
        List<FlaggedAdaptable> status = null;
        status = HgResolveClient.checkAvailable() ? HgResolveClient.list((IResource)this.currentProject) : HgIMergeClient.getMergeStatus((IResource)this.currentProject);
        this.table.removeAll();
        for (FlaggedAdaptable flagged : status) {
            TableItem row = new TableItem(this.table, 0);
            row.setText(0, flagged.getStatus());
            IFile iFile = (IFile)flagged.getAdapter(IFile.class);
            row.setText(1, iFile.getProjectRelativePath().toString());
            row.setData((Object)flagged);
            if (flagged.getFlag() != 'U') continue;
            row.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        }
        this.abortAction.setEnabled(true);
        this.markResolvedAction.setEnabled(true);
        this.markUnresolvedAction.setEnabled(true);
        if (attemptToCommit) {
            this.attemptToCommitMerge();
        }
    }

    private void attemptToCommitMerge() {
        try {
            String mergeNode = this.currentProject.getPersistentProperty(ResourceProperties.MERGING);
            boolean allResolved = this.areAllResolved();
            if (allResolved) {
                this.statusLabel.setText(String.valueOf(this.currentProject.getName()) + Messages.getString("MergeView.PleaseCommitMerge") + mergeNode);
                if (this.currentProject.getSessionProperty(ResourceProperties.MERGE_COMMIT_OFFERED) == null) {
                    new CommitMergeHandler().commitMergeWithCommitDialog(this.currentProject, this.getSite().getShell());
                    this.currentProject.setSessionProperty(ResourceProperties.MERGE_COMMIT_OFFERED, (Object)"true");
                }
            }
        }
        catch (Exception e) {
            MercurialEclipsePlugin.logError(e);
        }
    }

    public void clearView() {
        this.statusLabel.setText("");
        this.table.removeAll();
        this.currentProject = null;
        this.abortAction.setEnabled(false);
        this.markResolvedAction.setEnabled(false);
        this.markUnresolvedAction.setEnabled(false);
    }

    public void setCurrentProject(IProject project) {
        if (this.currentProject != project && project != null && project.isAccessible()) {
            try {
                if (project.getPersistentProperty(ResourceProperties.MERGING) != null) {
                    this.currentProject = project;
                    this.populateView(false);
                } else {
                    this.clearView();
                }
            }
            catch (Exception e) {
                MercurialEclipsePlugin.logError(e);
            }
        }
    }

    private boolean areAllResolved() {
        boolean allResolved = true;
        if (this.table.getItems() != null && this.table.getItems().length > 0) {
            TableItem[] tableItemArray = this.table.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                FlaggedAdaptable fa = (FlaggedAdaptable)item.getData();
                allResolved &= fa.getFlag() == 'R';
                ++n2;
            }
        }
        return allResolved;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IEditorInput input;
        IFile file;
        IResource resource;
        IStructuredSelection structured;
        if (selection instanceof IStructuredSelection && (structured = (IStructuredSelection)selection).getFirstElement() instanceof IAdaptable && (resource = (IResource)((IAdaptable)structured.getFirstElement()).getAdapter(IResource.class)) != null) {
            this.setCurrentProject(resource.getProject());
            return;
        }
        if (part instanceof IEditorPart && (file = (IFile)(input = ((IEditorPart)part).getEditorInput()).getAdapter(IFile.class)) != null) {
            this.setCurrentProject(file.getProject());
            return;
        }
    }

    public void setFocus() {
        this.table.setFocus();
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        MercurialStatusCache.getInstance().deleteObserver(this);
        super.dispose();
    }

    private IFile getSelection() {
        TableItem[] selection = this.table.getSelection();
        if (selection != null && selection.length > 0) {
            FlaggedAdaptable fa = (FlaggedAdaptable)this.table.getSelection()[0].getData();
            IFile iFile = (IFile)fa.getAdapter(IFile.class);
            return iFile;
        }
        return null;
    }

    public void update(Observable o, Object arg) {
        if (this.currentProject == null || !(arg instanceof Set)) {
            return;
        }
        Set set = (Set)arg;
        if (set.contains(this.currentProject)) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IProject backup = MergeView.this.currentProject;
                    MergeView.this.clearView();
                    MergeView.this.setCurrentProject(backup);
                }
            });
        }
    }
}

