/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.views.console;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.team.MercurialUtilities;
import com.vectrace.MercurialEclipse.views.console.HgConsole;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.IConsoleManager;

public class HgConsoleHolder
implements IConsoleListener,
IPropertyChangeListener {
    private static final HgConsoleHolder instance = new HgConsoleHolder();
    private volatile HgConsole console;
    private boolean showOnMessage;
    private boolean registered;

    private HgConsoleHolder() {
    }

    public static HgConsoleHolder getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (this.isInitialized()) {
            return;
        }
        HgConsoleHolder hgConsoleHolder = this;
        synchronized (hgConsoleHolder) {
            if (this.isInitialized()) {
                return;
            }
            this.console = new HgConsole();
            Font f = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry().get("hg.console.font");
            this.console.setFont(f);
            this.showOnMessage = Boolean.parseBoolean(MercurialUtilities.getPreference("hg.console.showOnMessage", "false"));
            JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
            MercurialEclipsePlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    private boolean isInitialized() {
        return this.console != null;
    }

    public HgConsole showConsole(boolean force) {
        this.init();
        if (force || this.showOnMessage) {
            this.registerConsole();
            this.getConsoleManager().showConsoleView((IConsole)this.console);
        }
        return this.console;
    }

    public void registerConsole() {
        boolean exists = this.isConsoleRegistered();
        if (!exists) {
            this.getConsoleManager().addConsoles(new IConsole[]{this.console});
        }
    }

    public boolean isConsoleRegistered() {
        if (this.registered) {
            return true;
        }
        IConsole[] existing = this.getConsoleManager().getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (this.console == existing[i]) {
                this.registered = true;
            }
            ++i;
        }
        return this.registered;
    }

    public void closeConsole() {
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        if (this.console != null) {
            manager.removeConsoles(new IConsole[]{this.console});
        }
    }

    public HgConsole getConsole() {
        this.init();
        return this.console;
    }

    public void consolesAdded(IConsole[] consoles) {
        int i = 0;
        while (i < consoles.length) {
            IConsole c = consoles[i];
            if (this.console == c) {
                this.console.init();
                this.showConsole(true);
                break;
            }
            ++i;
        }
    }

    public void consolesRemoved(IConsole[] consoles) {
        int i = 0;
        while (i < consoles.length) {
            IConsole c = consoles[i];
            if (c == this.console) {
                this.console.dispose();
                this.console = null;
                JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
                MercurialEclipsePlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
                break;
            }
            ++i;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("hg.console.showOnMessage".equals(event.getProperty())) {
            this.showOnMessage = Boolean.parseBoolean(MercurialUtilities.getPreference("hg.console.showOnMessage", "false"));
        } else {
            this.console.propertyChange(event);
        }
    }

    private IConsoleManager getConsoleManager() {
        return ConsolePlugin.getDefault().getConsoleManager();
    }
}

