/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.wizards;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.actions.HgOperation;
import com.vectrace.MercurialEclipse.commands.HgBranchClient;
import com.vectrace.MercurialEclipse.commands.HgClients;
import com.vectrace.MercurialEclipse.team.MercurialUtilities;
import com.vectrace.MercurialEclipse.team.ResourceProperties;
import com.vectrace.MercurialEclipse.wizards.AddBranchPage;
import com.vectrace.MercurialEclipse.wizards.HgWizard;
import com.vectrace.MercurialEclipse.wizards.Messages;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;

public class AddBranchWizard
extends HgWizard {
    private final AddBranchPage branchPage;
    private final IResource resource;

    public AddBranchWizard(IResource resource) {
        super(Messages.getString("AddBranchWizard.windowTitle"));
        this.resource = resource;
        this.setNeedsProgressMonitor(true);
        this.branchPage = new AddBranchPage(Messages.getString("AddBranchWizard.branchPage.name"), Messages.getString("AddBranchWizard.branchPage.title"), MercurialEclipsePlugin.getImageDescriptor("wizards/newstream_wizban.gif"), Messages.getString("AddBranchWizard.branchPage.description"));
        this.addPage((IWizardPage)this.branchPage);
    }

    public boolean performFinish() {
        AddBranchOperation op = new AddBranchOperation((IRunnableContext)this.getContainer());
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)op);
        }
        catch (Exception e) {
            this.branchPage.setErrorMessage(e.getLocalizedMessage());
            return false;
        }
        return super.performFinish();
    }

    private class AddBranchOperation
    extends HgOperation {
        public AddBranchOperation(IRunnableContext context) {
            super(context);
        }

        protected String getActionDescription() {
            return Messages.getString("AddBranchWizard.AddBranchOperation.actionDescription");
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                monitor.beginTask(Messages.getString("AddBranchWizard.AddBranchOperation.taskName"), 1);
                HgBranchClient.addBranch(AddBranchWizard.this.resource, AddBranchWizard.this.branchPage.getBranchNameTextField().getText(), MercurialUtilities.getHGUsername(), AddBranchWizard.this.branchPage.getForceCheckBox().getSelection());
                monitor.worked(1);
                HgClients.getConsole().printMessage(this.result, null);
                if (AddBranchWizard.this.resource instanceof IProject) {
                    IProject project = (IProject)AddBranchWizard.this.resource;
                    String branch = HgBranchClient.getActiveBranch(project.getLocation().toFile());
                    project.setSessionProperty(ResourceProperties.HG_BRANCH, (Object)branch);
                }
                AddBranchWizard.this.resource.touch(monitor);
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e, e.getLocalizedMessage());
            }
            monitor.done();
        }
    }
}

