/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.wizards;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocationManager;
import com.vectrace.MercurialEclipse.synchronize.HgSubscriberMergeContext;
import com.vectrace.MercurialEclipse.synchronize.HgSubscriberScopeManager;
import com.vectrace.MercurialEclipse.synchronize.MercurialSynchronizeParticipant;
import com.vectrace.MercurialEclipse.synchronize.RepositorySynchronizationScope;
import com.vectrace.MercurialEclipse.synchronize.SingleRepoSubscriber;
import com.vectrace.MercurialEclipse.team.cache.MercurialStatusCache;
import com.vectrace.MercurialEclipse.wizards.CloneRepoWizard;
import com.vectrace.MercurialEclipse.wizards.ConfigurationWizardMainPage;
import com.vectrace.MercurialEclipse.wizards.HgWizardPage;
import com.vectrace.MercurialEclipse.wizards.Messages;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.MergeContext;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantReference;
import org.eclipse.team.ui.synchronize.ModelParticipantWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;

public class MercurialParticipantSynchronizeWizard
extends ModelParticipantWizard
implements IWorkbenchWizard {
    private static final String SECTION_NAME = "MercurialParticipantSynchronizeWizard";
    private static final String PROP_PASSWORD = "password";
    private static final String PROP_USER = "user";
    private static final String PROP_URL = "url";
    private final IWizard importWizard = new CloneRepoWizard();
    private HgWizardPage page;
    private Properties pageProperties;
    private IResource[] projects;

    public MercurialParticipantSynchronizeWizard() {
        IDialogSettings workbenchSettings = MercurialEclipsePlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection(SECTION_NAME);
        if (section == null) {
            section = workbenchSettings.addNewSection(SECTION_NAME);
        }
        this.setDialogSettings(section);
    }

    protected IWizard getImportWizard() {
        return this.importWizard;
    }

    protected String getPageTitle() {
        return Messages.getString("MercurialParticipantSynchronizeWizard.pageTitle");
    }

    protected IResource[] getRootResources() {
        return this.projects != null ? this.projects : MercurialStatusCache.getInstance().getAllManagedProjects();
    }

    public void addPages() {
        IResource[] rootResources = this.getRootResources();
        if (rootResources.length == 0) {
            return;
        }
        this.pageProperties = MercurialParticipantSynchronizeWizard.initProperties(rootResources);
        super.addPages();
        this.page = this.createrepositoryConfigPage();
        this.addPage((IWizardPage)this.page);
    }

    private ConfigurationWizardMainPage createrepositoryConfigPage() {
        ConfigurationWizardMainPage mainPage = new ConfigurationWizardMainPage(Messages.getString("MercurialParticipantSynchronizeWizard.repositoryPage.name"), Messages.getString("MercurialParticipantSynchronizeWizard.repositoryPage.title"), MercurialEclipsePlugin.getImageDescriptor(Messages.getString("MercurialParticipantSynchronizeWizard.repositoryPage.image")));
        mainPage.setShowBundleButton(false);
        mainPage.setShowCredentials(true);
        mainPage.setDescription(Messages.getString("MercurialParticipantSynchronizeWizard.repositoryPage.description"));
        mainPage.setDialogSettings(this.getDialogSettings());
        mainPage.setProperties(this.pageProperties);
        return mainPage;
    }

    public boolean isComplete() {
        IResource[] resources = this.getRootResources();
        if (this.projects == resources && this.projects.length == 1) {
            this.pageProperties = MercurialParticipantSynchronizeWizard.initProperties(resources);
            if (this.isValid(PROP_URL)) {
                if (this.isValid(PROP_USER)) {
                    if (this.isValid(PROP_PASSWORD)) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isValid(String key) {
        String value = this.pageProperties.getProperty(key);
        return value != null && value.trim().length() > 0;
    }

    public static Properties initProperties(IResource[] rootResources) {
        HgRepositoryLocationManager repoManager;
        HgRepositoryLocation repoLocation;
        Properties properties = new Properties();
        if (rootResources.length == 1 && (repoLocation = (repoManager = MercurialEclipsePlugin.getRepoManager()).getDefaultProjectRepoLocation((IProject)rootResources[0])) != null && repoLocation.getLocation() != null) {
            properties.setProperty(PROP_URL, repoLocation.getLocation());
            if (repoLocation.getUser() != null) {
                properties.setProperty(PROP_USER, repoLocation.getUser());
                if (repoLocation.getPassword() != null) {
                    properties.setProperty(PROP_PASSWORD, repoLocation.getPassword());
                }
            }
        }
        return properties;
    }

    public boolean performFinish() {
        if (this.page == null) {
            this.createParticipant2();
            return true;
        }
        this.page.finish((IProgressMonitor)new NullProgressMonitor());
        this.pageProperties = this.page.getProperties();
        return super.performFinish();
    }

    protected final void createParticipant2() {
        ISynchronizeParticipant participant = this.createParticipant(Utils.getResourceMappings((Object[])this.projects));
        TeamUI.getSynchronizeManager().addSynchronizeParticipants(new ISynchronizeParticipant[]{participant});
        participant.run(null);
    }

    protected ISynchronizeParticipant createParticipant(ResourceMapping[] selectedMappings) {
        IProject iProject;
        HgRepositoryLocation repo;
        String url = this.pageProperties.getProperty(PROP_URL);
        String user = this.pageProperties.getProperty(PROP_USER);
        String pass = this.pageProperties.getProperty(PROP_PASSWORD);
        HgRepositoryLocationManager repoManager = MercurialEclipsePlugin.getRepoManager();
        try {
            repo = repoManager.getRepoLocation(url, user, pass);
            if (pass != null && user != null && !pass.equals(repo.getPassword())) {
                repo = repoManager.updateRepoLocation(url, null, user, pass);
            }
        }
        catch (URISyntaxException e) {
            MercurialEclipsePlugin.logError(e);
            this.page.setErrorMessage(e.getLocalizedMessage());
            return null;
        }
        HashSet<IProject> selectedProjects = new HashSet<IProject>();
        ResourceMapping[] resourceMappingArray = selectedMappings;
        int n = selectedMappings.length;
        int n2 = 0;
        while (n2 < n) {
            IProject[] projects2;
            ResourceMapping mapping = resourceMappingArray[n2];
            IProject[] iProjectArray = projects2 = mapping.getProjects();
            int n3 = projects2.length;
            int n4 = 0;
            while (n4 < n3) {
                iProject = iProjectArray[n4];
                selectedProjects.add(iProject);
                ++n4;
            }
            ++n2;
        }
        if (selectedProjects.isEmpty()) {
            return null;
        }
        IProject array = this.getRootResources();
        if (((IResource[])array).length > selectedProjects.size()) {
            array = selectedProjects.toArray(new IResource[0]);
        }
        Set<IProject> repoProjects = repoManager.getAllRepoLocationProjects(repo);
        iProject = array;
        int projects2 = ((IResource[])iProject).length;
        int n5 = 0;
        while (n5 < projects2) {
            IProject resource = iProject[n5];
            IProject project = resource.getProject();
            if (!repoProjects.contains(project)) {
                try {
                    repoManager.addRepoLocation(project, repo);
                    HgRepositoryLocation repoLocation = repoManager.getDefaultProjectRepoLocation(project);
                    if (repoLocation == null) {
                        repoManager.setDefaultProjectRepository(project, repo);
                    }
                }
                catch (CoreException e) {
                    MercurialEclipsePlugin.logError(e);
                }
            }
            ++n5;
        }
        ISynchronizeParticipantReference participant = TeamUI.getSynchronizeManager().get(MercurialSynchronizeParticipant.class.getName(), repo.getLocation());
        if (participant != null) {
            try {
                return participant.getParticipant();
            }
            catch (TeamException e) {
                MercurialEclipsePlugin.logError(e);
            }
        }
        RepositorySynchronizationScope scope = new RepositorySynchronizationScope(repo, (IResource[])array);
        SingleRepoSubscriber subscriber = new SingleRepoSubscriber(scope, repo);
        HgSubscriberScopeManager manager = new HgSubscriberScopeManager(selectedMappings, subscriber);
        HgSubscriberMergeContext ctx = new HgSubscriberMergeContext(subscriber, (ISynchronizationScopeManager)manager);
        return new MercurialSynchronizeParticipant((MergeContext)ctx, repo);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (selection != null && !selection.isEmpty()) {
            Object[] array = selection.toArray();
            HashSet<IProject> roots = new HashSet<IProject>();
            IProject[] managed = MercurialStatusCache.getInstance().getAllManagedProjects();
            Object[] objectArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof IResource) {
                    IResource resource = (IResource)object;
                    IProject[] iProjectArray = managed;
                    int n3 = managed.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IProject project = iProjectArray[n4];
                        if (project.contains((ISchedulingRule)resource)) {
                            roots.add(project);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            this.projects = roots.toArray(new IResource[roots.size()]);
        }
    }
}

