/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.wizards;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.team.MercurialUtilities;
import com.vectrace.MercurialEclipse.team.ResourceProperties;
import com.vectrace.MercurialEclipse.ui.ChangesetTable;
import com.vectrace.MercurialEclipse.ui.SWTWidgetHelper;
import com.vectrace.MercurialEclipse.wizards.ConfigurationWizardMainPage;
import com.vectrace.MercurialEclipse.wizards.Messages;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushPullPage
extends ConfigurationWizardMainPage {
    protected IResource resource;
    protected Button forceCheckBox;
    protected boolean force;
    protected ChangesetTable changesetTable;
    protected String revision;
    protected Button revCheckBox;
    protected Button timeoutCheckBox;
    protected boolean timeout;
    protected Group optionGroup;
    protected boolean showRevisionTable = true;
    protected boolean showForce = true;
    protected Button forestCheckBox;
    protected boolean showForest = false;
    protected Combo snapFileCombo;
    protected Button snapFileButton;
    protected boolean showSnapFile = true;
    protected boolean showSvn = false;
    protected Button svnCheckBox;

    public PushPullPage(IResource resource, String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.resource = resource;
        try {
            this.setShowForest(true);
            this.setShowSvn(true);
        }
        catch (HgException e) {
            MercurialEclipsePlugin.logError((Throwable)((Object)e));
            this.setErrorMessage(e.getMessage());
        }
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite composite = (Composite)this.getControl();
        this.optionGroup = SWTWidgetHelper.createGroup(composite, Messages.getString("PushRepoPage.optionGroup.title"));
        this.timeoutCheckBox = SWTWidgetHelper.createCheckBox((Composite)this.optionGroup, this.getTimeoutCheckBoxLabel());
        if (this.showForce) {
            this.forceCheckBox = SWTWidgetHelper.createCheckBox((Composite)this.optionGroup, this.getForceCheckBoxLabel());
        }
        if (this.showRevisionTable) {
            this.createRevisionTable(composite);
        }
        this.createExtensionControls();
        this.setDefaultLocation();
    }

    private void createExtensionControls() {
        if (this.showForest) {
            this.forestCheckBox = SWTWidgetHelper.createCheckBox((Composite)this.optionGroup, Messages.getString("PushPullPage.option.forest"));
            if (this.showSnapFile) {
                Composite c = SWTWidgetHelper.createComposite((Composite)this.optionGroup, 3);
                final Label forestLabel = SWTWidgetHelper.createLabel(c, Messages.getString("PushPullPage.snapfile.label"));
                forestLabel.setEnabled(false);
                this.snapFileCombo = this.createEditableCombo(c);
                this.snapFileCombo.setEnabled(false);
                this.snapFileButton = SWTWidgetHelper.createPushButton(c, Messages.getString("PushPullPage.snapfile.browse"), 1);
                this.snapFileButton.setEnabled(false);
                this.snapFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        FileDialog dialog = new FileDialog(PushPullPage.this.getShell());
                        dialog.setText(Messages.getString("PushPullPage.snapfile.select"));
                        String file = dialog.open();
                        if (file != null) {
                            PushPullPage.this.snapFileCombo.setText(file);
                        }
                    }
                });
                SelectionListener forestCheckBoxListener = new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        forestLabel.setEnabled(PushPullPage.this.forestCheckBox.getSelection());
                        PushPullPage.this.snapFileButton.setEnabled(PushPullPage.this.forestCheckBox.getSelection());
                        PushPullPage.this.snapFileCombo.setEnabled(PushPullPage.this.forestCheckBox.getSelection());
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }
                };
                this.forestCheckBox.addSelectionListener(forestCheckBoxListener);
            }
        }
        if (this.showSvn) {
            this.svnCheckBox = SWTWidgetHelper.createCheckBox((Composite)this.optionGroup, Messages.getString("PushPullPage.option.svn"));
        }
    }

    private void createRevisionTable(Composite composite) {
        this.revCheckBox = SWTWidgetHelper.createCheckBox((Composite)this.optionGroup, this.getRevCheckBoxLabel());
        Listener revCheckBoxListener = new Listener(){

            public void handleEvent(Event event) {
                PushPullPage.this.changesetTable.setEnabled(PushPullPage.this.revCheckBox.getSelection());
            }
        };
        this.revCheckBox.addListener(13, revCheckBoxListener);
        Group revGroup = SWTWidgetHelper.createGroup(composite, this.getRevGroupLabel(), 1808);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 150;
        gridData.minimumHeight = 50;
        this.changesetTable = new ChangesetTable((Composite)revGroup, this.resource);
        this.changesetTable.setLayoutData(gridData);
        this.changesetTable.setEnabled(false);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PushPullPage.this.setPageComplete(true);
                PushPullPage.this.revision = PushPullPage.this.changesetTable.getSelection().toString();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.changesetTable.addSelectionListener(listener);
    }

    protected Set<HgRepositoryLocation> setDefaultLocation() {
        if (this.resource == null) {
            return null;
        }
        HgRepositoryLocation defaultLocation = null;
        Set<HgRepositoryLocation> repos = MercurialEclipsePlugin.getRepoManager().getAllProjectRepoLocations(this.resource.getProject());
        for (HgRepositoryLocation repo : repos) {
            if (!"default-pull".equals(repo.getLogicalName()) && !"default".equals(repo.getLogicalName())) continue;
            defaultLocation = repo;
            break;
        }
        if (defaultLocation == null) {
            defaultLocation = MercurialEclipsePlugin.getRepoManager().getDefaultProjectRepoLocation(this.resource.getProject());
        }
        if (defaultLocation != null) {
            String password;
            this.getUrlCombo().setText(defaultLocation.getLocation());
            String user = defaultLocation.getUser();
            if (user != null && user.length() != 0) {
                this.getUserCombo().setText(user);
            }
            if ((password = defaultLocation.getPassword()) != null && password.length() != 0) {
                this.getPasswordText().setText(password);
            }
        }
        return repos;
    }

    protected String getRevGroupLabel() {
        return Messages.getString("PushRepoPage.revGroup.title");
    }

    protected String getRevCheckBoxLabel() {
        return Messages.getString("PushRepoPage.revCheckBox.text");
    }

    protected String getForceCheckBoxLabel() {
        return Messages.getString("PushRepoPage.forceCheckBox.text");
    }

    protected String getTimeoutCheckBoxLabel() {
        return Messages.getString("PushRepoPage.timeoutCheckBox.text");
    }

    public boolean isForce() {
        return this.force;
    }

    public String getRevision() {
        return this.revision;
    }

    public boolean isTimeout() {
        return this.timeout;
    }

    public IResource getResource() {
        return this.resource;
    }

    public void setResource(IResource resource) {
        this.resource = resource;
    }

    public Button getForceCheckBox() {
        return this.forceCheckBox;
    }

    public ChangesetTable getChangesetTable() {
        return this.changesetTable;
    }

    public Button getRevCheckBox() {
        return this.revCheckBox;
    }

    public Button getTimeoutCheckBox() {
        return this.timeoutCheckBox;
    }

    public boolean isShowRevisionTable() {
        return this.showRevisionTable;
    }

    public void setShowRevisionTable(boolean showRevisionTable) {
        this.showRevisionTable = showRevisionTable;
    }

    public boolean isShowForce() {
        return this.showForce;
    }

    public void setShowForce(boolean showForce) {
        this.showForce = showForce;
    }

    public boolean isShowForest() {
        return this.showForest;
    }

    public void setShowForest(boolean showForest) throws HgException {
        this.showForest = showForest && MercurialUtilities.isCommandAvailable("fpull", ResourceProperties.EXT_FOREST_AVAILABLE, null);
    }

    public Combo getSnapFileCombo() {
        return this.snapFileCombo;
    }

    public void setSnapFileCombo(Combo snapFileCombo) {
        this.snapFileCombo = snapFileCombo;
    }

    public boolean isShowSnapFile() {
        return this.showSnapFile;
    }

    public void setShowSnapFile(boolean showSnapFile) {
        this.showSnapFile = showSnapFile;
    }

    public Button getForestCheckBox() {
        return this.forestCheckBox;
    }

    public void setForestCheckBox(Button forestCheckBox) {
        this.forestCheckBox = forestCheckBox;
    }

    public boolean isShowSvn() {
        return this.showSvn;
    }

    public void setShowSvn(boolean showSvn) throws HgException {
        this.showSvn = showSvn && MercurialUtilities.isCommandAvailable("svn", ResourceProperties.EXT_HGSUBVERSION_AVAILABLE, null);
    }

    public Button getSvnCheckBox() {
        return this.svnCheckBox;
    }

    public void setSvnCheckBox(Button svnCheckBox) {
        this.svnCheckBox = svnCheckBox;
    }
}

