/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.wizards;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.team.MercurialUtilities;
import com.vectrace.MercurialEclipse.team.ResourceProperties;
import com.vectrace.MercurialEclipse.ui.ChangesetTable;
import com.vectrace.MercurialEclipse.ui.SWTWidgetHelper;
import com.vectrace.MercurialEclipse.wizards.HgWizardPage;
import com.vectrace.MercurialEclipse.wizards.Messages;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;

public class RebasePage
extends HgWizardPage {
    private IResource resource;
    private ChangesetTable srcTable;
    private Button sourceRevCheckBox;
    private Button baseRevCheckBox;
    private Button destRevCheckBox;
    private Button collapseRevCheckBox;
    private Button continueRevCheckBox;
    private Button abortRevCheckBox;
    private ChangesetTable destTable;

    public RebasePage(String pageName) {
        super(pageName);
    }

    public RebasePage(String pageName, String title, ImageDescriptor titleImage, String description, IResource res) {
        super(pageName, title, titleImage, description);
        this.resource = res;
    }

    public void createControl(Composite parent) {
        Composite comp = SWTWidgetHelper.createComposite(parent, 2);
        this.createSrcWidgets(comp);
        this.createDestWidgets(comp);
        this.createOptionsWidgets(comp);
        this.setControl((Control)comp);
        try {
            if (!MercurialUtilities.isCommandAvailable("rebase", ResourceProperties.REBASE_AVAILABLE, "hgext.rebase=")) {
                this.setErrorMessage(Messages.getString("RebasePage.error.notAvailable"));
            }
        }
        catch (HgException e) {
            MercurialEclipsePlugin.logError((Throwable)((Object)e));
            this.setErrorMessage(e.getLocalizedMessage());
        }
    }

    private void createOptionsWidgets(Composite comp) {
        Group optionGroup = SWTWidgetHelper.createGroup(comp, Messages.getString("RebasePage.optionGroup.label"), 2, 1808);
        this.collapseRevCheckBox = SWTWidgetHelper.createCheckBox((Composite)optionGroup, Messages.getString("RebasePage.option.collapse"));
        this.abortRevCheckBox = SWTWidgetHelper.createCheckBox((Composite)optionGroup, Messages.getString("RebasePage.option.abort"));
        SelectionListener abortSl = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                boolean selection = RebasePage.this.abortRevCheckBox.getSelection();
                RebasePage.this.sourceRevCheckBox.setEnabled(!selection);
                RebasePage.this.baseRevCheckBox.setEnabled(!selection);
                RebasePage.this.destRevCheckBox.setEnabled(!selection);
                if (selection) {
                    RebasePage.this.sourceRevCheckBox.setSelection(false);
                    RebasePage.this.baseRevCheckBox.setSelection(false);
                    RebasePage.this.destRevCheckBox.setSelection(false);
                    RebasePage.this.collapseRevCheckBox.setSelection(false);
                    RebasePage.this.continueRevCheckBox.setSelection(false);
                    RebasePage.this.srcTable.setEnabled(false);
                    RebasePage.this.destTable.setEnabled(false);
                }
            }
        };
        this.abortRevCheckBox.addSelectionListener(abortSl);
        this.continueRevCheckBox = SWTWidgetHelper.createCheckBox((Composite)optionGroup, Messages.getString("RebasePage.option.continue"));
        SelectionListener contSl = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                boolean selection = RebasePage.this.continueRevCheckBox.getSelection();
                RebasePage.this.sourceRevCheckBox.setEnabled(!selection);
                RebasePage.this.baseRevCheckBox.setEnabled(!selection);
                RebasePage.this.destRevCheckBox.setEnabled(!selection);
                if (selection) {
                    RebasePage.this.sourceRevCheckBox.setSelection(false);
                    RebasePage.this.baseRevCheckBox.setSelection(false);
                    RebasePage.this.destRevCheckBox.setSelection(false);
                    RebasePage.this.collapseRevCheckBox.setSelection(false);
                    RebasePage.this.abortRevCheckBox.setSelection(false);
                    RebasePage.this.srcTable.setEnabled(false);
                    RebasePage.this.destTable.setEnabled(false);
                }
            }
        };
        this.continueRevCheckBox.addSelectionListener(contSl);
    }

    private void createDestWidgets(Composite comp) {
        Group destGroup = SWTWidgetHelper.createGroup(comp, Messages.getString("RebasePage.destinationGroup.label"), 2, 1808);
        this.destRevCheckBox = SWTWidgetHelper.createCheckBox((Composite)destGroup, Messages.getString("RebasePage.destinationCheckbox.label"));
        SelectionListener sl = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                RebasePage.this.destTable.setEnabled(RebasePage.this.destRevCheckBox.getSelection());
            }
        };
        this.destRevCheckBox.addSelectionListener(sl);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 150;
        gridData.minimumHeight = 50;
        this.destTable = new ChangesetTable((Composite)destGroup, this.resource, true);
        this.destTable.setLayoutData(gridData);
        this.destTable.setEnabled(false);
    }

    private void createSrcWidgets(Composite comp) {
        Group srcGroup = SWTWidgetHelper.createGroup(comp, Messages.getString("RebasePage.sourceGroup.label"), 2, 1808);
        this.sourceRevCheckBox = SWTWidgetHelper.createCheckBox((Composite)srcGroup, Messages.getString("RebasePage.source.label"));
        this.baseRevCheckBox = SWTWidgetHelper.createCheckBox((Composite)srcGroup, Messages.getString("RebasePage.base.label"));
        SelectionListener srcSl = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                RebasePage.this.srcTable.setEnabled(RebasePage.this.sourceRevCheckBox.getSelection() || RebasePage.this.baseRevCheckBox.getSelection());
                if (RebasePage.this.sourceRevCheckBox.getSelection()) {
                    RebasePage.this.baseRevCheckBox.setSelection(false);
                }
            }
        };
        SelectionListener baseSl = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                RebasePage.this.srcTable.setEnabled(RebasePage.this.sourceRevCheckBox.getSelection() || RebasePage.this.baseRevCheckBox.getSelection());
                if (RebasePage.this.baseRevCheckBox.getSelection()) {
                    RebasePage.this.sourceRevCheckBox.setSelection(false);
                }
            }
        };
        this.sourceRevCheckBox.addSelectionListener(srcSl);
        this.baseRevCheckBox.addSelectionListener(baseSl);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 150;
        gridData.minimumHeight = 50;
        this.srcTable = new ChangesetTable((Composite)srcGroup, this.resource, true);
        this.srcTable.setLayoutData(gridData);
        this.srcTable.setEnabled(false);
    }

    public ChangesetTable getSrcTable() {
        return this.srcTable;
    }

    public void setSrcTable(ChangesetTable changesetTable) {
        this.srcTable = changesetTable;
    }

    public Button getSourceRevCheckBox() {
        return this.sourceRevCheckBox;
    }

    public void setSourceRevCheckBox(Button sourceRevCheckBox) {
        this.sourceRevCheckBox = sourceRevCheckBox;
    }

    public Button getBaseRevCheckBox() {
        return this.baseRevCheckBox;
    }

    public void setBaseRevCheckBox(Button baseRevCheckBox) {
        this.baseRevCheckBox = baseRevCheckBox;
    }

    public Button getDestRevCheckBox() {
        return this.destRevCheckBox;
    }

    public void setDestRevCheckBox(Button destRevCheckBox) {
        this.destRevCheckBox = destRevCheckBox;
    }

    public Button getCollapseRevCheckBox() {
        return this.collapseRevCheckBox;
    }

    public void setCollapseRevCheckBox(Button collapseRevCheckBox) {
        this.collapseRevCheckBox = collapseRevCheckBox;
    }

    public Button getContinueRevCheckBox() {
        return this.continueRevCheckBox;
    }

    public void setContinueRevCheckBox(Button continueRevCheckBox) {
        this.continueRevCheckBox = continueRevCheckBox;
    }

    public Button getAbortRevCheckBox() {
        return this.abortRevCheckBox;
    }

    public void setAbortRevCheckBox(Button abortRevCheckBox) {
        this.abortRevCheckBox = abortRevCheckBox;
    }

    public ChangesetTable getDestTable() {
        return this.destTable;
    }

    public void setDestTable(ChangesetTable destTable) {
        this.destTable = destTable;
    }
}

