/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.wizards;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.HgClients;
import com.vectrace.MercurialEclipse.operations.RebaseOperation;
import com.vectrace.MercurialEclipse.wizards.HgWizard;
import com.vectrace.MercurialEclipse.wizards.Messages;
import com.vectrace.MercurialEclipse.wizards.RebasePage;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;

public class RebaseWizard
extends HgWizard {
    private IResource resource;
    private RebasePage rebasePage;

    public RebaseWizard(IResource res) {
        super(Messages.getString("RebaseWizard.title"));
        this.resource = res;
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        int srcRev = -1;
        int baseRev = -1;
        int destRev = -1;
        if (this.rebasePage.getSourceRevCheckBox().getSelection()) {
            srcRev = this.rebasePage.getSrcTable().getSelection().getChangesetIndex();
        }
        if (this.rebasePage.getBaseRevCheckBox().getSelection()) {
            baseRev = this.rebasePage.getSrcTable().getSelection().getChangesetIndex();
        }
        if (this.rebasePage.getDestRevCheckBox().getSelection()) {
            destRev = this.rebasePage.getDestTable().getSelection().getChangesetIndex();
        }
        boolean collapse = this.rebasePage.getCollapseRevCheckBox().getSelection();
        boolean abort = this.rebasePage.getAbortRevCheckBox().getSelection();
        boolean cont = this.rebasePage.getContinueRevCheckBox().getSelection();
        RebaseOperation op = new RebaseOperation((IRunnableContext)this.getContainer(), this.resource, srcRev, destRev, baseRev, collapse, abort, cont);
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)op);
            if (op.getResult().length() != 0) {
                HgClients.getConsole().printMessage(op.getResult(), null);
            }
            return true;
        }
        catch (Exception e) {
            MercurialEclipsePlugin.logError(e.getCause());
            this.rebasePage.setErrorMessage(e.getLocalizedMessage());
            return false;
        }
    }

    public void addPages() {
        this.rebasePage = new RebasePage("RebasePage", Messages.getString("RebaseWizard.rebasePage.title"), MercurialEclipsePlugin.getImageDescriptor("wizards/droplets-50.png"), Messages.getString("RebaseWizard.rebasePage.description"), this.resource);
        this.initPage(this.rebasePage.getDescription(), this.rebasePage);
        this.addPage((IWizardPage)this.rebasePage);
    }
}

