/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.wizards;

import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.ui.ChangesetTable;
import com.vectrace.MercurialEclipse.ui.SWTWidgetHelper;
import com.vectrace.MercurialEclipse.wizards.HgWizardPage;
import com.vectrace.MercurialEclipse.wizards.Messages;
import com.vectrace.MercurialEclipse.wizards.TransplantPage;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;

public class TransplantOptionsPage
extends HgWizardPage {
    private IProject project;
    private boolean merge;
    private String mergeNodeId;
    private boolean prune;
    private String pruneNodeId;
    private String filter;
    private boolean filterChangesets;
    private boolean continueLastTransplant;
    private Button continueLastTransplantCheckBox;
    private Button filterChangesetsCheckBox;
    private Text filterTextField;
    private ChangesetTable mergeNodeIdTable;
    private Button mergeCheckBox;
    private Button pruneCheckBox;
    private ChangesetTable pruneNodeIdTable;
    private SortedSet<ChangeSet> changesets = new TreeSet(Collections.reverseOrder());

    public TransplantOptionsPage(String pageName, String title, ImageDescriptor titleImage, IProject project) {
        super(pageName, title, titleImage);
        this.project = project;
    }

    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage();
    }

    public void createControl(Composite parent) {
        Composite composite = SWTWidgetHelper.createComposite(parent, 2);
        this.addContinueOptionGroup(composite);
        this.addOtherOptionsGroup(composite);
        this.setControl((Control)composite);
    }

    private void addOtherOptionsGroup(Composite composite) {
        this.createMergeGroup(composite);
        this.createPruneGroup(composite);
        this.createFilterGroup(composite);
    }

    private void createFilterGroup(Composite composite) {
        Group filterGroup = SWTWidgetHelper.createGroup(composite, Messages.getString("TransplantOptionsPage.filtergroup.title"));
        this.filterChangesetsCheckBox = SWTWidgetHelper.createCheckBox((Composite)filterGroup, Messages.getString("TransplantOptionsPage.filterCheckBox.title"));
        SelectionListener filterChangesetsCheckBoxListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TransplantOptionsPage.this.filterTextField.setEnabled(TransplantOptionsPage.this.filterChangesetsCheckBox.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.filterChangesetsCheckBox.addSelectionListener(filterChangesetsCheckBoxListener);
        SWTWidgetHelper.createLabel((Composite)filterGroup, Messages.getString("TransplantOptionsPage.filterLabel.title"));
        this.filterTextField = SWTWidgetHelper.createTextField((Composite)filterGroup);
        this.filterTextField.setEnabled(false);
        ModifyListener filterListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TransplantOptionsPage.this.filter = TransplantOptionsPage.this.filterTextField.getText();
                TransplantOptionsPage.this.validatePage();
            }
        };
        this.filterTextField.addModifyListener(filterListener);
    }

    private void createPruneGroup(Composite composite) {
        Group pruneGroup = SWTWidgetHelper.createGroup(composite, Messages.getString("TransplantOptionsPage.pruneGroup.title"));
        this.pruneCheckBox = SWTWidgetHelper.createCheckBox((Composite)pruneGroup, Messages.getString("TransplantOptionsPage.pruneCheckBox.title"));
        SelectionListener pruneCheckBoxListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TransplantOptionsPage.this.pruneNodeIdTable.setEnabled(TransplantOptionsPage.this.pruneCheckBox.getSelection());
                TransplantOptionsPage.this.populatePruneNodeIdTable();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.pruneCheckBox.addSelectionListener(pruneCheckBoxListener);
        this.pruneNodeIdTable = new ChangesetTable((Composite)pruneGroup, (IResource)this.project);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 200;
        gridData.minimumHeight = 50;
        this.pruneNodeIdTable.setLayoutData(gridData);
        this.pruneNodeIdTable.setEnabled(false);
        SelectionListener pruneTableListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ChangeSet changeSet = TransplantOptionsPage.this.pruneNodeIdTable.getSelection();
                TransplantOptionsPage.this.pruneNodeId = changeSet.getChangeset();
                TransplantOptionsPage.this.validatePage();
            }
        };
        this.pruneNodeIdTable.addSelectionListener(pruneTableListener);
    }

    private void createMergeGroup(Composite composite) {
        Group mergeGroup = SWTWidgetHelper.createGroup(composite, Messages.getString("TransplantOptionsPage.mergeGroup.title"));
        this.mergeCheckBox = SWTWidgetHelper.createCheckBox((Composite)mergeGroup, Messages.getString("TransplantOptionsPage.mergeCheckBox.title"));
        SelectionListener mergeCheckBoxListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TransplantOptionsPage.this.mergeNodeIdTable.setEnabled(TransplantOptionsPage.this.mergeCheckBox.getSelection());
                TransplantOptionsPage.this.populateMergeNodeIdTable();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.mergeCheckBox.addSelectionListener(mergeCheckBoxListener);
        this.mergeNodeIdTable = new ChangesetTable((Composite)mergeGroup, (IResource)this.project);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 200;
        gridData.minimumHeight = 50;
        this.mergeNodeIdTable.setLayoutData(gridData);
        this.mergeNodeIdTable.setEnabled(false);
        SelectionListener mergeTableListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ChangeSet changeSet = TransplantOptionsPage.this.mergeNodeIdTable.getSelection();
                TransplantOptionsPage.this.mergeNodeId = changeSet.getChangeset();
                TransplantOptionsPage.this.validatePage();
            }
        };
        this.mergeNodeIdTable.addSelectionListener(mergeTableListener);
        this.populateMergeNodeIdTable();
    }

    private void loadChangesets() {
        if (this.changesets.size() == 0) {
            TransplantPage page = (TransplantPage)this.getPreviousPage();
            this.changesets.addAll(page.getChangesets());
        }
    }

    private void validatePage() {
        boolean valid = true;
        if (this.merge) {
            valid &= this.mergeNodeId != null && this.mergeNodeId.length() > 0;
        }
        if (this.prune) {
            valid &= this.pruneNodeId != null && this.pruneNodeId.length() > 0;
        }
        if (this.filterChangesets) {
            valid &= this.filter != null && this.filter.length() > 0;
        }
        if (this.continueLastTransplant) {
            valid = true;
        }
        this.setPageComplete(valid);
    }

    private void addContinueOptionGroup(Composite composite) {
        Group continueGroup = SWTWidgetHelper.createGroup(composite, Messages.getString("TransplantOptionsPage.continueGroup.title"));
        this.continueLastTransplantCheckBox = SWTWidgetHelper.createCheckBox((Composite)continueGroup, Messages.getString("TransplantOptionsPage.continueCheckBox.title"));
        SelectionListener continueLastTransplantCheckBoxListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TransplantOptionsPage.this.filterChangesetsCheckBox.setEnabled(!TransplantOptionsPage.this.continueLastTransplantCheckBox.getSelection());
                TransplantOptionsPage.this.mergeCheckBox.setEnabled(!TransplantOptionsPage.this.continueLastTransplantCheckBox.getSelection());
                TransplantOptionsPage.this.pruneCheckBox.setEnabled(!TransplantOptionsPage.this.continueLastTransplantCheckBox.getSelection());
                TransplantOptionsPage.this.validatePage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.continueLastTransplantCheckBox.addSelectionListener(continueLastTransplantCheckBoxListener);
    }

    private void populatePruneNodeIdTable() {
        this.loadChangesets();
        this.pruneNodeIdTable.setChangesets(this.changesets.toArray(new ChangeSet[this.changesets.size()]));
    }

    private void populateMergeNodeIdTable() {
        this.loadChangesets();
        this.mergeNodeIdTable.setChangesets(this.changesets.toArray(new ChangeSet[this.changesets.size()]));
    }

    public boolean finish(IProgressMonitor monitor) {
        return super.finish(monitor);
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public boolean isMerge() {
        return this.merge;
    }

    public String getMergeNodeId() {
        return this.mergeNodeId;
    }

    public boolean isPrune() {
        return this.prune;
    }

    public String getPruneNodeId() {
        return this.pruneNodeId;
    }

    public boolean isFilterChangesets() {
        return this.filterChangesets;
    }

    public String getFilter() {
        return this.filter;
    }

    public boolean isContinueLastTransplant() {
        return this.continueLastTransplant;
    }
}

