/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.deltaddl;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.enablement.sybase.IGenericDdlConstants;
import org.eclipse.datatools.enablement.sybase.asa.ddl.SybaseASADdlBuilder;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseProcedure;
import org.eclipse.datatools.enablement.sybase.ddl.ISybaseDdlGenerator;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlScript;
import org.eclipse.datatools.enablement.sybase.deltaddl.IDeltaDdlGenProvider;
import org.eclipse.datatools.enablement.sybase.deltaddl.SybaseDeltaDdlGeneration;
import org.eclipse.datatools.enablement.sybase.parser.QuickSQLParser;
import org.eclipse.datatools.enablement.sybase.util.SQLUtil;
import org.eclipse.datatools.modelbase.sql.routines.Procedure;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;

public class SybaseASAProcedureDeltaDdlGenProvider
implements IDeltaDdlGenProvider,
IGenericDdlConstants {
    public void processAlterStatement(SQLObject element, Map modifyRecordMap, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, SybaseDdlScript script, IProgressMonitor monitor) {
        if (!(element instanceof SybaseASABaseProcedure)) {
            return;
        }
        SybaseASABaseProcedure proc = (SybaseASABaseProcedure)element;
        SybaseASADdlBuilder builder = SybaseASADdlBuilder.getInstance();
        List records = (List)modifyRecordMap.get(element);
        if (records != null) {
            String[] create = builder.createProcedure((Procedure)proc, quoteIdentifiers, qualifyNames, fullSyntax);
            String comment = null;
            boolean sourceChanged = false;
            boolean commentChanged = false;
            for (SybaseDeltaDdlGeneration.FeatureChangeRecord r : records) {
                if (r.feature.getFeatureID() == 1 && r.changed == proc) {
                    String oldName = (String)r.oldValue;
                    String schemaName = proc.getSchema().getName();
                    if (quoteIdentifiers) {
                        oldName = SQLUtil.quote((String)oldName, (String)"\"");
                        schemaName = SQLUtil.quote((String)schemaName, (String)"\"");
                    }
                    if (qualifyNames) {
                        oldName = String.valueOf(schemaName) + "." + oldName;
                    }
                    StringBuffer drop = new StringBuffer(128);
                    drop.append("DROP").append(" ").append("PROCEDURE").append(" ").append(oldName);
                    int i = 0;
                    while (i < create.length) {
                        script.addCreateRoutineStatements(create[i]);
                        ++i;
                    }
                    script.addDropRoutineStatement(drop.toString());
                    return;
                }
                if (r.feature.getFeatureID() == 3) {
                    commentChanged = true;
                    comment = builder.createComment((SQLObject)proc, quoteIdentifiers, qualifyNames, true);
                    continue;
                }
                if (r.feature.getFeatureID() != 7 || r.changed != proc.getSource()) continue;
                sourceChanged = true;
            }
            if (commentChanged && !sourceChanged && comment != null) {
                script.addCreateRoutineStatements(comment);
                return;
            }
            if (!sourceChanged) {
                return;
            }
            QuickSQLParser parser = QuickSQLParser.getInstance();
            int[] createIndex = parser.find(create[0], new String[]{"CREATE"});
            if (createIndex[0] >= 0) {
                String alter = String.valueOf(create[0].substring(0, createIndex[0])) + "ALTER" + create[0].substring(createIndex[0] + 6);
                script.addCreateRoutineStatements(alter);
                if (comment != null) {
                    script.addCreateRoutineStatements(comment);
                }
            } else {
                int i = 0;
                while (i < create.length) {
                    script.addCreateRoutineStatements(create[i]);
                    ++i;
                }
            }
        }
    }

    public void processCreateStatement(SQLObject element, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, SybaseDdlScript script, ISybaseDdlGenerator generator, IProgressMonitor monitor) {
    }

    public void processDropStatement(SQLObject element, boolean quoteIdentifiers, boolean qualifyNames, SybaseDdlScript script, ISybaseDdlGenerator generator, IProgressMonitor monitor) {
    }

    public void analyze(SQLObject element, Map changeMap, Map modificationRecords) {
    }
}

