/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.manifest;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.nls.Messages;
import org.eclipse.datatools.connectivity.oda.spec.ExpressionVariable;
import org.eclipse.datatools.connectivity.oda.spec.IValidator;
import org.eclipse.datatools.connectivity.oda.spec.manifest.ExtensionContributor;
import org.eclipse.datatools.connectivity.oda.spec.manifest.ResultExtensionUtil;
import org.eclipse.datatools.connectivity.oda.spec.manifest.VariableRestrictions;
import org.eclipse.datatools.connectivity.oda.spec.result.CustomAggregate;

public class AggregateDefinition {
    public static final String ELEMENT_NAME = "aggregateType";
    public static final String ATTR_ID = "id";
    public static final String ATTR_NAME = "displayName";
    public static final String ATTR_DESC = "description";
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_MIN_VARS = "minInputVariables";
    public static final String ATTR_MAX_VARS = "maxInputVariables";
    public static final String ATTR_CAN_IGNORE_DUPLS = "canIgnoreDuplicates";
    public static final String ATTR_CAN_IGNORE_NULLS = "canIgnoreNull";
    static final Integer ATTR_VARS_DEFAULT_VALUE = 1;
    private IConfigurationElement m_exprElement;
    private ExtensionContributor m_contributorInfo;
    private String m_id;
    private String m_name;
    private String m_desc;
    private Integer m_minVars;
    private Integer m_maxVars;
    private boolean m_canIgnoreDupls;
    private boolean m_canIgnoreNull;
    private VariableRestrictions m_varRestrictions;

    AggregateDefinition(IConfigurationElement exprElement, ExtensionContributor providerInfo) throws OdaException {
        this.init(exprElement, providerInfo);
    }

    private void init(IConfigurationElement exprElement, ExtensionContributor contributorInfo) throws OdaException {
        ResultExtensionUtil.validateConfigurationElement(exprElement);
        this.m_exprElement = exprElement;
        this.m_contributorInfo = contributorInfo;
        this.m_id = AggregateDefinition.getIdAttributeValue(exprElement);
        this.m_name = exprElement.getAttribute(ATTR_NAME);
        this.m_desc = exprElement.getAttribute(ATTR_DESC);
        this.m_minVars = ResultExtensionUtil.getMinAttributeValue(exprElement, ATTR_MIN_VARS, ATTR_VARS_DEFAULT_VALUE);
        this.m_maxVars = ResultExtensionUtil.getMaxAttributeValue(exprElement, ATTR_MAX_VARS, ATTR_VARS_DEFAULT_VALUE, this.m_minVars);
        this.m_canIgnoreDupls = ResultExtensionUtil.getBooleanAttributeValue(exprElement, ATTR_CAN_IGNORE_DUPLS, false);
        this.m_canIgnoreNull = ResultExtensionUtil.getBooleanAttributeValue(exprElement, ATTR_CAN_IGNORE_NULLS, false);
        this.m_varRestrictions = new VariableRestrictions(exprElement);
    }

    public static String getIdAttributeValue(IConfigurationElement exprElement) throws OdaException {
        return ResultExtensionUtil.getRequiredAttributeValue(exprElement, ATTR_ID, ELEMENT_NAME);
    }

    public CustomAggregate createExpression() throws OdaException {
        return this.createExpression(null);
    }

    public CustomAggregate createExpression(ExpressionVariable variable) throws OdaException {
        String className = this.m_exprElement.getAttribute(ATTR_CLASS);
        if (className != null && className.length() > 0) {
            try {
                Object clazz = this.m_exprElement.createExecutableExtension(ATTR_CLASS);
                if (clazz instanceof CustomAggregate) {
                    if (variable != null) {
                        ((CustomAggregate)clazz).add(variable);
                    }
                    return (CustomAggregate)clazz;
                }
                throw new OdaException(Messages.bind((String)Messages.querySpec_INVALID_CLASS_TYPE_ATTRIBUTE, (Object[])new Object[]{className, ATTR_CLASS, CustomAggregate.class.getName()}));
            }
            catch (CoreException ex) {
                throw new OdaException(ex);
            }
        }
        return new CustomAggregate(this.getDeclaringExtensionId(), this.getId(), variable);
    }

    public boolean supportsDataSetType(String odaDataSourceId, String odaDataSetId) {
        return this.m_contributorInfo.supportsDataSetType(odaDataSourceId, odaDataSetId);
    }

    public String getDeclaringExtensionId() {
        return this.m_contributorInfo.getDeclaringExtensionId();
    }

    public String getId() {
        return this.m_id;
    }

    public String getDisplayName() {
        if (this.m_name != null && this.m_name.trim().length() > 0) {
            return this.m_name;
        }
        return this.m_id;
    }

    public String getDescription() {
        return this.m_desc;
    }

    public ExtensionContributor getContributor() {
        return this.m_contributorInfo;
    }

    public IValidator getValidator() throws OdaException {
        return this.m_contributorInfo.getValidator();
    }

    public Integer getMinInputVariables() {
        return this.m_minVars;
    }

    public boolean supportsUnboundedMaxInputVariables() {
        return this.getMaxInputVariables() == null;
    }

    public Integer getMaxInputVariables() {
        return this.m_maxVars;
    }

    public boolean canIgnoreDuplicateValues() {
        return this.m_canIgnoreDupls;
    }

    public boolean canIgnoreNullValues() {
        return this.m_canIgnoreNull;
    }

    public VariableRestrictions getVariableRestrictions() {
        return this.m_varRestrictions;
    }
}

