/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.result;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.spec.ExpressionVariable;
import org.eclipse.datatools.connectivity.oda.spec.ValidationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AggregateExpression {
    private List<ExpressionVariable> m_inputVariables;
    private boolean m_ignoresDups = false;
    private boolean m_ignoresNull = true;
    private String m_alias;
    private static final String LOG_VAR_ENTRY = "\n      ";

    protected AggregateExpression(ExpressionVariable inputSourceVar) {
        if (inputSourceVar != null) {
            this.add(inputSourceVar);
        }
    }

    public AggregateExpression add(ExpressionVariable inputSourceVar) {
        this.getVariables().add(inputSourceVar);
        return this;
    }

    public List<ExpressionVariable> getVariables() {
        if (this.m_inputVariables == null) {
            this.m_inputVariables = new ArrayList<ExpressionVariable>(1);
        }
        return this.m_inputVariables;
    }

    public void setVariables(List<ExpressionVariable> variables) {
        this.m_inputVariables = variables;
    }

    public String getQualifiedId() {
        return this.getClass().getName();
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public String getAlias() {
        return this.m_alias;
    }

    public void setAlias(String alias) {
        this.m_alias = alias;
    }

    public boolean ignoresDuplicateValues() {
        return this.m_ignoresDups;
    }

    public void setIgnoreDuplicateValues(boolean ignoresDups) {
        this.m_ignoresDups = ignoresDups;
    }

    public boolean ignoresNullValues() {
        return this.m_ignoresNull;
    }

    public void setIgnoreNullValues(boolean ignoresNull) {
        this.m_ignoresNull = ignoresNull;
    }

    public void validate() throws OdaException {
        this.validate(null);
    }

    public void validate(ValidationContext context) throws OdaException {
        this.validateSyntax(context);
        if (context != null && context.getValidator() != null) {
            context.getValidator().validate(this, context);
        }
    }

    public abstract void validateSyntax(ValidationContext var1) throws OdaException;

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.getQualifiedId());
        buffer.append("\n    ( input variable(s): ");
        if (this.m_inputVariables != null) {
            for (ExpressionVariable inputVar : this.m_inputVariables) {
                buffer.append(LOG_VAR_ENTRY + inputVar);
            }
        }
        buffer.append(" )");
        return buffer.toString();
    }
}

