/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.internal.ui;

import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.internal.UUID;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.util.DesignUtil;
import org.eclipse.datatools.connectivity.oda.profile.internal.OdaConnectionProfile;
import org.eclipse.datatools.connectivity.oda.profile.internal.ProfileCategoryUtil;

public class AdaptableDataSourceProfile
extends OdaConnectionProfile
implements IConnectionProfile {
    private DataSourceDesign m_dataSourceDesign;
    private String m_instanceID;

    public AdaptableDataSourceProfile(DataSourceDesign design) {
        this.m_dataSourceDesign = design;
        IConnectionProfile linkedProfile = null;
        try {
            linkedProfile = DesignSessionUtil.getLinkedProfile(design);
        }
        catch (OdaException odaException) {}
        if (linkedProfile != null) {
            this.setWrappedProfile(linkedProfile);
        }
    }

    protected AdaptableDataSourceProfile(IConnectionProfile wrappedProfile) {
        super(wrappedProfile);
    }

    protected AdaptableDataSourceProfile() {
        this.m_dataSourceDesign = DesignFactory.eINSTANCE.createDataSourceDesign();
    }

    public DataSourceDesign getDataSourceDesign() {
        return this.m_dataSourceDesign;
    }

    public boolean hasLinkedProfile() {
        return this.hasWrappedProfile();
    }

    public IConnectionProfile getLinkedProfile() {
        return this.getWrappedProfile();
    }

    public String getName() {
        if (this.hasLinkedProfile()) {
            return super.getName();
        }
        return this.getDataSourceDesign().getName();
    }

    public String getDescription() {
        if (this.hasLinkedProfile()) {
            return super.getDescription();
        }
        return this.getDataSourceDesign().getDisplayName();
    }

    public boolean isAutoConnect() {
        if (this.hasLinkedProfile()) {
            return super.isAutoConnect();
        }
        return false;
    }

    public String getInstanceID() {
        if (this.hasLinkedProfile()) {
            return super.getInstanceID();
        }
        if (this.m_instanceID == null) {
            this.m_instanceID = UUID.createUUID().toString();
        }
        return this.m_instanceID;
    }

    public IConnectionProfile getParentProfile() {
        if (this.hasLinkedProfile()) {
            return super.getParentProfile();
        }
        return null;
    }

    public Properties getBaseProperties() {
        Properties linkedProfileProps;
        Properties designProps = DesignUtil.convertDataSourceProperties((DataSourceDesign)this.getDataSourceDesign());
        if (this.hasLinkedProfile() && (linkedProfileProps = super.getBaseProperties()) != null) {
            designProps.putAll((Map<?, ?>)linkedProfileProps);
        }
        return designProps;
    }

    public void setBaseProperties(Properties props) {
        if (this.hasLinkedProfile()) {
            super.setBaseProperties(props);
            return;
        }
        String dataSourceElmtId = this.getDataSourceDesign().getOdaExtensionDataSourceId();
        if (dataSourceElmtId == null) {
            return;
        }
        try {
            this.getDataSourceDesign().setPublicProperties(DesignSessionUtil.createDataSourcePublicProperties(dataSourceElmtId, props));
            this.getDataSourceDesign().setPrivateProperties(DesignSessionUtil.createDataSourceNonPublicProperties(dataSourceElmtId, props));
        }
        catch (OdaException odaException) {
            return;
        }
    }

    public Properties getProperties(String type) {
        if (this.hasLinkedProfile()) {
            return super.getProperties(type);
        }
        return this.getBaseProperties();
    }

    public void setProperties(String type, Properties props) {
        if (this.hasLinkedProfile()) {
            super.setProperties(type, props);
            return;
        }
        this.setBaseProperties(props);
    }

    public IStatus connect() {
        if (this.hasLinkedProfile()) {
            return super.connect();
        }
        return this.createNAConnectionStatus();
    }

    public IStatus connectWithoutJob() {
        if (this.hasLinkedProfile()) {
            return super.connectWithoutJob();
        }
        return this.createNAConnectionStatus();
    }

    private IStatus createNAConnectionStatus() {
        return new Status(2, this.getDataSourceDesign().getOdaExtensionId(), -1, "", null);
    }

    public IStatus disconnect() {
        if (this.hasLinkedProfile()) {
            return super.disconnect();
        }
        return !this.isConnected() ? Status.OK_STATUS : this.createNAConnectionStatus();
    }

    public void disconnect(IJobChangeListener listener) {
        if (this.hasLinkedProfile()) {
            super.disconnect(listener);
        }
    }

    public IManagedConnection getManagedConnection(String type) {
        if (this.hasLinkedProfile()) {
            return super.getManagedConnection(type);
        }
        return null;
    }

    public String getProviderName() {
        if (this.hasLinkedProfile()) {
            return super.getProviderName();
        }
        return this.getDataSourceDesign().getOdaExtensionDataSourceId();
    }

    public String getProviderId() {
        if (this.hasLinkedProfile()) {
            return super.getProviderId();
        }
        return this.getDataSourceDesign().getOdaExtensionDataSourceId();
    }

    public ICategory getCategory() {
        if (this.hasLinkedProfile()) {
            return super.getCategory();
        }
        return ProfileCategoryUtil.getCategory((String)this.getProviderId());
    }
}

