/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor.commonui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.sqltools.common.core.tableviewer.IRowData;
import org.eclipse.datatools.sqltools.common.core.tableviewer.ITableData;
import org.eclipse.datatools.sqltools.common.core.tableviewer.RowData;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.AccessibleTableViewer;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.Messages;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.ObjectTransfer;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.PasteRowAction;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.PasteRowActionUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ContextAccessibleTableViewer
extends AccessibleTableViewer {
    private boolean _needPostFix = true;
    protected static final String EDIT_GROUP = "edit";
    protected static final String DEL_GROUP = "delete";

    public ContextAccessibleTableViewer(Composite parent, int style, int index) {
        super(parent, style);
    }

    public ContextAccessibleTableViewer(Composite parent, int index) {
        super(parent);
    }

    public ContextAccessibleTableViewer(Table table, int index) {
        super(table);
    }

    public void setNeedPostFix(boolean needPostFix) {
        this._needPostFix = needPostFix;
    }

    public class AddRowAction
    extends Action {
        private AccessibleTableViewer _tableViewer;
        private int _focusIndex;

        public AddRowAction(AccessibleTableViewer viewer, int focusIndex) {
            this.setText(Messages.AddRowAction_text);
            this._focusIndex = focusIndex;
            this._tableViewer = viewer;
        }

        public void run() {
            ITableData tableData = (ITableData)this._tableViewer.getInput();
            tableData.insertRow();
            this._tableViewer.refresh();
            int selection = this._tableViewer.getTable().getItemCount() - 2;
            this._tableViewer.getCursor().setSelection(selection, this._focusIndex + 1);
            this._tableViewer.getCursor().edit();
        }
    }

    class ColumnRowPasteAction
    extends PasteRowAction {
        private int _col;

        public ColumnRowPasteAction(AccessibleTableViewer accessibleTableViewer, Clipboard clipboard, int col) {
            super(accessibleTableViewer, clipboard);
            this._col = col;
        }

        public void run() {
            if (!((ITableData)this._accessibleTableViewer.getInput()).isNewRowDataAllowed()) {
                return;
            }
            if (this._clipboard == null || !this._accessibleTableViewer.getCursor().getVisible()) {
                return;
            }
            RowData rowData = (RowData)this._clipboard.getContents((Transfer)ObjectTransfer.getInstance());
            ITableData tableData = (ITableData)this._accessibleTableViewer.getInput();
            Object rData = null;
            try {
                rData = rowData.clone();
                if (ContextAccessibleTableViewer.this._needPostFix) {
                    PasteRowActionUtil.addPostfix((RowData)((RowData)rData), (int)this._col, (ITableData)tableData);
                }
                ((RowData)rData).setTableData(tableData);
                TableItem selectedItem = this._accessibleTableViewer.getCursor().getRow();
                this._insertIndex = selectedItem != null ? this._accessibleTableViewer.getTable().indexOf(selectedItem) : 0;
                tableData.insertRow((IRowData)rData, this._insertIndex);
                this._accessibleTableViewer.refresh();
            }
            catch (Exception ex) {
                Status warning = new Status(4, "org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples", 1, Messages.PasteRowAction_can_not_paste_info, (Throwable)ex);
                ErrorDialog.openError((Shell)this._accessibleTableViewer.getControl().getShell(), (String)Messages.PasteRowAction_can_not_paste_title, null, (IStatus)warning);
            }
        }
    }
}

