/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.datatools.enablement.oda.xml.util.ColumnInfo;
import org.eclipse.datatools.enablement.oda.xml.util.MappingPathElementTree;
import org.eclipse.datatools.enablement.oda.xml.util.SaxParserUtil;

class TableInfo {
    private static final String EMPTY_STRING = "";
    private String tableName;
    private HashMap columnInfos;
    private HashMap filterInfos;
    private String originalRootPath;
    private String rootPath;
    private String[] realColumnNames = null;
    private String[] columnNames = null;
    private MappingPathElementTree mappingPathElementTree;
    private String[] nestedXMLColumnNames = null;

    public TableInfo(String tableName, String rootPath) {
        this.tableName = tableName;
        this.originalRootPath = rootPath;
        this.rootPath = SaxParserUtil.removeRedundantParentAxis(this.originalRootPath.replaceAll("\\Q[@\\E.*\\Q=\\E.*\\Q]\\E", EMPTY_STRING));
        this.columnInfos = new HashMap();
        this.filterInfos = new HashMap();
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getOriginalPath(String columnName) {
        return ((ColumnInfo)this.columnInfos.get(columnName)).getColumnOriginalPath();
    }

    public String getPath(String columnName) {
        return ((ColumnInfo)this.columnInfos.get(columnName)).getColumnPath();
    }

    public String getType(String columnName) {
        return ((ColumnInfo)this.columnInfos.get(columnName)).getColumnType();
    }

    public HashMap getFilter() {
        return this.filterInfos;
    }

    public HashMap getColumnFilters(String columnName) {
        return ((ColumnInfo)this.columnInfos.get(columnName)).getFilters();
    }

    public void addColumn(ColumnInfo ci) {
        this.columnInfos.put(ci.getColumnName(), ci);
    }

    public void addFilter(String columnName, String value) {
        this.filterInfos.put(columnName, value);
    }

    public String[] getColumnNames() {
        if (this.columnNames == null) {
            String[] temp = this.getRealColumnNames();
            ArrayList<String> l = new ArrayList<String>();
            int i = 0;
            while (i < temp.length) {
                if (SaxParserUtil.isTempColumn(temp[i])) break;
                l.add(temp[i]);
                ++i;
            }
            this.columnNames = this.getStringArrayFromList(l);
        }
        return this.columnNames;
    }

    public String[] getRealColumnNames() {
        if (this.realColumnNames == null) {
            Object[] names = this.columnInfos.keySet().toArray();
            this.realColumnNames = new String[names.length];
            int i = 0;
            while (i < names.length) {
                this.realColumnNames[((ColumnInfo)this.columnInfos.get((Object)names[i])).getColumnIndex() - 1] = names[i].toString();
                ++i;
            }
        }
        return this.realColumnNames;
    }

    public String[] getNestedXMLColumnNames() {
        if (this.nestedXMLColumnNames != null) {
            return this.nestedXMLColumnNames;
        }
        if (this.mappingPathElementTree != null) {
            String[] columnNames = this.getRealColumnNames();
            int[] indexes = this.mappingPathElementTree.getNestedColumnIndexes();
            this.nestedXMLColumnNames = new String[indexes.length];
            int i = 0;
            while (i < indexes.length) {
                this.nestedXMLColumnNames[i] = columnNames[indexes[i]];
                ++i;
            }
        } else {
            this.nestedXMLColumnNames = new String[0];
        }
        return this.nestedXMLColumnNames;
    }

    private String[] getStringArrayFromList(List temp) {
        String[] result = new String[temp.size()];
        temp.toArray(result);
        return result;
    }

    public String getOriginalRootPath() {
        return this.originalRootPath;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    void bulidMappingPathTree() {
        if (!MappingPathElementTree.isValidTableMappingPath(this.getRootPath())) {
            this.mappingPathElementTree = null;
            return;
        }
        String[] columnNames = this.getRealColumnNames();
        String[] columnPaths = new String[columnNames.length];
        int i = 0;
        while (i < columnPaths.length) {
            columnPaths[i] = ((ColumnInfo)this.columnInfos.get(columnNames[i])).getColumnPath();
            ++i;
        }
        this.mappingPathElementTree = new MappingPathElementTree(this.getRootPath(), columnPaths);
    }

    protected MappingPathElementTree getMappingPathTree() {
        return this.mappingPathElementTree;
    }
}

