/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;

final class FieldsReader {
    private FieldInfos fieldInfos;
    private IndexInput fieldsStream;
    private IndexInput indexStream;
    private int size;

    FieldsReader(Directory d, String segment, FieldInfos fn) throws IOException {
        this.fieldInfos = fn;
        this.fieldsStream = d.openInput(segment + ".fdt");
        this.indexStream = d.openInput(segment + ".fdx");
        this.size = (int)(this.indexStream.length() / 8L);
    }

    final void close() throws IOException {
        this.fieldsStream.close();
        this.indexStream.close();
    }

    final int size() {
        return this.size;
    }

    final Document doc(int n) throws IOException {
        this.indexStream.seek((long)n * 8L);
        long position = this.indexStream.readLong();
        this.fieldsStream.seek(position);
        Document doc = new Document();
        int numFields = this.fieldsStream.readVInt();
        for (int i = 0; i < numFields; ++i) {
            boolean tokenize;
            int fieldNumber = this.fieldsStream.readVInt();
            FieldInfo fi = this.fieldInfos.fieldInfo(fieldNumber);
            byte bits = this.fieldsStream.readByte();
            boolean compressed = (bits & 4) != 0;
            boolean bl = tokenize = (bits & 1) != 0;
            if ((bits & 2) != 0) {
                byte[] b = new byte[this.fieldsStream.readVInt()];
                this.fieldsStream.readBytes(b, 0, b.length);
                if (compressed) {
                    doc.add(new Field(fi.name, this.uncompress(b), Field.Store.COMPRESS));
                    continue;
                }
                doc.add(new Field(fi.name, b, Field.Store.YES));
                continue;
            }
            Field.Store store = Field.Store.YES;
            Field.Index index = fi.isIndexed && tokenize ? Field.Index.TOKENIZED : (fi.isIndexed && !tokenize ? Field.Index.UN_TOKENIZED : Field.Index.NO);
            Field.TermVector termVector = null;
            termVector = fi.storeTermVector ? (fi.storeOffsetWithTermVector ? (fi.storePositionWithTermVector ? Field.TermVector.WITH_POSITIONS_OFFSETS : Field.TermVector.WITH_OFFSETS) : (fi.storePositionWithTermVector ? Field.TermVector.WITH_POSITIONS : Field.TermVector.YES)) : Field.TermVector.NO;
            if (compressed) {
                store = Field.Store.COMPRESS;
                byte[] b = new byte[this.fieldsStream.readVInt()];
                this.fieldsStream.readBytes(b, 0, b.length);
                Field f = new Field(fi.name, new String(this.uncompress(b), "UTF-8"), store, index, termVector);
                f.setOmitNorms(fi.omitNorms);
                doc.add(f);
                continue;
            }
            Field f = new Field(fi.name, this.fieldsStream.readString(), store, index, termVector);
            f.setOmitNorms(fi.omitNorms);
            doc.add(f);
        }
        return doc;
    }

    private final byte[] uncompress(byte[] input) throws IOException {
        Inflater decompressor = new Inflater();
        decompressor.setInput(input);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(input.length);
        byte[] buf = new byte[1024];
        while (!decompressor.finished()) {
            try {
                int count = decompressor.inflate(buf);
                bos.write(buf, 0, count);
            }
            catch (DataFormatException e) {
                throw new IOException("field data are in wrong format: " + e.toString());
            }
        }
        decompressor.end();
        return bos.toByteArray();
    }
}

