/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.ddlgen.internal.ui.wizards;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.datatools.connectivity.sqm.core.rte.EngineeringOption;
import org.eclipse.datatools.help.ContextProviderDelegate;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.datatools.sqltools.ddlgen.internal.ui.FEUiPlugin;
import org.eclipse.datatools.sqltools.ddlgen.internal.ui.util.ResourceLoader;
import org.eclipse.datatools.sqltools.ddlgen.internal.ui.wizards.FEConfigurationData;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class FESelectObjectsWizardPage
extends WizardPage
implements IContextProvider {
    private static final String SELECT_ALL = ResourceLoader.INSTANCE.queryString("SELECT_ALL_BUTTON_TEXT");
    private static final String DESELECT_ALL = ResourceLoader.INSTANCE.queryString("DESELECT_ALL_BUTTON_TEXT");
    private static final String RESTORE_DEFAULTS = ResourceLoader.INSTANCE.queryString("RESTORE_DEFAULTS_BUTTON_TEXT");
    private static final String GENERATE_NO_MNEMONIC_LABEL_TEXT = ResourceLoader.INSTANCE.queryString("GENERATE_NO_MNEMONIC_LABEL_TEXT");
    private static final String FE_SELECT_OBJECTS_PAGE_HEADER_SUBTITLE = ResourceLoader.INSTANCE.queryString("FE_SELECT_OBJECTS_PAGE_HEADER_SUBTITLE");
    private static final String FE_SELECT_OBJECTS_PAGE_HEADER_TITLE = ResourceLoader.INSTANCE.queryString("FE_SELECT_OBJECTS_PAGE_HEADER_TITLE");
    private Label m_label;
    private Vector m_Buttons = new Vector();
    private Vector m_Default = new Vector();
    private Button m_selectAll;
    private Button m_deselectAll;
    private Button m_restoreDefaults;
    private FEConfigurationData configurationData;
    private FEConfigurationData filteredConfigurationData = new FEConfigurationData(new EngineeringOption[0]);
    private ContextProviderDelegate contextProviderDelegate = new ContextProviderDelegate(FEUiPlugin.getDefault().getBundle().getSymbolicName());

    public FESelectObjectsWizardPage(String pageName, FEConfigurationData configurationData) {
        super(pageName);
        this.configurationData = configurationData;
        this.setTitle(FE_SELECT_OBJECTS_PAGE_HEADER_TITLE);
        this.setDescription(FE_SELECT_OBJECTS_PAGE_HEADER_SUBTITLE);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.m_label = new Label(composite, 0);
        GridData generateData = new GridData();
        generateData.horizontalSpan = 2;
        this.m_label.setLayoutData((Object)generateData);
        this.m_label.setText(GENERATE_NO_MNEMONIC_LABEL_TEXT);
        Composite composite1 = new Composite(composite, 0);
        composite1.setLayout((Layout)new GridLayout());
        composite1.setLayoutData((Object)new GridData(768));
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(768));
        EngineeringOption[] options = this.configurationData.getOptions();
        Vector<EngineeringOption> filteredOptions = new Vector<EngineeringOption>();
        int index = 0;
        while (index < options.length) {
            EngineeringOption option = options[index];
            if (option != null && option.getCategory().getId().equals("GENERATE_ELEMENTS")) {
                filteredOptions.add(option);
            }
            ++index;
        }
        if (filteredOptions.size() == 1) {
            ((EngineeringOption)filteredOptions.get(0)).setBoolean(true);
        }
        Object[] filteredOptionsArray = new EngineeringOption[filteredOptions.size()];
        filteredOptions.copyInto(filteredOptionsArray);
        this.filteredConfigurationData = new FEConfigurationData((EngineeringOption[])filteredOptionsArray);
        int i = 0;
        while ((double)i < Math.ceil((double)filteredOptionsArray.length / 2.0)) {
            this.addButton(composite1, (EngineeringOption)filteredOptionsArray[i]);
            ++i;
        }
        i = (int)Math.ceil((double)filteredOptionsArray.length / 2.0);
        while (i < filteredOptionsArray.length) {
            this.addButton(composite2, (EngineeringOption)filteredOptionsArray[i]);
            ++i;
        }
        Composite composite3 = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 2;
        composite3.setLayout((Layout)layout);
        generateData = new GridData(768);
        generateData.horizontalSpan = 2;
        generateData.verticalSpan = 17;
        generateData.horizontalAlignment = 1;
        composite3.setLayoutData((Object)generateData);
        Composite composite4 = new Composite(composite3, 0);
        RowLayout layout2 = new RowLayout();
        layout2.pack = false;
        layout2.spacing = 5;
        composite4.setLayout((Layout)layout2);
        this.m_selectAll = new Button(composite4, 0);
        this.m_selectAll.setText(SELECT_ALL);
        this.m_deselectAll = new Button(composite4, 0);
        this.m_deselectAll.setText(DESELECT_ALL);
        this.m_restoreDefaults = new Button(composite4, 0);
        this.m_restoreDefaults.setText(RESTORE_DEFAULTS);
        this.m_selectAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Iterator it = FESelectObjectsWizardPage.this.m_Buttons.iterator();
                while (it.hasNext()) {
                    Button button = (Button)it.next();
                    ((EngineeringOption)button.getData()).setBoolean(true);
                    button.setSelection(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_deselectAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Iterator it = FESelectObjectsWizardPage.this.m_Buttons.iterator();
                while (it.hasNext()) {
                    Button button = (Button)it.next();
                    ((EngineeringOption)button.getData()).setBoolean(false);
                    button.setSelection(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_restoreDefaults.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                Iterator it = FESelectObjectsWizardPage.this.m_Buttons.iterator();
                while (it.hasNext()) {
                    Button button = (Button)it.next();
                    ((EngineeringOption)button.getData()).setBoolean(((Boolean)FESelectObjectsWizardPage.this.m_Default.get(i)).booleanValue());
                    button.setSelection(((Boolean)FESelectObjectsWizardPage.this.m_Default.get(i)).booleanValue());
                    ++i;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setControl((Control)composite);
        this.setPageComplete(true);
        this.getShell().setData(HelpUtil.CONTEXT_PROVIDER_KEY, (Object)this);
        HelpUtil.setHelp((Control)this.getControl(), (String)HelpUtil.getContextId((String)"GENERATE_DDL_SELECT_OBJECTS_WIZARD_PAGE", (String)FEUiPlugin.getDefault().getBundle().getSymbolicName()));
    }

    private void addButton(Composite composite, EngineeringOption option) {
        this.m_Default.add(new Boolean(option.getBoolean()));
        final Button button = new Button(composite, 32);
        this.m_Buttons.add(button);
        button.setText(option.getOptionName());
        button.setData((Object)option);
        button.setSelection(option.getBoolean());
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ((EngineeringOption)button.getData()).setBoolean(button.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public FEConfigurationData getOptions() {
        return this.filteredConfigurationData;
    }

    public IContext getContext(Object target) {
        return this.contextProviderDelegate.getContext(target);
    }

    public int getContextChangeMask() {
        return this.contextProviderDelegate.getContextChangeMask();
    }

    public String getSearchExpression(Object target) {
        return this.contextProviderDelegate.getSearchExpression(target);
    }
}

