/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.mysql.catalog;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.enablement.mysql.MysqlPlugin;
import org.eclipse.datatools.enablement.mysql.catalog.MySqlCatalogDatabase;
import org.eclipse.datatools.enablement.mysql.catalog.MySqlCatalogTable;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.impl.SchemaImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class MySqlCatalogSchema
extends SchemaImpl
implements ICatalogObject {
    private static final long serialVersionUID = 3257567317125903160L;
    private static final String[] POSSIBLE_TABLE_TYPE_COL_NAMES = new String[]{"Types", "Type", "Engine"};
    private boolean tablesLoaded = false;

    public synchronized void refresh() {
        this.tablesLoaded = false;
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        Database database = this.getDatabase();
        return ((MySqlCatalogDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getDatabase();
    }

    public EList getTables() {
        if (!this.tablesLoaded) {
            this.loadTables();
        }
        return this.tables;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 9) {
            this.getTables();
        } else if (id == 16) {
            this.getRoutines();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadTables() {
        if (this.tablesLoaded) {
            return;
        }
        EList tableList = super.getTables();
        tableList.clear();
        Connection connection = this.getConnection();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            String catalogName = connection.getCatalog();
            if (catalogName == null || catalogName.trim().length() == 0) {
                connection.setCatalog(this.getName());
            }
            String query = "SHOW TABLE STATUS FROM `" + connection.getCatalog() + "`";
            Statement s = connection.createStatement();
            ResultSet r = s.executeQuery(query);
            ResultSetMetaData rmd = r.getMetaData();
            String typeStr = null;
            int columnCount = rmd.getColumnCount();
            HashSet<String> possibleTableTypeColNames = new HashSet<String>(Arrays.asList(POSSIBLE_TABLE_TYPE_COL_NAMES));
            int x = 1;
            while (x <= columnCount) {
                String colName = rmd.getColumnName(x).trim();
                if (possibleTableTypeColNames.contains(colName)) {
                    typeStr = colName;
                    break;
                }
                ++x;
            }
            while (r.next()) {
                MySqlCatalogTable table = new MySqlCatalogTable();
                table.setName(r.getString("Name"));
                if (typeStr != null) {
                    table.setTableType(r.getString(typeStr));
                }
                table.setAutoInc(r.getBoolean("Auto_increment"));
                tableList.add((Object)table);
            }
            this.tablesLoaded = true;
            r.close();
            s.close();
        }
        catch (Exception e) {
            MysqlPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.wst.rdb.mysql", 0, "Could not load the tables for database " + this.getDatabase().getName(), (Throwable)e));
        }
        this.eSetDeliver(deliver);
    }
}

