/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.baseloaders;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.enablement.sybase.asa.JDBCASAPlugin;
import org.eclipse.datatools.enablement.sybase.asa.catalog.SQLScriptsProvider;
import org.eclipse.datatools.enablement.sybase.asa.catalog.SybaseASACatalogUtils;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseDatabase;
import org.eclipse.datatools.enablement.sybase.util.SQLUtil;
import org.eclipse.datatools.modelbase.sql.constraints.CheckConstraint;
import org.eclipse.datatools.modelbase.sql.expressions.SQLExpressionsFactory;
import org.eclipse.datatools.modelbase.sql.expressions.SearchCondition;
import org.eclipse.datatools.modelbase.sql.expressions.SearchConditionDefault;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.tables.Table;

public class CheckConstraintASALoader {
    public static final String TABLE_CHECK_CONSTRAINT_TYPE = "T";
    public static final String COLUMN_CHECK_CONSTRAINT_TYPE = "C";
    protected CheckConstraint check;
    protected Connection conn;
    protected ICatalogObject catalogObj;

    public CheckConstraintASALoader(CheckConstraint catalogCheckConstraint) {
        this.check = catalogCheckConstraint;
        this.catalogObj = (ICatalogObject)catalogCheckConstraint;
        this.conn = this.catalogObj.getConnection();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void loadCCInfo(String type) {
        boolean deliver = this.check.eDeliver();
        this.check.eSetDeliver(false);
        SybaseASABaseDatabase db = (SybaseASABaseDatabase)this.catalogObj.getCatalogDatabase();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                Table table = this.getTable();
                String schemaName = table.getSchema().getName();
                String tableName = table.getName();
                stmt = this.conn.prepareStatement(SQLScriptsProvider.getQueryCheckConstraintInfo((Database)db));
                stmt.setString(1, schemaName);
                stmt.setString(2, tableName);
                stmt.setString(3, this.check.getName());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    this.precessResultSet(rs);
                }
            }
            catch (SQLException e) {
                JDBCASAPlugin.getDefault().log(e);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
            throw throwable;
        }
        {
            Object var9_12 = null;
        }
        SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        this.check.eSetDeliver(deliver);
    }

    protected void precessResultSet(ResultSet rs) throws SQLException {
        String conditions = rs.getString(2);
        SearchConditionDefault sc = SQLExpressionsFactory.eINSTANCE.createSearchConditionDefault();
        sc.setSQL(SQLUtil.parseSearchStatement((String)conditions));
        this.check.setSearchCondition((SearchCondition)sc);
    }

    protected Table getTable() {
        return this.check.getBaseTable();
    }
}

