/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.deltaddl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentServiceImpl;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.DDLGenerator;
import org.eclipse.datatools.connectivity.sqm.core.rte.EngineeringOption;
import org.eclipse.datatools.connectivity.sqm.internal.core.definition.DatabaseDefinitionRegistryImpl;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.EngineeringOptionCategory;
import org.eclipse.datatools.connectivity.sqm.internal.core.util.ChangeDescriptionUtil;
import org.eclipse.datatools.enablement.sybase.ddl.ISybaseDdlGenerator;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlGenerator;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlScript;
import org.eclipse.datatools.enablement.sybase.deltaddl.AbstractDeltaDdlGenProvider;
import org.eclipse.datatools.enablement.sybase.deltaddl.DeltaDdlGenServiceImpl;
import org.eclipse.datatools.enablement.sybase.deltaddl.IDeltaDdlGenProvider;
import org.eclipse.datatools.enablement.sybase.deltaddl.ISybaseDeltaDdlGenerator;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.FeatureChange;

public class SybaseDeltaDdlGeneration
implements ISybaseDeltaDdlGenerator {
    public static final int CREATE = 1;
    public static final int DROP = 2;
    public static final int MODIFIED = 4;
    protected Map modifyRecords = null;
    protected ChangeDescription changeDescription = null;
    protected Collection redoChanges = null;
    protected EngineeringOption[] options = null;
    private DDLGenerator _ddlGen;
    private Object _parameter;
    protected EObject rootObject = null;
    private EngineeringOptionCategory[] categories = null;
    private ChangeDescriptionUtil changeDescriptionUtil;

    public String[] generateDeltaDDL(EObject rootObject, ChangeDescription changeDescription, IProgressMonitor monitor) {
        this.rootObject = rootObject;
        this.changeDescription = changeDescription;
        this.changeDescriptionUtil = new ChangeDescriptionUtil(changeDescription);
        Map changeMap = this.buildChangeMap(monitor);
        this.analyze(changeMap);
        String[] statements = this.processChangeMap(changeMap, monitor);
        this.changeDescription = null;
        this.redoChanges = null;
        this.modifyRecords = null;
        this.options = null;
        return statements;
    }

    public SybaseDdlScript generateDeltaDDLReturnScript(EObject rootObject, ChangeDescription changeDescription, IProgressMonitor monitor) {
        this.rootObject = rootObject;
        this.changeDescription = changeDescription;
        this.changeDescriptionUtil = new ChangeDescriptionUtil(changeDescription);
        Map changeMap = this.buildChangeMap(monitor);
        this.analyze(changeMap);
        SybaseDdlScript script = this.processChangeMapReturnScript(changeMap, monitor);
        this.changeDescription = null;
        this.redoChanges = null;
        this.modifyRecords = null;
        this.options = null;
        return script;
    }

    public String[] generateDeltaDDL(EObject rootObject, ChangeDescription changeDescription, EngineeringOption[] options, IProgressMonitor monitor) {
        this.options = options;
        return this.generateDeltaDDL(rootObject, changeDescription, monitor);
    }

    public SybaseDdlScript generateDeltaDDLReturnScript(EObject rootObject, ChangeDescription changeDescription, EngineeringOption[] options, IProgressMonitor monitor) {
        this.options = options;
        return this.generateDeltaDDLReturnScript(rootObject, changeDescription, monitor);
    }

    protected int getChangeFlag(EObject element, EObject changed, EStructuralFeature feature, FeatureChange setting) {
        ArrayList<FeatureChangeRecord> records;
        int flag = 4;
        if (this.modifyRecords == null) {
            this.modifyRecords = new HashMap();
        }
        if ((records = (ArrayList<FeatureChangeRecord>)this.modifyRecords.get(element)) == null) {
            records = new ArrayList<FeatureChangeRecord>();
            this.modifyRecords.put(element, records);
        }
        FeatureChangeRecord cr = new FeatureChangeRecord();
        cr.changed = changed;
        cr.feature = feature;
        cr.oldValue = setting.getValue();
        cr.newValue = changed.eGet(feature);
        records.add(cr);
        return flag;
    }

    protected void analyze(Map changeMap) {
        LinkedList elements = new LinkedList();
        elements.addAll(changeMap.keySet());
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            SQLObject sqlObj;
            IDeltaDdlGenProvider provider;
            EObject e = (EObject)it.next();
            if (!changeMap.containsKey(e) || !(e instanceof SQLObject) || (provider = this.getProvider(sqlObj = (SQLObject)e)) == null) continue;
            provider.analyze(sqlObj, changeMap, this.modifyRecords);
        }
    }

    protected String[] processChangeMap(Map changeMap, IProgressMonitor monitor) {
        ISybaseDdlGenerator ddlGenerator = (ISybaseDdlGenerator)this.getDDLGenerator();
        SybaseDdlScript script = new SybaseDdlScript();
        boolean useDBStmtAdded = false;
        this.undo();
        this.processDropStatements(ddlGenerator, changeMap, script, monitor);
        useDBStmtAdded = this.polishScripts(changeMap, script);
        this.redo();
        this.processCreateStatements(ddlGenerator, changeMap, script, monitor);
        this.processAlterStatements(changeMap, script, monitor);
        this.changeDescription = null;
        if (!useDBStmtAdded) {
            this.polishScripts(changeMap, script);
        }
        return script.getStatements();
    }

    protected SybaseDdlScript processChangeMapReturnScript(Map changeMap, IProgressMonitor monitor) {
        ISybaseDdlGenerator ddlGenerator = (ISybaseDdlGenerator)this.getDDLGenerator();
        SybaseDdlScript script = new SybaseDdlScript();
        boolean useDBStmtAdded = false;
        this.undo();
        this.processDropStatements(ddlGenerator, changeMap, script, monitor);
        useDBStmtAdded = this.polishScripts(changeMap, script);
        this.redo();
        this.processCreateStatements(ddlGenerator, changeMap, script, monitor);
        this.processAlterStatements(changeMap, script, monitor);
        this.changeDescription = null;
        if (!useDBStmtAdded) {
            this.polishScripts(changeMap, script);
        }
        return script;
    }

    protected boolean polishScripts(Map changeMap, SybaseDdlScript script) {
        return true;
    }

    protected void processCreateStatements(ISybaseDdlGenerator ddlGenerator, Map changeMap, SybaseDdlScript script, IProgressMonitor monitor) {
        Iterator it = changeMap.keySet().iterator();
        while (it.hasNext()) {
            SQLObject sqlObj;
            IDeltaDdlGenProvider provider;
            EObject key = (EObject)it.next();
            int flag = (Integer)changeMap.get(key);
            if ((flag & 1) == 0 || !(key instanceof SQLObject) || (provider = this.getProvider(sqlObj = (SQLObject)key)) == null) continue;
            provider.processCreateStatement(sqlObj, this.generateQuotedIdentifiers(), this.generateFullyQualifiedNames(), this.generateFullSyntax(), script, ddlGenerator, monitor);
        }
    }

    protected void processDropStatements(ISybaseDdlGenerator ddlGenerator, Map changeMap, SybaseDdlScript script, IProgressMonitor monitor) {
        Iterator it = changeMap.keySet().iterator();
        while (it.hasNext()) {
            SQLObject sqlObj;
            IDeltaDdlGenProvider provider;
            EObject key = (EObject)it.next();
            int flag = (Integer)changeMap.get(key);
            if ((flag & 2) == 0 || !(key instanceof SQLObject) || (provider = this.getProvider(sqlObj = (SQLObject)key)) == null) continue;
            provider.processDropStatement(sqlObj, this.generateQuotedIdentifiers(), this.generateFullyQualifiedNames(), script, ddlGenerator, monitor);
        }
    }

    protected void processAlterStatements(Map changeMap, SybaseDdlScript script, IProgressMonitor monitor) {
        Iterator it = changeMap.keySet().iterator();
        while (it.hasNext()) {
            SQLObject sqlObj;
            IDeltaDdlGenProvider provider;
            EObject key = (EObject)it.next();
            int flag = (Integer)changeMap.get(key);
            if ((flag & 3) != 0 || !(key instanceof SQLObject) || (provider = this.getProvider(sqlObj = (SQLObject)key)) == null) continue;
            provider.processAlterStatement(sqlObj, this.modifyRecords, this.generateQuotedIdentifiers(), this.generateFullyQualifiedNames(), this.generateFullSyntax(), script, monitor);
        }
    }

    private IDeltaDdlGenProvider getProvider(SQLObject obj) {
        DatabaseDefinition def;
        EObject root = ContainmentServiceImpl.INSTANCE.getRootElement((EObject)obj);
        if (root instanceof Database && (def = DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition((Database)root)) != null) {
            IDeltaDdlGenProvider provider = DeltaDdlGenServiceImpl.INSTANCE.getDeltaDdlGenProvider(def.getProduct(), ((Database)root).getVersion(), (EObject)obj);
            if (provider instanceof AbstractDeltaDdlGenProvider) {
                ((AbstractDeltaDdlGenProvider)provider).setParameter(this.getParameter());
            }
            return provider;
        }
        return null;
    }

    public EngineeringOption[] getOptions() {
        if (this.options == null) {
            return ((SybaseDdlGenerator)this.getDDLGenerator()).getOptions();
        }
        return this.options;
    }

    public void setEngineeringOption(EngineeringOption[] options) {
        this.options = options;
    }

    public EngineeringOptionCategory[] getOptionCategories() {
        if (this.categories == null) {
            ResourceBundle resource = ResourceBundle.getBundle("org.eclipse.datatools.connectivity.sqm.internal.core.rte.fe.GenericDdlGeneration");
            Vector<EngineeringOptionCategory> categoryVec = new Vector<EngineeringOptionCategory>();
            categoryVec.add(new EngineeringOptionCategory("GENERATE_OPTIONS", resource.getString("GENERATION_OPTIONS"), resource.getString("GENERATION_OPTIONS_DES")));
            Object[] categories = new EngineeringOptionCategory[categoryVec.size()];
            categoryVec.copyInto(categories);
            this.categories = categories;
        }
        return this.categories;
    }

    protected final boolean generateQuotedIdentifiers() {
        return ((SybaseDdlGenerator)this.getDDLGenerator()).generateQuotedIdentifiers(this.getOptions());
    }

    protected final boolean generateFullyQualifiedNames() {
        return ((SybaseDdlGenerator)this.getDDLGenerator()).generateFullyQualifiedNames(this.getOptions());
    }

    protected final boolean generateFullSyntax() {
        return ((SybaseDdlGenerator)this.getDDLGenerator()).generateFullSyntax(this.getOptions());
    }

    protected final boolean generateSetUser() {
        return ((SybaseDdlGenerator)this.getDDLGenerator()).generateSetUser(this.getOptions());
    }

    private Map buildChangeMap(IProgressMonitor monitor) {
        LinkedHashMap<EObject, Integer> changeMap = new LinkedHashMap<EObject, Integer>();
        Iterator it = this.changeDescriptionUtil.getChangedDataObjectsGen().iterator();
        while (it.hasNext()) {
            EObject changed;
            EObject element;
            Object changedObject = it.next();
            if (!(changedObject instanceof EObject) || (element = this.getDisplayableElement(changed = (EObject)changedObject)) == null) continue;
            int flag = 0;
            if (changeMap.containsKey(element)) {
                flag = (Integer)changeMap.get(element);
            }
            if (flag == 2 || flag == 1) continue;
            if (this.changeDescriptionUtil.isCreated(element)) {
                if (this.changeDescriptionUtil.isDeleted(element)) continue;
                flag = 1;
            } else if (this.changeDescriptionUtil.isDeleted(element)) {
                flag = 2;
            } else {
                List oldValues;
                if (this.changeDescriptionUtil.isCreated(changed) || this.changeDescriptionUtil.isDeleted(changed) || (oldValues = this.changeDescriptionUtil.getOldValues(changed)) == null) continue;
                Iterator vi = oldValues.iterator();
                while (vi.hasNext()) {
                    FeatureChange changeSetting = (FeatureChange)vi.next();
                    EStructuralFeature f = changeSetting.getFeature();
                    Object currentValue = changed.eGet(f);
                    Object previousValue = changeSetting.getValue();
                    if (currentValue == null) {
                        currentValue = "";
                    }
                    if (previousValue == null) {
                        previousValue = "";
                    }
                    if (currentValue.equals(previousValue)) continue;
                    flag |= this.getChangeFlag(element, changed, f, changeSetting);
                }
            }
            if (flag == 0) continue;
            changeMap.put(element, new Integer(flag));
        }
        return changeMap;
    }

    protected final DDLGenerator getDDLGenerator() {
        if (this._ddlGen == null) {
            Database database = (Database)ContainmentServiceImpl.INSTANCE.getRootElement(this.rootObject);
            DatabaseDefinition def = DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition(database);
            this._ddlGen = def.getDDLGenerator();
        }
        return this._ddlGen;
    }

    protected final void undo() {
        LinkedList<ChangeRecord> undoStack = new LinkedList<ChangeRecord>();
        LinkedList<ChangeRecord> redoStack = new LinkedList<ChangeRecord>();
        Iterator it = this.changeDescriptionUtil.getChangedDataObjectsGen().iterator();
        while (it.hasNext()) {
            EObject changed;
            List oldValues;
            Object changedObject = it.next();
            if (!(changedObject instanceof EObject) || (oldValues = this.changeDescriptionUtil.getOldValues(changed = (EObject)changedObject)) == null) continue;
            Iterator vi = oldValues.iterator();
            while (vi.hasNext()) {
                FeatureChange fc = (FeatureChange)vi.next();
                EStructuralFeature f = fc.getFeature();
                fc.getValue();
                ChangeRecord c1 = new ChangeRecord();
                c1.element = changed;
                c1.feature = f;
                c1.isSet = true;
                if (f.isUnsettable()) {
                    c1.isSet = fc.isSet();
                }
                if (c1.isSet) {
                    c1.value = fc.getValue();
                    if (c1.value instanceof Collection) {
                        LinkedList l = new LinkedList();
                        l.addAll((Collection)c1.value);
                        c1.value = l;
                    }
                } else {
                    c1.value = null;
                }
                undoStack.add(c1);
                ChangeRecord c2 = new ChangeRecord();
                c2.element = changed;
                c2.feature = f;
                c2.isSet = true;
                if (f.isUnsettable()) {
                    c2.isSet = changed.eIsSet(f);
                }
                if (c2.isSet) {
                    c2.value = changed.eGet(f);
                    if (c2.value instanceof Collection) {
                        LinkedList l = new LinkedList();
                        l.addAll((Collection)c2.value);
                        c2.value = l;
                    }
                }
                redoStack.add(c2);
            }
        }
        this.executeChangeRecords(undoStack);
        this.redoChanges = redoStack;
    }

    protected final void redo() {
        this.executeChangeRecords(this.redoChanges);
    }

    protected final EObject getDisplayableElement(EObject e) {
        while (e != null && !ContainmentServiceImpl.INSTANCE.isDisplayableElement(e)) {
            e = ContainmentServiceImpl.INSTANCE.getContainer(e);
        }
        return e;
    }

    private void executeChangeRecords(Collection changeRecords) {
        Iterator it = changeRecords.iterator();
        while (it.hasNext()) {
            ChangeRecord r = (ChangeRecord)it.next();
            boolean eDeliver = r.element.eDeliver();
            r.element.eSetDeliver(false);
            EObject container = r.element.eContainer();
            boolean containerEDeliver = true;
            if (container != null) {
                containerEDeliver = container.eDeliver();
                container.eSetDeliver(false);
            }
            if (r.isSet) {
                if (r.feature.isMany()) {
                    Collection c = (Collection)r.element.eGet(r.feature);
                    c.clear();
                    c.addAll((Collection)r.value);
                } else {
                    r.element.eSet(r.feature, r.value);
                }
            } else {
                r.element.eUnset(r.feature);
            }
            r.element.eSetDeliver(eDeliver);
            if (container == null) continue;
            container.eSetDeliver(containerEDeliver);
        }
    }

    public void setParameter(Object obj) {
        this._parameter = obj;
    }

    public Object getParameter() {
        return this._parameter;
    }

    private static class ChangeRecord {
        public EObject element;
        public EStructuralFeature feature;
        public Object value;
        public boolean isSet;

        private ChangeRecord() {
        }
    }

    public static class FeatureChangeRecord {
        public EObject changed;
        public EStructuralFeature feature;
        public Object oldValue;
        public Object newValue;
    }
}

