/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.routineeditor.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.sqltools.routineeditor.IRoutineEditorDocumentProvider;
import org.eclipse.datatools.sqltools.routineeditor.SQLRoutineDocumentProvider;
import org.eclipse.datatools.sqltools.routineeditor.internal.RoutineEditorActivator;
import org.eclipse.ui.IEditorInput;

public class RoutineEditorDocumentProviderFactory {
    private static final SQLRoutineDocumentProvider ROUTINE_DOCUMENT_PROVIDER = new SQLRoutineDocumentProvider();
    private static IRoutineEditorDocumentProvider debuggerDocumentProvider = null;

    public static IRoutineEditorDocumentProvider getDocumentProvider(IEditorInput input) {
        IConfigurationElement[] configElements;
        IExtension[] extensions;
        if (debuggerDocumentProvider != null) {
            return debuggerDocumentProvider;
        }
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint(RoutineEditorActivator.PLUGIN_ID, "documentprovider");
        if (extensionPoint != null && (extensions = extensionPoint.getExtensions()).length > 0 && (configElements = extensions[0].getConfigurationElements())[0].getName().equals("provider")) {
            configElements[0].getAttribute("class");
            try {
                debuggerDocumentProvider = (IRoutineEditorDocumentProvider)configElements[0].createExecutableExtension("class");
            }
            catch (CoreException e) {
                RoutineEditorActivator.getDefault().log(e);
            }
        }
        if (debuggerDocumentProvider == null) {
            debuggerDocumentProvider = ROUTINE_DOCUMENT_PROVIDER;
        }
        return debuggerDocumentProvider;
    }
}

