/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result;

import org.eclipse.datatools.sqltools.result.ExternalResultSetViewer;
import org.eclipse.datatools.sqltools.result.IResultSetObject;
import org.eclipse.datatools.sqltools.result.model.IResultInstance;
import org.eclipse.datatools.sqltools.result.ui.view.ResultsViewControl;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

public abstract class ExternalResultSetViewerProvider {
    protected TableViewer tableViewer;
    protected Composite parentComposite;
    protected int tableStyle = 772;
    protected IResultInstance resultInstance;
    protected IResultSetObject resultSetObject;
    protected ResultsViewControl resultViewControl;
    protected boolean showRowCount;
    protected MenuManager menuManager;

    public void setParentComposite(Composite parent) {
        this.parentComposite = parent;
    }

    public void setStyle(int style) {
        this.tableStyle = style;
    }

    public void setResultInstance(IResultInstance instance) {
        this.resultInstance = instance;
    }

    public void setResult(IResultSetObject result) {
        this.resultSetObject = result;
    }

    public void setShowRow(boolean showRow) {
        this.showRowCount = showRow;
    }

    public void setResultViewControl(ResultsViewControl control) {
        this.resultViewControl = control;
    }

    public void configureViewer() {
        this.tableViewer = new ExternalResultSetViewer(this.parentComposite, this.tableStyle, this.resultInstance, this.resultSetObject, this.showRowCount, this.resultViewControl);
        this.menuManager = ((ExternalResultSetViewer)this.tableViewer).getMenuManager();
    }

    public void configureViewer(Composite parent, IResultInstance instance, IResultSetObject result, boolean showRowCount, ResultsViewControl control) {
        this.parentComposite = parent;
        this.resultInstance = instance;
        this.resultSetObject = result;
        this.showRowCount = showRowCount;
        this.resultViewControl = control;
        this.configureViewer();
    }

    protected MenuManager getMenuManager() {
        return this.menuManager;
    }

    public TableViewer getViewer() {
        return this.tableViewer;
    }

    public Table getTable() {
        if (this.tableViewer != null) {
            return this.tableViewer.getTable();
        }
        return null;
    }
}

