/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.ui.view;

import java.util.ArrayList;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.datatools.sqltools.result.internal.ResultsViewPlugin;
import org.eclipse.datatools.sqltools.result.internal.utils.PreferenceUtil;
import org.eclipse.datatools.sqltools.result.model.IResultInstance;
import org.eclipse.datatools.sqltools.result.ui.view.ResultsViewControl;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

class ItemsLimitationTreeViewer
extends TreeViewer {
    private ListenerList _listeners = new ListenerList();
    private ResultsViewControl _resultsViewControl;

    public void addRefreshListener(Listener listener) {
        this._listeners.add((Object)listener);
    }

    public void removeRefreshListener(Listener listener) {
        this._listeners.remove((Object)listener);
    }

    public ItemsLimitationTreeViewer(Composite parent, int style, ResultsViewControl resultsViewControl) {
        super(parent, style);
        this._resultsViewControl = resultsViewControl;
    }

    public Object[] getFilteredChildren(Object parent) {
        int limit;
        IPreferenceStore store = ResultsViewPlugin.getDefault().getPreferenceStore();
        ViewerFilter[] filters = this.getFilters();
        Object[] result = this.getRawChildren(parent);
        boolean isSubResults = false;
        if (parent instanceof IResultInstance) {
            isSubResults = true;
        }
        if (filters != null) {
            int i = 0;
            while (i < filters.length) {
                ViewerFilter f = filters[i];
                result = f.filter((Viewer)this, parent, result);
                ++i;
            }
        }
        if (PreferenceUtil.getBoolean(store, "org.eclipse.datatools.sqltools.result.ResultsFilterDialog.limitcheck", this._resultsViewControl.getUsePreferences()) && !isSubResults && result.length > (limit = PreferenceUtil.getInt(store, "org.eclipse.datatools.sqltools.result.ResultsFilterDialog.limitnum", this._resultsViewControl.getUsePreferences()))) {
            ArrayList<Object> list = new ArrayList<Object>();
            int i = 0;
            while (i < limit) {
                list.add(result[result.length - i - 1]);
                ++i;
            }
            return list.toArray();
        }
        return result;
    }

    public void refresh() {
        super.refresh();
        Object[] listeners = this._listeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((Listener)listeners[i]).handleEvent(new Event());
            ++i;
        }
    }
}

