/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.utils;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class UIUtil {
    public static final int DEFAULT_BUTTON_WIDTH = 70;
    public static final int DEFAULT_COMBO_WIDTH = 100;
    public static final int DEFAULT_TEXTBOX_WIDTH = 100;
    public static final int DEFAULT_RADIO_FILL = 36;

    public static int convertWidthInCharsToPixels(int chars, Control control) {
        if (control == null) {
            return 0;
        }
        GC gc = new GC((Drawable)control);
        gc.setFont(JFaceResources.getDialogFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        if (fontMetrics == null) {
            return 0;
        }
        return fontMetrics.getAverageCharWidth() * chars;
    }

    public static int convertHeightInCharsToPixels(int chars, Control control) {
        if (control == null) {
            return 0;
        }
        GC gc = new GC((Drawable)control);
        gc.setFont(JFaceResources.getDialogFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        if (fontMetrics == null) {
            return 0;
        }
        return fontMetrics.getHeight() * chars;
    }

    public static Label createLabel(Composite parent, String text, int numColumns, int indent) {
        Label label = new Label(parent, 16384);
        GridData data = new GridData();
        data.horizontalSpan = numColumns;
        data.horizontalAlignment = 4;
        data.horizontalIndent = indent;
        label.setLayoutData((Object)data);
        label.setText(text);
        return label;
    }

    public static Label createLabel(Composite parent, String text, int numColumns) {
        return UIUtil.createLabel(parent, text, numColumns, 0);
    }

    public static Button createPushButton(Composite parent, String label) {
        return UIUtil.createPushButton(parent, label, 70);
    }

    public static Button createPushButton(Composite parent, String label, int widthHint) {
        Button button = new Button(parent, 8);
        GridData data = new GridData();
        data.horizontalAlignment = 768;
        data.widthHint = widthHint;
        button.setLayoutData((Object)data);
        button.setText(label);
        return button;
    }

    public static Group createGroup(Composite parent, String title, int numColumns) {
        return UIUtil.createGroup(parent, title, numColumns, -1, 768);
    }

    public static Group createGroup(Composite parent, String title, int numColumns, int horizontalSpan, int gridDataFill) {
        Group group = new Group(parent, 16);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        group.setLayout((Layout)layout);
        GridData data = new GridData(gridDataFill);
        if (horizontalSpan > 0) {
            data.horizontalSpan = horizontalSpan;
        }
        group.setLayoutData((Object)data);
        group.setText(title);
        return group;
    }

    public static Button createCheckBox(Composite parent) {
        return UIUtil.createCheckBox(parent, null, 1, 0);
    }

    public static Button createCheckBox(Composite parent, String label, int numColumns) {
        return UIUtil.createCheckBox(parent, label, numColumns, 0);
    }

    public static Button createCheckBox(Composite parent, String label, int numColumns, int indent) {
        Button button = new Button(parent, 16416);
        if (label == null) {
            button.setAlignment(0x1000000);
        }
        GridData data = new GridData(4);
        data.horizontalSpan = numColumns;
        data.horizontalIndent = indent;
        button.setLayoutData((Object)data);
        if (label != null) {
            button.setText(label);
        }
        return button;
    }

    public static Text createTextBox(Composite parent) {
        return UIUtil.createTextBox(parent, 1, 100);
    }

    public static Text createTextBox(Composite parent, String text) {
        Text textbox = UIUtil.createTextBox(parent, 1);
        textbox.setText(text);
        return textbox;
    }

    public static Text createTextBox(Composite parent, int numColumns) {
        return UIUtil.createTextBox(parent, numColumns, 100);
    }

    public static Text createTextBox(Composite parent, int numColumns, int minWidth) {
        return UIUtil.createTextBox(parent, numColumns, minWidth, -1);
    }

    public static Text createTextBox(Composite parent, int numColumns, int minWidth, int minHeight) {
        Text text = new Text(parent, 2052);
        GridData data = new GridData(4);
        data.horizontalSpan = numColumns;
        data.widthHint = minWidth;
        data.heightHint = minHeight;
        text.setLayoutData((Object)data);
        return text;
    }

    public static Combo createCombo(Composite parent, String tokenString, int numColumns) {
        return UIUtil.createCombo(parent, UIUtil.getTokenNames(tokenString), numColumns, 100);
    }

    public static Combo createCombo(Composite parent, String tokenString, int numColumns, int minWidth) {
        return UIUtil.createCombo(parent, UIUtil.getTokenNames(tokenString), numColumns, minWidth);
    }

    public static Combo createCombo(Composite parent, String[] items, int numColumns, int minWidth) {
        return UIUtil.createCombo(parent, items, numColumns, minWidth, false);
    }

    public static Combo createCombo(Composite parent, String tokenString, int numColumns, int minWidth, boolean editable) {
        return UIUtil.createCombo(parent, UIUtil.getTokenNames(tokenString), numColumns, minWidth, editable);
    }

    public static Combo createCombo(Composite parent, String[] items, int numColumns, int minWidth, boolean editable) {
        GridData data;
        Combo combo;
        if (editable) {
            combo = new Combo(parent, 4);
            data = new GridData(768);
        } else {
            combo = new Combo(parent, 12);
            data = new GridData(4);
        }
        data.horizontalSpan = numColumns;
        data.widthHint = minWidth;
        combo.setLayoutData((Object)data);
        combo.setItems(items);
        return combo;
    }

    public static String[] getTokenNames(String tokenString) {
        if (tokenString == null) {
            return new String[0];
        }
        return tokenString.split(",");
    }
}

