/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.data.internal.ui.editor;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.sqltools.data.internal.core.editor.IRowData;
import org.eclipse.datatools.sqltools.data.internal.ui.DataUIPlugin;
import org.eclipse.datatools.sqltools.data.internal.ui.editor.Messages;
import org.eclipse.datatools.sqltools.data.internal.ui.editor.TableDataEditor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class DefaultExternalTableDataWizardPage
extends WizardPage
implements SelectionListener {
    protected TableDataEditor editor;
    protected IRowData rowData;
    protected int columnIndex;
    protected Text textWidget;
    protected Button btnImport;
    protected Button btnExport;
    protected Button btnSetNull;
    protected boolean displayImportBtn;
    protected boolean displayExportBtn;
    protected boolean displaySetNullBtn;
    protected boolean hasNullValue;
    protected boolean editorAreaIsSerialized;
    protected Composite basicComp;
    protected int buttonAreaSpan;

    public DefaultExternalTableDataWizardPage(String pageName) {
        super(pageName);
    }

    public void init(TableDataEditor editor) {
        if (editor == null || editor.getCursor() == null || editor.getCursor().getRow() == null) {
            throw new IllegalArgumentException(Messages.getString("DefaultExternalTableDataEditorWizard.InitError"));
        }
        this.editor = editor;
        this.columnIndex = editor.getCursor().getColumn();
        this.rowData = editor.getOrCreateRow();
        this.hasNullValue = this.isNullValue();
        try {
            String type = ((Column)editor.getSqlTable().getColumns().get(this.columnIndex)).getDataType().getName();
            this.setTitle(Messages.getString("DefaultExternalTableDataWizardPage.Title", new Object[]{type}));
        }
        catch (Exception exception) {
            this.setTitle(Messages.getString("DefaultExternalTableDataWizardPage.DefaultTitle"));
        }
        this.setDescription(Messages.getString("DefaultExternalTableDataWizardPage.Description"));
        this.displayImportBtn = true;
        this.displayExportBtn = true;
        this.displaySetNullBtn = true;
        this.buttonAreaSpan = 1;
    }

    protected boolean isNullValue() {
        return this.rowData.getValue(this.columnIndex) == null;
    }

    public void createControl(Composite parent) {
        this.basicComp = this.createBasicComposite(parent);
        this.createEditorArea(this.basicComp);
        this.createButtonArea(this.basicComp);
        this.setControl((Control)this.basicComp);
        if (this.editor.isReadonly()) {
            this.setPageComplete(false);
        } else {
            this.setPageComplete(true);
        }
    }

    protected Composite createBasicComposite(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.verticalSpacing = 10;
        comp.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        comp.setLayoutData((Object)gd);
        return comp;
    }

    protected void createEditorArea(Composite comp) {
        Composite editorComp = new Composite(comp, 0);
        GridLayout glEditor = new GridLayout(2, false);
        if (this.displayExportBtn || this.displayImportBtn) {
            glEditor.numColumns = 2;
        }
        glEditor.marginHeight = 0;
        glEditor.marginWidth = 0;
        editorComp.setLayout((Layout)glEditor);
        editorComp.setLayoutData((Object)new GridData(1808));
        this.textWidget = new Text(editorComp, 2818);
        this.textWidget.setEnabled(true);
        boolean editable = !this.hasNullValue && !this.editor.isReadonly();
        boolean nonNullableCheck = !((Column)this.editor.getSqlTable().getColumns().get(this.columnIndex)).isNullable() && this.hasNullValue;
        this.textWidget.setEditable(editable || nonNullableCheck);
        this.editorAreaIsSerialized = true;
        GridData gdtxtTextValue = new GridData(1808);
        gdtxtTextValue.grabExcessHorizontalSpace = true;
        gdtxtTextValue.grabExcessVerticalSpace = true;
        this.textWidget.setLayoutData((Object)gdtxtTextValue);
        gdtxtTextValue.horizontalSpan = 1;
        gdtxtTextValue.widthHint = 400;
        gdtxtTextValue.heightHint = 230;
        this.setEditorAreaContent(this.rowData.getValue(this.columnIndex));
        if (this.displayExportBtn || this.displayImportBtn) {
            GridLayout glButtons = new GridLayout();
            glButtons.marginWidth = 0;
            glButtons.marginHeight = 0;
            GridData gdCButtons = new GridData(1040);
            Composite cmpButtons = new Composite(editorComp, 0);
            cmpButtons.setLayout((Layout)glButtons);
            cmpButtons.setLayoutData((Object)gdCButtons);
            if (this.displayImportBtn) {
                GridData gdBtnImport = new GridData();
                gdBtnImport.horizontalAlignment = 4;
                this.btnImport = new Button(cmpButtons, 8);
                this.btnImport.setText(Messages.getString("DefaultExternalTableDataWizardPage.Button.Import"));
                this.btnImport.setLayoutData((Object)gdBtnImport);
                this.btnImport.addSelectionListener((SelectionListener)this);
                if (this.hasNullValue || this.editor.isReadonly()) {
                    this.btnImport.setEnabled(false);
                }
                if (!((Column)this.editor.getSqlTable().getColumns().get(this.columnIndex)).isNullable() && this.hasNullValue) {
                    this.btnImport.setEnabled(true);
                }
            }
            if (this.displayExportBtn) {
                GridData gdBtnExport = new GridData();
                gdBtnExport.horizontalAlignment = 4;
                gdBtnExport.verticalAlignment = 2;
                this.btnExport = new Button(cmpButtons, 8);
                this.btnExport.setText(Messages.getString("DefaultExternalTableDataWizardPage.Button.Export"));
                this.btnExport.setLayoutData((Object)gdBtnExport);
                this.btnExport.addSelectionListener((SelectionListener)this);
                if (this.hasNullValue) {
                    this.btnExport.setEnabled(false);
                }
                if (!((Column)this.editor.getSqlTable().getColumns().get(this.columnIndex)).isNullable() && this.hasNullValue) {
                    this.btnExport.setEnabled(true);
                }
            }
        }
    }

    protected void createButtonArea(Composite comp) {
        GridLayout glButtons = new GridLayout();
        glButtons.numColumns = this.buttonAreaSpan;
        glButtons.marginWidth = 0;
        glButtons.marginHeight = 0;
        GridData gdCButtons = new GridData();
        gdCButtons.horizontalAlignment = 1;
        Composite cmpButtons = new Composite(comp, 0);
        cmpButtons.setLayout((Layout)glButtons);
        cmpButtons.setLayoutData((Object)gdCButtons);
        if (this.displaySetNullBtn) {
            GridData gdBtnSetNull = new GridData();
            gdBtnSetNull.horizontalAlignment = 4;
            this.btnSetNull = new Button(cmpButtons, 32);
            this.btnSetNull.setText(Messages.getString("DefaultExternalTableDataWizardPage.Button.SetNull"));
            this.btnSetNull.setLayoutData((Object)gdBtnSetNull);
            this.btnSetNull.addSelectionListener((SelectionListener)this);
            if (this.hasNullValue) {
                this.btnSetNull.setSelection(true);
            }
            if (!((Column)this.editor.getSqlTable().getColumns().get(this.columnIndex)).isNullable() && this.hasNullValue) {
                this.btnSetNull.setSelection(false);
                this.hasNullValue = false;
            }
            if (((Column)this.editor.getSqlTable().getColumns().get(this.columnIndex)).isNullable() && !this.editor.isReadonly()) {
                this.btnSetNull.setEnabled(true);
            } else {
                this.btnSetNull.setEnabled(false);
            }
        }
    }

    protected String serializeInput(Object o) {
        return this.rowData.getTable().getColumnDataAccessor(this.columnIndex).serialize(o, this.rowData.getTable().getColumnType(this.columnIndex));
    }

    protected Object deserializeInput(String value) {
        return this.rowData.getTable().getColumnDataAccessor(this.columnIndex).deserialize(value, this.rowData.getTable().getColumnType(this.columnIndex));
    }

    public boolean updateRowData() {
        try {
            if (this.hasNullValue) {
                this.editor.doSetNull();
            } else {
                if (this.editorAreaIsSerialized) {
                    this.rowData.updateValue(this.columnIndex, this.deserializeInput((String)this.getEditorAreaContent()));
                } else {
                    this.rowData.updateValue(this.columnIndex, this.getEditorAreaContent());
                }
                this.editor.tableViewer.refresh((Object)this.rowData);
                this.editor.getCursor().redraw();
                this.editor.setDirty(true);
            }
            TableItem item = this.editor.getCursor().getRow();
            this.editor.setDirtyBackground(this.columnIndex, item);
            this.setErrorMessage(null);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setErrorMessage(Messages.getString("TableDataCellModifier.dataFormatError"));
            return false;
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.btnSetNull)) {
            this.handleSetNull();
        }
        if (e.getSource().equals(this.btnImport)) {
            this.handleImport();
        }
        if (e.getSource().equals(this.btnExport)) {
            this.handleExport();
        }
    }

    protected void handleSetNull() {
        if (this.getEditWidget() instanceof Text) {
            ((Text)this.getEditWidget()).setEditable(!this.btnSetNull.getSelection());
        } else {
            this.getEditWidget().setEnabled(!this.btnSetNull.getSelection());
        }
        if (this.displayImportBtn) {
            this.btnImport.setEnabled(!this.btnSetNull.getSelection());
        }
        if (this.displayExportBtn) {
            this.btnExport.setEnabled(!this.btnSetNull.getSelection());
        }
        this.hasNullValue = this.btnSetNull.getSelection();
    }

    protected void handleImport() {
        File aFile;
        String title = null;
        try {
            String type = ((Column)this.editor.getSqlTable().getColumns().get(this.columnIndex)).getDataType().getName();
            title = Messages.getString("DefaultExternalTableDataWizardPage.Import.Title", new Object[]{type});
        }
        catch (Exception exception) {
            title = Messages.getString("DefaultExternalTableDataWizardPage.Import.DefaultTitle");
        }
        FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
        fileDialog.setText(title);
        fileDialog.setFilterExtensions(this.getFileExtensions());
        String fname = fileDialog.open();
        if (fname != null && (aFile = new File(fname)).canRead()) {
            try {
                if (this.isBinaryFile()) {
                    FileInputStream fis = new FileInputStream(aFile);
                    BufferedInputStream bis = new BufferedInputStream(fis);
                    byte[] b = new byte[bis.available()];
                    bis.read(b);
                    bis.close();
                    this.setEditorAreaContent(b);
                } else {
                    StringBuffer input = new StringBuffer();
                    input.append(DataUIPlugin.getFileContentWithEncoding(fname));
                    this.setEditorAreaContent(input.toString());
                }
            }
            catch (FileNotFoundException fnfe) {
                DataUIPlugin.getDefault().writeLog(4, 0, fnfe.getMessage(), fnfe);
                this.setErrorMessage(Messages.getString("DefaultExternalTableDataWizardPage.Import.FileNotFound"));
            }
            catch (IOException ioe) {
                DataUIPlugin.getDefault().writeLog(4, 0, ioe.getMessage(), ioe);
                this.setErrorMessage(Messages.getString("DefaultExternalTableDataWizardPage.Import.IOError"));
            }
        }
    }

    protected void handleExport() {
        String title = null;
        try {
            String type = ((Column)this.editor.getSqlTable().getColumns().get(this.columnIndex)).getDataType().getName();
            title = Messages.getString("DefaultExternalTableDataWizardPage.Export.Title", new Object[]{type});
        }
        catch (Exception exception) {
            title = Messages.getString("DefaultExternalTableDataWizardPage.Export.DefaultTitle");
        }
        FileDialog fileDialog = new FileDialog(this.getShell(), 8192);
        fileDialog.setText(title);
        fileDialog.setFilterExtensions(this.getFileExtensions());
        String fname = fileDialog.open();
        if (fname != null) {
            File aFile = new File(fname);
            boolean writeFile = true;
            if (aFile.exists()) {
                MessageDialog dialog = new MessageDialog(this.getShell(), Messages.getString("DefaultExternalTableDataWizardPage.Export.FileOverwriteDialog.Title"), null, Messages.getString("DefaultExternalTableDataWizardPage.Export.FileOverwriteDialog.Message", new Object[]{fname}), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
                dialog.open();
                int returnValue = dialog.getReturnCode();
                if (returnValue != 0) {
                    writeFile = false;
                }
            }
            if (writeFile) {
                byte[] bytes;
                block15: {
                    Object obj = null;
                    obj = this.editorAreaIsSerialized ? this.deserializeInput((String)this.getEditorAreaContent()) : this.getEditorAreaContent();
                    bytes = null;
                    if (obj instanceof String) {
                        String encoding = DataUIPlugin.getCharacterEncoding();
                        try {
                            if (encoding != null && !encoding.equals("")) {
                                bytes = ((String)obj).getBytes(encoding);
                                break block15;
                            }
                            bytes = ((String)obj).getBytes();
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            bytes = ((String)obj).getBytes();
                        }
                    } else {
                        bytes = this.getByteContentForExport(obj);
                    }
                }
                if (bytes != null) {
                    try {
                        FileOutputStream fos = new FileOutputStream(aFile);
                        BufferedOutputStream bos = new BufferedOutputStream(fos);
                        bos.write(bytes);
                        bos.close();
                    }
                    catch (FileNotFoundException fnfe) {
                        DataUIPlugin.getDefault().writeLog(4, 0, fnfe.getMessage(), fnfe);
                        this.setErrorMessage(Messages.getString("DefaultExternalTableDataWizardPage.Export.FileNotFound"));
                    }
                    catch (IOException ioe) {
                        DataUIPlugin.getDefault().writeLog(4, 0, ioe.getMessage(), ioe);
                        this.setErrorMessage(Messages.getString("DefaultExternalTableDataWizardPage.Export.IOError"));
                    }
                }
            }
        }
    }

    protected String[] getFileExtensions() {
        String[] extension = new String[]{"*.*", "*.txt"};
        return extension;
    }

    protected boolean isBinaryFile() {
        Object workAround = this.deserializeInput("");
        return workAround instanceof byte[];
    }

    protected byte[] getByteContentForExport(Object exportableEditorContent) {
        if (exportableEditorContent instanceof byte[]) {
            return (byte[])exportableEditorContent;
        }
        return null;
    }

    protected Object getEditorAreaContent() {
        return this.textWidget.getText();
    }

    protected void setEditorAreaContent(Object content) {
        String serializedContent = null;
        serializedContent = content instanceof String ? (String)content : this.serializeInput(content);
        if (serializedContent == null) {
            this.hasNullValue = true;
            this.textWidget.setText("");
        } else {
            this.textWidget.setText(serializedContent);
            this.hasNullValue = false;
        }
    }

    protected void setEditorAreaContentFromFile(String fname) {
        File aFile = new File(fname);
        if (aFile.canRead()) {
            try {
                if (this.isBinaryFile()) {
                    FileInputStream fis = new FileInputStream(aFile);
                    BufferedInputStream bis = new BufferedInputStream(fis);
                    byte[] b = new byte[bis.available()];
                    bis.read(b);
                    bis.close();
                    this.setEditorAreaContent(b);
                } else {
                    StringBuffer input = new StringBuffer();
                    input.append(DataUIPlugin.getFileContentWithEncoding(fname));
                    this.setEditorAreaContent(input.toString());
                }
            }
            catch (FileNotFoundException fnfe) {
                DataUIPlugin.getDefault().writeLog(4, 0, fnfe.getMessage(), fnfe);
                this.setErrorMessage(Messages.getString("DefaultExternalTableDataWizardPage.Import.FileNotFound"));
            }
            catch (IOException ioe) {
                DataUIPlugin.getDefault().writeLog(4, 0, ioe.getMessage(), ioe);
                this.setErrorMessage(Messages.getString("DefaultExternalTableDataWizardPage.Import.IOError"));
            }
        }
    }

    protected Control getEditWidget() {
        return this.textWidget;
    }
}

