/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sql.parser.ast;

import org.eclipse.datatools.sqltools.sql.internal.SQLActivator;
import org.eclipse.datatools.sqltools.sql.parser.Messages;
import org.eclipse.datatools.sqltools.sql.parser.ParsingResult;
import org.eclipse.datatools.sqltools.sql.parser.SQLParser;
import org.eclipse.datatools.sqltools.sql.parser.Token;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTStart;
import org.eclipse.datatools.sqltools.sql.parser.ast.ISQLParserVisitor;
import org.eclipse.datatools.sqltools.sql.parser.ast.Node;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.util.Assert;
import org.eclipse.ui.IEditorInput;

public class SimpleNode
implements Node {
    protected Node _parent;
    protected Node[] _children;
    protected int _id;
    protected SQLParser _parser;
    protected Token _firstToken;
    protected Token _lastToken;

    public SimpleNode(int i) {
        this._id = i;
    }

    public SimpleNode(SQLParser p, int i) {
        this(i);
        this._parser = p;
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node n) {
        this._parent = n;
    }

    public Node jjtGetParent() {
        return this._parent;
    }

    public void jjtAddChild(Node n, int i) {
        if (this._children == null) {
            this._children = new Node[i + 1];
        } else if (i >= this._children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this._children, 0, c, 0, this._children.length);
            this._children = c;
        }
        this._children[i] = n;
    }

    public Node jjtGetChild(int i) {
        return this._children[i];
    }

    public int jjtGetNumChildren() {
        return this._children == null ? 0 : this._children.length;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public String toString(String prefix) {
        return String.valueOf(prefix) + this.toString();
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this._children != null) {
            int i = 0;
            while (i < this._children.length) {
                SimpleNode n = (SimpleNode)this._children[i];
                if (n != null) {
                    n.dump(String.valueOf(prefix) + " ");
                }
                ++i;
            }
        }
    }

    public Token getLastToken() {
        return this._lastToken;
    }

    public void setLastToken(Token token) {
        this._lastToken = token;
    }

    public Token getFirstToken() {
        return this._firstToken;
    }

    public void setFirstToken(Token token) {
        this._firstToken = token;
    }

    public int getStartOffset(IDocument document) {
        Assert.isNotNull((Object)document);
        int offset = 0;
        if (this._firstToken != null) {
            offset = this._firstToken.getStartOffset(document);
        }
        return offset;
    }

    public int getEndOffset(IDocument document) {
        Assert.isNotNull((Object)document);
        int offset = 0;
        if (this._lastToken != null) {
            offset = this._lastToken.getEndOffset(document);
        }
        return offset;
    }

    public int getGreatestEndOffset(IDocument document) {
        Assert.isNotNull((Object)document);
        int offset = 0;
        if (this._lastToken != null) {
            try {
                Token next = this._lastToken.next;
                if (next == null || next.kind == 0) {
                    return document.getLength() > 0 ? document.getLength() : 0;
                }
                offset = document.getLineOffset(next.beginLine - 1) + next.beginColumn - 1;
            }
            catch (BadLocationException e1) {
                SQLActivator.getDefault().log(Messages.SimpleNode_1, e1);
            }
        }
        return offset;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SimpleNode)) {
            return false;
        }
        try {
            SimpleNode other = (SimpleNode)obj;
            boolean equals = this._id == other._id && this._firstToken.equals(other._firstToken);
            return equals;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void setEditorInput(IEditorInput input) {
        if (this instanceof IASTStart) {
            ((IASTStart)((Object)this)).doSetEditorInput(input);
            return;
        }
        Node parent = this;
        while (parent.jjtGetParent() != null) {
            parent = parent.jjtGetParent();
        }
        if (parent == this) {
            parent.setEditorInput(input);
        }
    }

    public IEditorInput getEditorInput() {
        if (this instanceof IASTStart) {
            return ((IASTStart)((Object)this)).doGetEditorInput();
        }
        Node parent = this;
        while (parent.jjtGetParent() != null) {
            parent = parent.jjtGetParent();
        }
        if (parent == this) {
            return null;
        }
        return parent.getEditorInput();
    }

    public void setDocument(IDocument document) {
        if (this instanceof IASTStart) {
            ((IASTStart)((Object)this)).doSetDocument(document);
            return;
        }
        Node parent = this;
        while (parent.jjtGetParent() != null) {
            parent = parent.jjtGetParent();
        }
        if (parent == this) {
            parent.setDocument(document);
        }
    }

    public IDocument getDocument() {
        if (this instanceof IASTStart) {
            return ((IASTStart)((Object)this)).doGetDocument();
        }
        Node parent = this;
        while (parent.jjtGetParent() != null) {
            parent = parent.jjtGetParent();
        }
        if (parent == this) {
            return null;
        }
        return parent.getDocument();
    }

    public void setAnnotationModel(IAnnotationModel model) {
        if (this instanceof IASTStart) {
            ((IASTStart)((Object)this)).doSetAnnotationModel(model);
            return;
        }
        Node parent = this;
        while (parent.jjtGetParent() != null) {
            parent = parent.jjtGetParent();
        }
        if (parent != this) {
            parent.setAnnotationModel(model);
        }
    }

    public IAnnotationModel getAnnotationModel() {
        if (this instanceof IASTStart) {
            return ((IASTStart)((Object)this)).doGetAnnotationModel();
        }
        Node parent = this;
        while (parent.jjtGetParent() != null) {
            parent = parent.jjtGetParent();
        }
        if (parent == this) {
            return null;
        }
        return parent.getAnnotationModel();
    }

    public int getStartOffset() {
        return this.getStartOffset(this.getDocument());
    }

    public int getEndOffset() {
        return this.getEndOffset(this.getDocument());
    }

    public int getGreatestEndOffset() {
        return this.getGreatestEndOffset(this.getDocument());
    }

    public String getSQLText() {
        IDocument doc = this.getDocument();
        Assert.isNotNull((Object)doc);
        int start = this.getStartOffset(doc);
        int end = this.getEndOffset(doc);
        int length = end - start;
        length = length > 0 ? length : 0;
        try {
            return doc.get(start, length);
        }
        catch (BadLocationException e) {
            SQLActivator.getDefault().log(Messages.SimpleNode_2, e);
            return "";
        }
    }

    public int getNextTokenOffset() {
        return this.getNextTokenOffset(this.getDocument());
    }

    public int getNextTokenOffset(IDocument document) {
        Assert.isNotNull((Object)document);
        int offset = 0;
        Token nextToken = this._lastToken.next;
        if (this._lastToken != null && (nextToken.image.equals(",") || nextToken.image.equals(";"))) {
            try {
                offset = document.getLineOffset(nextToken.endLine - 1) + nextToken.endColumn;
            }
            catch (BadLocationException e1) {
                SQLActivator.getDefault().log(Messages.SimpleNode_1, e1);
            }
        }
        return offset;
    }

    public Node getPreviousNode() {
        this.getStartOffset();
        Node previousNode = ParsingResult.findNode(this.getDocument(), this.getStartOffset(), this.getRootNode(), true);
        return previousNode;
    }

    private Node getRootNode() {
        Node rootNode = this;
        while (rootNode.jjtGetParent() != null) {
            rootNode = rootNode.jjtGetParent();
        }
        return rootNode;
    }

    public String getText() {
        SimpleNode node = this;
        StringBuffer text = new StringBuffer("");
        if (node != null) {
            Token token = node.getFirstToken();
            text.append(token.image);
            while (token.next != null && token != node.getLastToken()) {
                if (token.image.equals(".") || token.next.image.equals(".")) {
                    token = token.next;
                } else {
                    token = token.next;
                    text.append(" ");
                }
                text.append(token.image);
            }
        }
        return text.toString();
    }

    public Object jjtAccept(ISQLParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object acceptChildren(ISQLParserVisitor visitor, Object data) {
        if (this._children != null) {
            int i = 0;
            while (i < this._children.length) {
                this._children[i].jjtAccept(visitor, data);
                ++i;
            }
        }
        return data;
    }

    public boolean exists() {
        return this._firstToken != null && this._lastToken != null && this._lastToken.next != this._firstToken;
    }
}

