/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.drivers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.IDriverMigrator;
import org.eclipse.datatools.connectivity.drivers.models.TemplateDescriptor;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;

public class DriverMigratorBase
implements IDriverMigrator,
IExecutableExtension {
    private static final String ELEM_PROPERTY_MIGRATION = "propertyMigration";
    private static final String ATTR_OLD_PROPERTY_KEY = "oldPropertyKey";
    private static final String ATTR_NEW_PROPERTY_KEY = "newPropertyKey";
    private static final String ATTR_NEW_VALUE = "newValue";
    private static final String ATTR_NEW_DRIVER_TEMPLATE_ID = "newDriverTemplateID";
    private static final String VALUE_ATTRIBUTE = "value";
    private static final String ID_ATTRIBUTE = "id";
    private Map mPropertyMigrations;
    private Map mDefaults;
    private String mNewDriverTemplateID;

    public boolean performMigration(DriverInstance driver) {
        return this.applyPropertyMigrations(driver);
    }

    public final String getNewDriverTemplateID() {
        return this.mNewDriverTemplateID;
    }

    protected final boolean applyPropertyMigrations(DriverInstance driver) {
        boolean changed = false;
        Properties props = driver.getPropertySet().getBaseProperties();
        if (props == null) {
            props = new Properties();
        }
        Iterator it = this.mPropertyMigrations.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String oldKey = (String)entry.getKey();
            String newKey = (String)entry.getValue();
            String value = driver.getNamedPropertyByID(oldKey);
            props.remove(oldKey);
            if (newKey == null || value == null) continue;
            props.setProperty(newKey, value);
            changed = true;
        }
        IConfigurationElement[] properties = TemplateDescriptor.getDriverTemplateDescriptor(this.mNewDriverTemplateID).getProperties();
        int i = 0;
        while (i < properties.length) {
            String testValue;
            String id = properties[i].getAttribute(ID_ATTRIBUTE);
            String value = properties[i].getAttribute(VALUE_ATTRIBUTE);
            if (id != null && id.length() > 0 && (props.getProperty(id) == null || (testValue = props.getProperty(id)) == null || testValue.trim().length() <= 0) && value != null && value.trim().length() > 0) {
                props.setProperty(id, value);
            }
            ++i;
        }
        driver.getPropertySet().setBaseProperties(props);
        return changed;
    }

    public final void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.mNewDriverTemplateID = config.getAttribute(ATTR_NEW_DRIVER_TEMPLATE_ID);
        if (TemplateDescriptor.getDriverTemplateDescriptor(this.mNewDriverTemplateID) == null) {
            Status status = new Status(4, ConnectivityPlugin.getDefault().getBundle().getSymbolicName(), -1, "migration.error.templateDoesNotExist", null);
            throw new CoreException((IStatus)status);
        }
        this.parsePropertyMigrations(config);
    }

    private void parsePropertyMigrations(IConfigurationElement config) throws CoreException {
        IConfigurationElement[] propertyMigrations = config.getChildren(ELEM_PROPERTY_MIGRATION);
        this.mPropertyMigrations = new HashMap(propertyMigrations.length);
        this.mDefaults = new HashMap(propertyMigrations.length);
        if (propertyMigrations == null || propertyMigrations.length == 0) {
            return;
        }
        int index = 0;
        int count = propertyMigrations.length;
        while (index < count) {
            String oldPropertyKey = propertyMigrations[index].getAttribute(ATTR_OLD_PROPERTY_KEY);
            if (oldPropertyKey == null || oldPropertyKey.length() == 0) {
                String newPropertyKey = propertyMigrations[index].getAttribute(ATTR_NEW_PROPERTY_KEY);
                if (newPropertyKey == null || newPropertyKey.length() == 0) {
                    Status status = new Status(4, ConnectivityPlugin.getDefault().getBundle().getSymbolicName(), -1, ConnectivityPlugin.getDefault().getResourceString("migration.error.invalidPropertyMigrationElement"), null);
                    throw new CoreException((IStatus)status);
                }
                String value = propertyMigrations[index].getAttribute(ATTR_NEW_VALUE);
                if (value != null) {
                    this.mDefaults.put(newPropertyKey, value);
                }
            } else {
                this.mPropertyMigrations.put(oldPropertyKey, propertyMigrations[index].getAttribute(ATTR_NEW_PROPERTY_KEY));
            }
            ++index;
        }
    }
}

