/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.sqltools.common.ui.dialog.SaveAsDialog;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.services.ActionService;
import org.eclipse.datatools.sqltools.core.services.SQLEditorService;
import org.eclipse.datatools.sqltools.editor.contentassist.ISQLDBProposalsService;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.plan.IPlanOption;
import org.eclipse.datatools.sqltools.sql.parser.ParserParameters;
import org.eclipse.datatools.sqltools.sql.parser.ParsingResult;
import org.eclipse.datatools.sqltools.sql.parser.SQLParser;
import org.eclipse.datatools.sqltools.sql.parser.ast.SimpleNode;
import org.eclipse.datatools.sqltools.sqleditor.IConnectionProfileAttachListener;
import org.eclipse.datatools.sqltools.sqleditor.ISQLEditorActionContributorExtension;
import org.eclipse.datatools.sqltools.sqleditor.ISQLEditorInput;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.sqleditor.SQLStorageDocumentProvider;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorContributorExtensionRegistry;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorDocumentSetupParticipant;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorResources;
import org.eclipse.datatools.sqltools.sqleditor.internal.SymbolInserter;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.AddTemplateAction;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.DMLDialogSelectionSQLAction;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.ExecuteSQLAction;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.ExecuteSelectionSQLAction;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.ToggleCommentAction;
import org.eclipse.datatools.sqltools.sqleditor.internal.editor.SQLEditorContentOutlinePage;
import org.eclipse.datatools.sqltools.sqleditor.internal.editor.SQLOutlinePage;
import org.eclipse.datatools.sqltools.sqleditor.internal.editor.SQLSourceViewerConfiguration;
import org.eclipse.datatools.sqltools.sqleditor.internal.editor.SQLUpdater;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.SQLDBProposalsService;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.SQLPartitionScanner;
import org.eclipse.datatools.sqltools.sqleditor.internal.utils.SQLColorProvider;
import org.eclipse.datatools.sqltools.sqleditor.preferences.ContentAssistPreference;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension4;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHoverExtension;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.text.source.ISourceViewerExtension3;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.ResourceAction;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.ui.texteditor.TextOperationAction;

public class SQLEditor
extends TextEditor
implements IPropertyChangeListener {
    public static final String PLUGIN_NAME = "org.eclipse.datatools.sqltools.sqleditor";
    public static final String HELP_CONTEXT_ID = "org.eclipse.datatools.sqltools.sqleditor.sqleditorhelp";
    protected AbstractSelectionChangedListener _fOutlineSelectionChangedListener = new OutlineSelectionChangedListener();
    private SQLOutlinePage _fOutlinePage = null;
    private SQLUpdater _fSQLUpdater = null;
    private ProjectionSupport fProjectionSupport;
    private SQLEditorDocumentSetupParticipant fDocSetupParticipant;
    private ISQLDBProposalsService fDBProposalsService;
    protected ParsingResult _parsingResult = null;
    private SymbolInserter _symbolInserter = null;
    private ArrayList _profileListeners = new ArrayList();
    private InformationPresenter _informationPresenter;
    private IEditorPart _parentEditor = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SQLEditor() {
        this._symbolInserter = new SymbolInserter(this);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.fireConnectionProfileAttached();
    }

    protected void createActions() {
        super.createActions();
        ResourceBundle bundle = this.getResourceBundle();
        IActionBars bars = ((IEditorSite)this.getSite()).getActionBars();
        Object a = new TextOperationAction(bundle, "ContentAssistProposal.", (ITextEditor)this, 13);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)a);
        a = new TextOperationAction(bundle, "ContentAssistTip.", (ITextEditor)this, 14);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.contextInformation");
        this.setAction("ContentAssistTip", (IAction)a);
        a = new TextOperationAction(bundle, "ContentFormat.", (ITextEditor)this, 15);
        this.setAction("ContentFormat", (IAction)a);
        a = new TextOperationAction(bundle, "ShowSQLInfo.", (ITextEditor)this, 16, true);
        a = new InformationDispatchAction(bundle, "ShowSQLInfo.", (TextOperationAction)a);
        a.setActionDefinitionId("org.eclipse.datatools.sqltools.sqleditor.show.sql.info");
        this.setAction("org.eclipse.datatools.sqltools.sqleditor.show.sql.info", (IAction)a);
        a = new ToggleCommentAction(bundle, "SQLEditor.action.toggle.commect.", (ITextEditor)this);
        this.setAction("org.eclipse.datatools.sqltools.sqleditor.toggleCommentAction", (IAction)a);
        this.configureToggleCommentAction((IAction)a);
        this.markAsStateDependentAction("org.eclipse.datatools.sqltools.sqleditor.toggleCommentAction", true);
        bars.setGlobalActionHandler("org.eclipse.datatools.sqltools.sqleditor.toggleCommentAction", this.getAction("org.eclipse.datatools.sqltools.sqleditor.toggleCommentAction"));
        this.setAction("org.eclipse.datatools.sqltools.sqleditor.ExecuteSQLAction", (IAction)new ExecuteSQLAction(this));
        bars.setGlobalActionHandler("org.eclipse.datatools.sqltools.sqleditor.ExecuteSQLAction", this.getAction("org.eclipse.datatools.sqltools.sqleditor.ExecuteSQLAction"));
        this.setAction("org.eclipse.datatools.sqltools.sqleditor.ExecuteSelectionAction", (IAction)new ExecuteSelectionSQLAction(this));
        this.markAsSelectionDependentAction("org.eclipse.datatools.sqltools.sqleditor.ExecuteSelectionAction", true);
        bars.setGlobalActionHandler("org.eclipse.datatools.sqltools.sqleditor.ExecuteSelectionAction", this.getAction("org.eclipse.datatools.sqltools.sqleditor.ExecuteSelectionAction"));
        this.setAction("org.eclipse.datatools.sqltools.sqleditor.DMLDialogSelectionAction", (IAction)new DMLDialogSelectionSQLAction(this));
        this.markAsSelectionDependentAction("org.eclipse.datatools.sqltools.sqleditor.DMLDialogSelectionAction", true);
        bars.setGlobalActionHandler("org.eclipse.datatools.sqltools.sqleditor.DMLDialogSelectionAction", this.getAction("org.eclipse.datatools.sqltools.sqleditor.DMLDialogSelectionAction"));
        this.setAction("org.eclipse.datatools.sqltools.sqleditor.saveAsTemplateAction", (IAction)new AddTemplateAction(this.getResourceBundle(), "AddTemplateAction.", this));
        this.markAsSelectionDependentAction("org.eclipse.datatools.sqltools.sqleditor.saveAsTemplateAction", true);
        bars.setGlobalActionHandler("org.eclipse.datatools.sqltools.sqleditor.saveAsTemplateAction", this.getAction("org.eclipse.datatools.sqltools.sqleditor.saveAsTemplateAction"));
        final Shell shell = this.getSourceViewer() != null ? this.getSourceViewer().getTextWidget().getShell() : null;
        a = new ResourceAction(bundle, "Editor.ContextPreferencesAction."){

            public void run() {
                String[] preferencePages = SQLEditor.this.collectContextMenuPreferencePages();
                if (!(preferencePages.length <= 0 || shell != null && shell.isDisposed())) {
                    PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)preferencePages[0], (String[])preferencePages, null).open();
                }
            }
        };
        a.setId("Preferences.ContextAction");
        this.setAction("Preferences.ContextAction", (IAction)a);
    }

    protected SQLEditorContentOutlinePage createContentOutlinePage() {
        SQLEditorContentOutlinePage outlinePage = new SQLEditorContentOutlinePage(this.getDocumentProvider(), this);
        return outlinePage;
    }

    public void createPartControl(Composite parent) {
        this.setupDocumentPartitioner();
        super.createPartControl(parent);
        this.setProjectionSupport(this.createProjectionSupport());
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        viewer.doOperation(19);
        ((TextViewer)this.getSourceViewer()).setDocumentPartitioning("___sql_partitioning");
        this.getSite().setSelectionProvider((ISelectionProvider)((SourceViewer)this.getSourceViewer()));
        this.hookContextMenu();
        this.installSQLUpdater();
        SQLEditorPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)new propertyChangeListener());
        IInformationControlCreator informationControlCreator = new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                boolean cutDown = false;
                int style = cutDown ? 0 : 768;
                return new DefaultInformationControl(shell, 16, style, null);
            }
        };
        this._informationPresenter = new InformationPresenter(informationControlCreator);
        this._informationPresenter.setSizeConstraints(60, 10, true, true);
        this._informationPresenter.install((ITextViewer)this.getSourceViewer());
        IPreferenceStore preferenceStore = SQLEditorPlugin.getDefault().getPreferenceStore();
        boolean closeSingleQuotes = preferenceStore.getBoolean("SQLEditor.closeSingleQuotes");
        boolean closeDoubleQuotes = preferenceStore.getBoolean("SQLEditor.closeDoubleQuotes");
        boolean closeBrackets = preferenceStore.getBoolean("SQLEditor.closeBrackets");
        this._symbolInserter.setCloseSingleQuotesEnabled(closeSingleQuotes);
        this._symbolInserter.setCloseDoubleQuotesEnabled(closeDoubleQuotes);
        this._symbolInserter.setCloseBracketsEnabled(closeBrackets);
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)sourceViewer).prependVerifyKeyListener((VerifyKeyListener)this._symbolInserter);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_CONTEXT_ID);
    }

    public void updatePartControl(IEditorInput input) {
        super.updatePartControl(input);
        this.refreshActionStatus();
    }

    private void hookContextMenu() {
        StyledText styledText = this.getSourceViewer().getTextWidget();
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                SQLEditor.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)styledText);
        styledText.setMenu(menu);
        this.getSite().registerContextMenu("org.eclipse.datatools.sqltools.sqleditor.SQLEditor", menuMgr, this.getSelectionProvider());
    }

    protected ProjectionSupport createProjectionSupport() {
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        ProjectionSupport projSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        projSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        projSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        projSupport.install();
        return projSupport;
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fAnnotationAccess = this.createAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        AdaptedSourceViewer viewer = this.doCreateSourceViewer(parent, ruler, styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    protected AdaptedSourceViewer doCreateSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        return new AdaptedSourceViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
    }

    protected SQLSourceViewerConfiguration createSourceViewerConfiguration() {
        SQLSourceViewerConfiguration config = SQLEditorContributorExtensionRegistry.getInstance().getSQLSourceViewerConfiguration();
        if (config == null) {
            config = new SQLSourceViewerConfiguration(this);
        } else {
            config.setSQLEditor(this);
        }
        ISQLDBProposalsService proposalsService = this.getDBProposalsService();
        if (proposalsService != null) {
            config.setDBProposalsService(proposalsService);
        }
        return config;
    }

    public void dispose() {
        SQLOutlinePage outlinePage = this.getOutlinePage();
        if (outlinePage != null) {
            outlinePage.setInput(null);
        }
        this.stopSQLUpdater();
        super.dispose();
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)sourceViewer).removeVerifyKeyListener((VerifyKeyListener)this._symbolInserter);
        }
    }

    public IEditorPart getParentEditor() {
        return this._parentEditor;
    }

    public void setParentEditor(IEditorPart editor) {
        this._parentEditor = editor;
    }

    public void doRevertToSaved() {
        super.doRevertToSaved();
        this.runUpdater();
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        this.runUpdater();
    }

    public void doSaveAs() {
        ISQLEditorConnectionInfo connInfo = this.getConnectionInfo();
        super.doSaveAs();
        this.setConnectionInfo(connInfo);
        this.setupDocumentPartitioner();
        this.runUpdater();
    }

    public void doSetInput(IEditorInput input) throws CoreException {
        IDocument doc;
        if (this._fSQLUpdater != null) {
            this._fSQLUpdater.removeMarkers();
            this.getSourceViewer().getDocument().removeDocumentListener((IDocumentListener)this._fSQLUpdater);
        }
        IDocumentProvider docProvider = this.getDocumentProvider();
        if (input instanceof FileEditorInput && (docProvider == null || !(docProvider instanceof FileDocumentProvider))) {
            docProvider = new FileDocumentProvider();
            this.setDocumentProvider(docProvider);
        }
        super.doSetInput(input);
        if (docProvider != null && (doc = docProvider.getDocument((Object)input)) != null) {
            SQLEditorDocumentSetupParticipant docSetupParticipant = this.getDocumentSetupParticipant();
            docSetupParticipant.setup(doc);
        }
        if (input instanceof ISQLEditorInput) {
            SourceViewerConfiguration config;
            ISQLEditorInput sqlEditorInput = (ISQLEditorInput)input;
            SQLDevToolsConfiguration toolsConfig = SQLToolsFacade.getConfigurationByVendorIdentifier((DatabaseVendorDefinitionId)this.getConnectionInfo().getDatabaseVendorDefinitionId());
            SQLEditorService editorService = toolsConfig.getSQLEditorService();
            this.fDBProposalsService = editorService.getSQLDBProposalsService(this.getConnectionInfo());
            if (this.fDBProposalsService == null) {
                this.fDBProposalsService = new SQLDBProposalsService(sqlEditorInput.getConnectionInfo());
            }
            if ((config = this.getSourceViewerConfiguration()) != null && config instanceof SQLSourceViewerConfiguration) {
                SQLSourceViewerConfiguration sqlConfig = (SQLSourceViewerConfiguration)config;
                sqlConfig.setDBProposalsService(this.fDBProposalsService);
            }
            this.setupDocumentPartitioner();
            IDocument document = this.getDocumentProvider().getDocument((Object)input);
            if (this._fSQLUpdater != null) {
                document.addDocumentListener((IDocumentListener)this._fSQLUpdater);
                this._fSQLUpdater.run();
            }
        }
        this.refreshConnectionStatus();
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        this.fillContextMenu(menu);
    }

    protected void fillContextMenu(IMenuManager menu) {
        HashMap dbActions;
        Collection extensions;
        IPlanOption planOption;
        menu.add((IContributionItem)new Separator("group.undo"));
        menu.add((IContributionItem)new Separator("group.sqleditor.open"));
        menu.add((IContributionItem)new Separator("group.copy"));
        menu.add((IContributionItem)new Separator("group.sqleditor.source"));
        menu.add((IContributionItem)new Separator("group.sqleditor.execute"));
        menu.add((IContributionItem)new Separator("group.sqleditor.wizard"));
        menu.add((IContributionItem)new Separator("group.sqleditor.save"));
        menu.add((IContributionItem)new Separator("group.sqleditor.addition"));
        menu.add((IContributionItem)new Separator("additions"));
        if (!this.isEditorInputReadOnly()) {
            this.addAction(menu, "group.undo", ITextEditorActionConstants.UNDO);
            if (this.getEditorInput() instanceof IFileEditorInput || this.getEditorInput() instanceof ILocationProvider) {
                this.addAction(menu, "group.undo", ITextEditorActionConstants.REVERT_TO_SAVED);
            }
            this.addAction(menu, "group.copy", ITextEditorActionConstants.CUT);
            this.addAction(menu, "group.copy", ITextEditorActionConstants.COPY);
            this.addAction(menu, "group.copy", ITextEditorActionConstants.PASTE);
        } else {
            this.addAction(menu, "group.copy", ITextEditorActionConstants.COPY);
        }
        menu.appendToGroup("group.sqleditor.source", this.getAction("org.eclipse.datatools.sqltools.sqleditor.toggleCommentAction"));
        menu.add((IContributionItem)new Separator());
        SQLDevToolsConfiguration config = SQLToolsFacade.getConfigurationByVendorIdentifier((DatabaseVendorDefinitionId)this.getConnectionInfo().getDatabaseVendorDefinitionId());
        ActionService actionServie = config.getActionService();
        SQLEditorService editorService = config.getSQLEditorService();
        if (actionServie.supportsAction("org.eclipse.datatools.sqltools.sqleditor.ExecuteSQLAction")) {
            this.addAction(menu, "group.sqleditor.execute", "org.eclipse.datatools.sqltools.sqleditor.ExecuteSQLAction");
        }
        if (actionServie.supportsAction("org.eclipse.datatools.sqltools.sqleditor.ExecuteSelectionAction")) {
            this.addAction(menu, "group.sqleditor.execute", "org.eclipse.datatools.sqltools.sqleditor.ExecuteSelectionAction");
        }
        if ((planOption = config.getPlanService().getPlanOption()) != null && actionServie.supportsAction("org.eclipse.datatools.sqltools.sqleditor.ExplainSQLAction")) {
            this.addAction(menu, "group.sqleditor.execute", "org.eclipse.datatools.sqltools.sqleditor.ExplainSQLAction");
        }
        this.addAction(menu, "group.sqleditor.save", "org.eclipse.datatools.sqltools.sqleditor.saveAsTemplateAction");
        if (actionServie.supportsAction("org.eclipse.datatools.sqltools.sqleditor.DMLDialogSelectionAction")) {
            this.addAction(menu, "group.sqleditor.addition", "org.eclipse.datatools.sqltools.sqleditor.DMLDialogSelectionAction");
        }
        if ((extensions = SQLEditorPlugin.getSQLEditorActionContributorExtension()) != null) {
            Iterator iter = extensions.iterator();
            while (iter.hasNext()) {
                ISQLEditorActionContributorExtension ext = (ISQLEditorActionContributorExtension)iter.next();
                ext.contributeToContextMenu(menu);
            }
        }
        if ((dbActions = editorService.getAdditionalActions()) != null && !dbActions.isEmpty()) {
            MenuManager dbSubMenuMgr = new MenuManager(config.getDatabaseVendorDefinitionId().toString(), "group.sqleditor.databases");
            ((IEditorSite)this.getSite()).getActionBars();
            Iterator iter = dbActions.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Object value = dbActions.get(key);
                if (value instanceof Collection) {
                    Iterator iterator = ((Collection)value).iterator();
                    while (iterator.hasNext()) {
                        this.addContributedMenus(key, iterator.next(), menu, dbSubMenuMgr);
                    }
                    continue;
                }
                this.addContributedMenus(key, value, menu, dbSubMenuMgr);
            }
            dbSubMenuMgr.add((IContributionItem)new Separator("additions"));
            menu.appendToGroup("group.sqleditor.addition", (IContributionItem)dbSubMenuMgr);
        }
        IAction preferencesAction = this.getAction("Preferences.ContextAction");
        menu.appendToGroup("additions", (IContributionItem)new Separator("settings"));
        menu.appendToGroup("settings", preferencesAction);
    }

    private void addContributedMenus(String key, Object dba, IMenuManager manager, MenuManager dbSubMenuMgr) {
        if (dba instanceof IEditorActionDelegate) {
            ((IEditorActionDelegate)dba).setActiveEditor(null, (IEditorPart)this);
        } else if (dba instanceof TextEditorAction) {
            ((TextEditorAction)dba).setEditor((ITextEditor)this);
        }
        if (dba instanceof IMenuManager) {
            IContributionItem[] items = ((IMenuManager)dba).getItems();
            int i = 0;
            while (i < items.length) {
                if (items[i] instanceof IEditorActionDelegate) {
                    ((IEditorActionDelegate)items[i]).setActiveEditor(null, (IEditorPart)this);
                } else if (items[i] instanceof TextEditorAction) {
                    ((TextEditorAction)items[i]).setEditor((ITextEditor)this);
                }
                ++i;
            }
        }
        if (key != null && !key.equals("")) {
            String subMgrId = key;
            String subGroupId = key;
            if (key.indexOf("/") > 0) {
                subMgrId = key.substring(0, key.indexOf("/"));
                subGroupId = key.substring(key.indexOf("/") + 1);
            }
            if (manager.find(subMgrId) != null) {
                IMenuManager subMgr = manager;
                if (manager.find(subMgrId) instanceof IMenuManager) {
                    subMgr = (IMenuManager)manager.find(subMgrId);
                }
                if (subMgr.find(subGroupId) != null) {
                    if (dba instanceof IAction) {
                        subMgr.appendToGroup(subGroupId, (IAction)dba);
                    } else if (dba instanceof IContributionItem) {
                        subMgr.appendToGroup(subGroupId, (IContributionItem)dba);
                    }
                }
            }
        } else if (dba instanceof IAction) {
            dbSubMenuMgr.add((IAction)dba);
        } else if (dba instanceof IContributionItem) {
            dbSubMenuMgr.add((IContributionItem)dba);
        }
    }

    public Object getAdapter(Class classForWhichAdapterNeeded) {
        Object adapter = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(classForWhichAdapterNeeded)) {
            if (this._fOutlinePage == null) {
                this._fOutlinePage = new SQLOutlinePage(this);
                this._fOutlineSelectionChangedListener.install(this._fOutlinePage);
                this.installSQLUpdater();
                this._fSQLUpdater.setOutlinePage(this._fOutlinePage);
            }
            adapter = this._fOutlinePage;
        } else {
            ProjectionSupport projSupport;
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.datatools.sqltools.sqleditor.SQLEditor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz2.equals(classForWhichAdapterNeeded)) {
                return this;
            }
            if (adapter == null && (projSupport = this.getProjectionSupport()) != null) {
                adapter = projSupport.getAdapter(this.getSourceViewer(), classForWhichAdapterNeeded);
            }
        }
        if (adapter == null) {
            adapter = super.getAdapter(classForWhichAdapterNeeded);
        }
        return adapter;
    }

    public ISQLEditorConnectionInfo getConnectionInfo() {
        if (this.getEditorInput() instanceof ISQLEditorInput) {
            return ((ISQLEditorInput)this.getEditorInput()).getConnectionInfo();
        }
        return SQLEditorConnectionInfo.DEFAULT_SQLEDITOR_CONNECTION_INFO;
    }

    public void setConnectionInfo(ISQLEditorConnectionInfo connInfo) {
        if (this.getEditorInput() instanceof ISQLEditorInput) {
            ISQLEditorConnectionInfo oldConnInfo = this.getConnectionInfo();
            ((ISQLEditorInput)this.getEditorInput()).setConnectionInfo(connInfo);
            this.fDBProposalsService.setSQLEditorConnectionInfo(connInfo);
            if (connInfo != null && !connInfo.getDatabaseVendorDefinitionId().equals((Object)oldConnInfo.getDatabaseVendorDefinitionId())) {
                ((ISourceViewerExtension2)this.getSourceViewer()).unconfigure();
                SQLSourceViewerConfiguration configuration = this.createSourceViewerConfiguration();
                this.setSourceViewerConfiguration(configuration);
                this.getSourceViewer().configure((SourceViewerConfiguration)configuration);
                this.setInput(this.getEditorInput());
                ((ISQLEditorInput)this.getEditorInput()).setConnectionInfo(connInfo);
            }
            SQLEditorPlugin.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    SQLEditor.this.refreshActionStatus();
                    SQLEditor.this.refreshConnectionStatus();
                    SQLEditor.this._fSQLUpdater.run();
                    SQLEditor.this.fireConnectionProfileAttached();
                }
            });
        }
    }

    public void requestConnection() {
    }

    public Database getDatabase() {
        if (this.getEditorInput() instanceof ISQLEditorInput) {
            return ((ISQLEditorInput)this.getEditorInput()).getConnectionInfo().getDatabase();
        }
        return null;
    }

    public ISQLDBProposalsService getDBProposalsService() {
        return this.fDBProposalsService;
    }

    public String getDefaultSchemaName() {
        if (this.getEditorInput() instanceof ISQLEditorInput) {
            return ((ISQLEditorInput)this.getEditorInput()).getConnectionInfo().getDefaultSchemaName();
        }
        return null;
    }

    public SQLEditorDocumentSetupParticipant getDocumentSetupParticipant() {
        if (this.fDocSetupParticipant == null) {
            this.fDocSetupParticipant = new SQLEditorDocumentSetupParticipant();
        }
        return this.fDocSetupParticipant;
    }

    protected SQLOutlinePage getOutlinePage() {
        return this._fOutlinePage;
    }

    protected ProjectionSupport getProjectionSupport() {
        return this.fProjectionSupport;
    }

    public ResourceBundle getResourceBundle() {
        return SQLEditorResources.getResourceBundle();
    }

    public SQLColorProvider getSQLColorProvider() {
        return SQLEditorPlugin.getDefault().getSQLColorProvider();
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setDocumentProvider((IDocumentProvider)new SQLStorageDocumentProvider());
        this.setSourceViewerConfiguration(this.createSourceViewerConfiguration());
        this.setRulerContextMenuId("#SQLEditorRulerContext");
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        this.setHelpContextId("org.eclipse.datatools.sqltools.sqleditor.sql_file_editor");
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("Connection")) {
            this.refreshConnectionStatus();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void performSaveAs(IProgressMonitor progressMonitor) {
        IFile original;
        Shell shell = this.getSite().getShell();
        IEditorInput input = this.getEditorInput();
        IDocumentProvider provider = this.getDocumentProvider();
        SaveAsDialog dialog = new SaveAsDialog(shell, false);
        IFile iFile = original = input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
        if (original != null) {
            dialog.setOriginalFile(original);
        }
        dialog.create();
        if (provider.isDeleted((Object)input) && original != null) {
            String message = NLS.bind((String)SQLEditorResources.SQLEditor_file_deleted_or_not_accessible, (Object)original.getName());
            dialog.setErrorMessage(null);
            dialog.setMessage(message, 2);
        }
        if (dialog.open() == 1) {
            if (progressMonitor != null) {
                progressMonitor.setCanceled(true);
            }
            return;
        }
        IPath filePath = dialog.getResult();
        if (filePath == null) {
            if (progressMonitor != null) {
                progressMonitor.setCanceled(true);
            }
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile file = workspace.getRoot().getFile(filePath);
        FileEditorInput newInput = new FileEditorInput(file);
        if (provider == null) {
            return;
        }
        boolean success = false;
        try {
            try {
                provider.aboutToChange((Object)newInput);
                provider.saveDocument(progressMonitor, (Object)newInput, provider.getDocument((Object)input), true);
                success = true;
            }
            catch (CoreException x) {
                IStatus status = x.getStatus();
                if (status == null || status.getSeverity() != 8) {
                    String title = SQLEditorResources.SQLEditor_problem_save_as;
                    String msg = NLS.bind((String)SQLEditorResources.SQLEditor_could_not_save_as, (Object)x.getMessage());
                    MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                }
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            provider.changed((Object)newInput);
            if (success) {
                this.setInput((IEditorInput)newInput);
            }
            throw throwable;
        }
        {
            Object var11_15 = null;
        }
        provider.changed((Object)newInput);
        if (success) {
            this.setInput((IEditorInput)newInput);
        }
        if (progressMonitor != null) {
            progressMonitor.setCanceled(!success);
        }
    }

    public void setDocumentSetupParticipant(SQLEditorDocumentSetupParticipant docSetupParticipant) {
        this.fDocSetupParticipant = docSetupParticipant;
    }

    public void setFocus() {
        super.setFocus();
        this.refreshConnectionStatus();
    }

    protected void setProjectionSupport(ProjectionSupport projSupport) {
        this.fProjectionSupport = projSupport;
    }

    protected void runUpdater() {
        if (this._fSQLUpdater != null) {
            this._fSQLUpdater.run();
        }
    }

    public ISQLEditorConnectionInfo requestConnectionFromUser() {
        return null;
    }

    public ISourceViewer getSV() {
        return this.getSourceViewer();
    }

    public void outlinePageClosed() {
        if (this._fOutlinePage != null) {
            this._fOutlineSelectionChangedListener.uninstall(this._fOutlinePage);
            this._fOutlinePage = null;
        }
    }

    private void stopSQLUpdater() {
        try {
            IPreferenceStore preferenceStore;
            this._fSQLUpdater.removeMarkers();
            this._fSQLUpdater.setOutlinePage(null);
            if (this.getSourceViewer().getDocument() != null) {
                this.getSourceViewer().getDocument().removeDocumentListener((IDocumentListener)this._fSQLUpdater);
            }
            if ((preferenceStore = SQLEditorPlugin.getDefault().getPreferenceStore()) != null) {
                preferenceStore.removePropertyChangeListener((IPropertyChangeListener)this._fSQLUpdater);
            }
            this.getSite().getShell().getDisplay().timerExec(-1, (Runnable)this._fSQLUpdater);
        }
        catch (RuntimeException runtimeException) {}
    }

    private void installSQLUpdater() {
        try {
            if (this._fSQLUpdater == null) {
                this._fSQLUpdater = new SQLUpdater(this);
                this.getSourceViewer().getDocument().addDocumentListener((IDocumentListener)this._fSQLUpdater);
                IPreferenceStore preferenceStore = SQLEditorPlugin.getDefault().getPreferenceStore();
                if (preferenceStore != null) {
                    preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this._fSQLUpdater);
                }
                this._fSQLUpdater.run();
            }
        }
        catch (Throwable e) {
            SQLEditorPlugin.getDefault().log(SQLEditorResources.SQLEditor_error_while_trying_to_install_sql_updater, e);
        }
    }

    protected void setSelection(SimpleNode node) {
        ISourceViewer viewer = this.getSourceViewer();
        if (viewer == null) {
            return;
        }
        StyledText widget = viewer.getTextWidget();
        widget.setRedraw(false);
        if (node != null) {
            int offset = node.getStartOffset(viewer.getDocument());
            int length = node.getEndOffset(viewer.getDocument()) - offset;
            try {
                this.setHighlightRange(offset, length, true);
            }
            catch (Exception exception) {}
            viewer.revealRange(offset, length);
            viewer.setSelectedRange(offset, length);
        } else {
            this.resetHighlightRange();
            viewer.setSelectedRange(widget.getCaretOffset(), 0);
        }
        widget.setRedraw(true);
    }

    public ParsingResult getParsingResult() {
        if (this._fSQLUpdater.needToParse()) {
            ISQLEditorConnectionInfo connInfo = this.getConnectionInfo();
            SQLDevToolsConfiguration conf = SQLToolsFacade.getConfiguration((DatabaseIdentifier)this.getDatabaseIdentifier(), (DatabaseVendorDefinitionId)connInfo.getDatabaseVendorDefinitionId());
            SQLParser parser = conf.getSQLService().getSQLParser();
            if (parser == null) {
                return null;
            }
            String content = this.getSourceViewer().getDocument().get();
            content = String.valueOf(content) + "\n";
            boolean useDelimiter = this.getSQLType() == 100;
            this._parsingResult = parser.parse(content, new ParserParameters(useDelimiter, this.getSQLType()));
            this._parsingResult.getRootNode().setDocument(this.getSV().getDocument());
            this._fSQLUpdater.setNeedToParse(false);
        }
        return this._parsingResult;
    }

    public void setParsingResult(ParsingResult result) {
        this._parsingResult = result;
    }

    protected void setupDocumentPartitioner() {
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        DatabaseVendorDefinitionId vendorId = this.getConnectionInfo().getDatabaseVendorDefinitionId();
        SQLDevToolsConfiguration factory = SQLToolsFacade.getConfigurationByVendorIdentifier((DatabaseVendorDefinitionId)vendorId);
        SQLPartitionScanner _sqlPartitionSanner = new SQLPartitionScanner(factory.getSQLService().getSQLSyntax());
        if (document instanceof IDocumentExtension3) {
            IDocumentExtension3 extension3 = (IDocumentExtension3)document;
            FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)_sqlPartitionSanner, new String[]{"sql_comment", "sql_multiline_comment", "sql_character", "sql_double_quotes_identifier"});
            partitioner.connect(document);
            extension3.setDocumentPartitioner("___sql_partitioning", (IDocumentPartitioner)partitioner);
        }
    }

    protected void refreshActionStatus() {
        Collection extensions;
        ArrayList<IAction> actionList = new ArrayList<IAction>();
        IAction action = this.getAction("org.eclipse.datatools.sqltools.sqleditor.ExecuteSelectionAction");
        if (action != null) {
            actionList.add(action);
        }
        if ((action = this.getAction("org.eclipse.datatools.sqltools.sqleditor.ExecuteSQLAction")) != null) {
            actionList.add(action);
        }
        if ((extensions = SQLEditorPlugin.getSQLEditorActionContributorExtension()) != null) {
            Iterator iter = extensions.iterator();
            while (iter.hasNext()) {
                ISQLEditorActionContributorExtension ext = (ISQLEditorActionContributorExtension)iter.next();
                ext.updateAction();
            }
        }
        Iterator iterator = actionList.iterator();
        while (iterator.hasNext()) {
            IUpdate textEditorAction = (IUpdate)iterator.next();
            if (textEditorAction == null) continue;
            textEditorAction.update();
        }
    }

    public void refreshConnectionStatus() {
        IActionBars actionBars;
        IEditorSite editorSite = this.getEditorSite();
        if (editorSite != null && (actionBars = editorSite.getActionBars()) != null) {
            IStatusLineManager statusLineMgr = actionBars.getStatusLineManager();
            ISQLEditorConnectionInfo connInfo = this.getConnectionInfo();
            if (connInfo != null) {
                statusLineMgr.setErrorMessage(null);
                String connStatus = connInfo.getName();
                statusLineMgr.setMessage(connStatus);
            } else {
                String connStatus = SQLEditorResources.SQLEditor_connection_status_noConnection;
                statusLineMgr.setErrorMessage(connStatus);
            }
            actionBars.updateActionBars();
        }
    }

    public String getText() {
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        return document.get();
    }

    public String getSelectedText() {
        String sql = null;
        if (this.getSelectionProvider() == null) {
            return null;
        }
        ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
        if (!selection.isEmpty() && selection.getText() != null && !selection.getText().equals("")) {
            sql = selection.getText();
        }
        return sql;
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.datatools.sqltools.SQLEditorScope"});
    }

    public int getOrientation() {
        return 0x2000000;
    }

    public String getTargetText() {
        String sql = this.getSelectedText();
        if (sql == null) {
            IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
            sql = document.get();
        }
        return sql;
    }

    private void configureToggleCommentAction(IAction action) {
        if (action instanceof ToggleCommentAction) {
            ISourceViewer sourceViewer = this.getSourceViewer();
            SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
            ((ToggleCommentAction)action).configure(sourceViewer, configuration);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        try {
            block7: {
                block9: {
                    String p;
                    block11: {
                        IPreferenceStore preferenceStore;
                        block10: {
                            block8: {
                                if (this.getSourceViewer() == null) break block7;
                                p = event.getProperty();
                                preferenceStore = SQLEditorPlugin.getDefault().getPreferenceStore();
                                if (!"SQLEditor.closeSingleQuotes".equals(p)) break block8;
                                this._symbolInserter.setCloseSingleQuotesEnabled(preferenceStore.getBoolean(p));
                                break block9;
                            }
                            if (!"SQLEditor.closeDoubleQuotes".equals(p)) break block10;
                            this._symbolInserter.setCloseDoubleQuotesEnabled(preferenceStore.getBoolean(p));
                            break block9;
                        }
                        if (!"SQLEditor.closeBrackets".equals(p)) break block11;
                        this._symbolInserter.setCloseBracketsEnabled(preferenceStore.getBoolean(p));
                        break block9;
                    }
                    if (!"syntax.validation".equals(p)) break block7;
                    if (this._fSQLUpdater != null) {
                        this._fSQLUpdater.run();
                    }
                }
                Object var4_4 = null;
                super.handlePreferenceStoreChanged(event);
                return;
            }
            Object var4_6 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            super.handlePreferenceStoreChanged(event);
            throw throwable;
        }
        super.handlePreferenceStoreChanged(event);
    }

    public int getSQLType() {
        return 100;
    }

    public void addConnectionProfileAttachListener(IConnectionProfileAttachListener listener) {
        if (!this._profileListeners.contains(listener)) {
            this._profileListeners.add(listener);
        }
    }

    public void removeConnectionProfileAttachListener(IConnectionProfileAttachListener listener) {
        this._profileListeners.remove(listener);
    }

    public void fireConnectionProfileAttached() {
        Iterator iter = this._profileListeners.iterator();
        while (iter.hasNext()) {
            IConnectionProfileAttachListener l = (IConnectionProfileAttachListener)iter.next();
            l.connectionProfileAttached(this);
        }
    }

    public DatabaseIdentifier getDatabaseIdentifier() {
        ISQLEditorConnectionInfo connInfo = this.getConnectionInfo();
        if (connInfo != null && connInfo.getConnectionProfileName() != null) {
            return new DatabaseIdentifier(connInfo.getConnectionProfileName(), connInfo.getDatabaseName());
        }
        return null;
    }

    public String getDBType() {
        return this.getConnectionInfo().getDatabaseVendorDefinitionId().toString();
    }

    public void insert(String sqlText) {
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
        int start = 0;
        int length = 0;
        if (!selection.isEmpty()) {
            start = selection.getOffset();
            length = selection.getLength();
            if (length < 0) {
                length = -length;
                start -= length;
            }
        }
        try {
            document.replace(start, length, sqlText);
        }
        catch (BadLocationException e) {
            IActionBars actionBars;
            IEditorSite editorSite = this.getEditorSite();
            if (editorSite != null && (actionBars = editorSite.getActionBars()) != null) {
                IStatusLineManager statusLineMgr = actionBars.getStatusLineManager();
                statusLineMgr.setErrorMessage(e.getLocalizedMessage());
            }
            SQLEditorPlugin.getDefault().log(e);
        }
    }

    public boolean isConnected() {
        return this.getConnectionInfo().isConnected();
    }

    protected String[] collectContextMenuPreferencePages() {
        String[] parent = super.collectContextMenuPreferencePages();
        String[] prefs = new String[parent.length + 1];
        System.arraycopy(parent, 0, prefs, 1, parent.length);
        prefs[0] = "org.eclipse.datatools.sqltools.sqleditor.preferences.SQLEditor";
        return prefs;
    }

    protected abstract class AbstractSelectionChangedListener
    implements ISelectionChangedListener {
        protected AbstractSelectionChangedListener() {
        }

        public void install(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.addPostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void uninstall(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.removePostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }
    }

    public class AdaptedSourceViewer
    extends ProjectionViewer {
        public AdaptedSourceViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles) {
            super(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles);
        }

        public IContentAssistant getContentAssistant() {
            return this.fContentAssistant;
        }
    }

    private final class InformationDispatchAction
    extends TextEditorAction {
        private final TextOperationAction fTextOperationAction;

        public InformationDispatchAction(ResourceBundle resourceBundle, String prefix, TextOperationAction textOperationAction) {
            super(resourceBundle, prefix, (ITextEditor)SQLEditor.this);
            if (textOperationAction == null) {
                throw new IllegalArgumentException();
            }
            this.fTextOperationAction = textOperationAction;
        }

        public void run() {
            IAnnotationHover annotationHover;
            ITextHover textHover;
            ITextViewerExtension4 extension4;
            ISourceViewer sourceViewer = SQLEditor.this.getSourceViewer();
            if (sourceViewer == null) {
                if (this.fTextOperationAction.isEnabled()) {
                    this.fTextOperationAction.run();
                }
                return;
            }
            if (sourceViewer instanceof ITextViewerExtension4 && (extension4 = (ITextViewerExtension4)sourceViewer).moveFocusToWidgetToken()) {
                return;
            }
            if (sourceViewer instanceof ITextViewerExtension2 && (textHover = ((ITextViewerExtension2)sourceViewer).getCurrentTextHover()) != null && this.makeTextHoverFocusable(sourceViewer, textHover)) {
                return;
            }
            if (sourceViewer instanceof ISourceViewerExtension3 && (annotationHover = ((ISourceViewerExtension3)sourceViewer).getCurrentAnnotationHover()) != null && this.makeAnnotationHoverFocusable(sourceViewer, annotationHover)) {
                return;
            }
            if (this.fTextOperationAction.isEnabled()) {
                this.fTextOperationAction.run();
            }
        }

        private boolean makeTextHoverFocusable(ISourceViewer sourceViewer, ITextHover textHover) {
            IRegion hoverRegion;
            int offset;
            block5: {
                Point hoverEventLocation = ((ITextViewerExtension2)sourceViewer).getHoverEventLocation();
                offset = this.computeOffsetAtLocation((ITextViewer)sourceViewer, hoverEventLocation.x, hoverEventLocation.y);
                if (offset == -1) {
                    return false;
                }
                try {
                    hoverRegion = textHover.getHoverRegion((ITextViewer)sourceViewer, offset);
                    if (hoverRegion != null) break block5;
                    return false;
                }
                catch (BadLocationException badLocationException) {
                    return false;
                }
            }
            String hoverInfo = textHover.getHoverInfo((ITextViewer)sourceViewer, hoverRegion);
            IInformationControlCreator controlCreator = null;
            if (textHover instanceof IInformationProviderExtension2) {
                controlCreator = ((IInformationProviderExtension2)textHover).getInformationPresenterControlCreator();
            }
            InformationProvider informationProvider = new InformationProvider(hoverRegion, hoverInfo, controlCreator);
            SQLEditor.this._informationPresenter.setOffset(offset);
            SQLEditor.this._informationPresenter.setAnchor(AbstractInformationControlManager.ANCHOR_BOTTOM);
            SQLEditor.this._informationPresenter.setMargins(6, 6);
            String contentType = TextUtilities.getContentType((IDocument)sourceViewer.getDocument(), (String)SQLEditor.this.getSourceViewerConfiguration().getConfiguredDocumentPartitioning(SQLEditor.this.getSourceViewer()), (int)offset, (boolean)true);
            SQLEditor.this._informationPresenter.setInformationProvider((IInformationProvider)informationProvider, contentType);
            SQLEditor.this._informationPresenter.showInformation();
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean makeAnnotationHoverFocusable(ISourceViewer sourceViewer, IAnnotationHover annotationHover) {
            IVerticalRuler info = SQLEditor.this.getVerticalRuler();
            int line = info.getLineOfLastMouseButtonActivity();
            if (line == -1) {
                return false;
            }
            try {
                Object hoverInfo;
                if (annotationHover instanceof IAnnotationHoverExtension) {
                    IAnnotationHoverExtension extension = (IAnnotationHoverExtension)annotationHover;
                    ILineRange hoverLineRange = extension.getHoverLineRange(sourceViewer, line);
                    if (hoverLineRange == null) {
                        return false;
                    }
                    hoverInfo = extension.getHoverInfo(sourceViewer, hoverLineRange, Integer.MAX_VALUE);
                } else {
                    hoverInfo = annotationHover.getHoverInfo(sourceViewer, line);
                }
                IDocument document = sourceViewer.getDocument();
                int offset = document.getLineOffset(line);
                String contentType = TextUtilities.getContentType((IDocument)document, (String)SQLEditor.this.getSourceViewerConfiguration().getConfiguredDocumentPartitioning(SQLEditor.this.getSourceViewer()), (int)offset, (boolean)true);
                IInformationControlCreator controlCreator = null;
                if (annotationHover instanceof IInformationProviderExtension2) {
                    controlCreator = ((IInformationProviderExtension2)annotationHover).getInformationPresenterControlCreator();
                } else if (annotationHover instanceof IAnnotationHoverExtension) {
                    controlCreator = ((IAnnotationHoverExtension)annotationHover).getHoverControlCreator();
                }
                InformationProvider informationProvider = new InformationProvider((IRegion)new Region(offset, 0), hoverInfo, controlCreator);
                SQLEditor.this._informationPresenter.setOffset(offset);
                SQLEditor.this._informationPresenter.setAnchor(AbstractInformationControlManager.ANCHOR_RIGHT);
                SQLEditor.this._informationPresenter.setMargins(4, 0);
                SQLEditor.this._informationPresenter.setInformationProvider((IInformationProvider)informationProvider, contentType);
                SQLEditor.this._informationPresenter.showInformation();
                return true;
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }

        private int computeOffsetAtLocation(ITextViewer textViewer, int x, int y) {
            StyledText styledText = textViewer.getTextWidget();
            IDocument document = textViewer.getDocument();
            if (document == null) {
                return -1;
            }
            try {
                int widgetOffset = styledText.getOffsetAtLocation(new Point(x, y));
                Point p = styledText.getLocationAtOffset(widgetOffset);
                if (p.x > x) {
                    --widgetOffset;
                }
                if (textViewer instanceof ITextViewerExtension5) {
                    ITextViewerExtension5 extension = (ITextViewerExtension5)textViewer;
                    return extension.widgetOffset2ModelOffset(widgetOffset);
                }
                IRegion visibleRegion = textViewer.getVisibleRegion();
                return widgetOffset + visibleRegion.getOffset();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return -1;
            }
        }
    }

    private static final class InformationProvider
    implements IInformationProvider,
    IInformationProviderExtension,
    IInformationProviderExtension2 {
        private IRegion fHoverRegion;
        private Object fHoverInfo;
        private IInformationControlCreator fControlCreator;

        InformationProvider(IRegion hoverRegion, Object hoverInfo, IInformationControlCreator controlCreator) {
            this.fHoverRegion = hoverRegion;
            this.fHoverInfo = hoverInfo;
            this.fControlCreator = controlCreator;
        }

        public IRegion getSubject(ITextViewer textViewer, int invocationOffset) {
            return this.fHoverRegion;
        }

        public String getInformation(ITextViewer textViewer, IRegion subject) {
            return this.fHoverInfo.toString();
        }

        public Object getInformation2(ITextViewer textViewer, IRegion subject) {
            return this.fHoverInfo;
        }

        public IInformationControlCreator getInformationPresenterControlCreator() {
            return this.fControlCreator;
        }
    }

    protected class OutlineSelectionChangedListener
    extends AbstractSelectionChangedListener {
        protected OutlineSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            Object element = ((IStructuredSelection)selection).getFirstElement();
            SimpleNode node = element instanceof SimpleNode ? (SimpleNode)element : null;
            SQLEditor.this.setSelection(node);
        }
    }

    class propertyChangeListener
    implements IPropertyChangeListener {
        propertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            AdaptedSourceViewer asv = (AdaptedSourceViewer)SQLEditor.this.getSourceViewer();
            if (asv != null) {
                event.getProperty();
                ContentAssistant contentAssistant = (ContentAssistant)asv.getContentAssistant();
                if (contentAssistant instanceof ContentAssistant) {
                    ContentAssistPreference.changeConfiguration(contentAssistant, SQLEditor.this.getPreferenceStore(), event);
                }
                SQLEditor.this.handlePreferenceStoreChanged(event);
            }
        }
    }
}

